/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.util.MediatorPropertyUtils;

public class MediatorProperty {
    public static final QName PROPERTY_Q = new QName("http://ws.apache.org/ns/synapse", "property");
    public static final QName ATT_NAME_Q = new QName("", "name");
    public static final QName ATT_VALUE_Q = new QName("", "value");
    public static final QName ATT_EXPR_Q = new QName("", "expression");
    public static final QName ATT_SCOPE_Q = new QName("", "scope");
    private String name;
    private String value;
    private SynapsePath expression;
    private Object object;
    private String scope;

    public void evaluate(MessageContext synCtx) {
        String result;
        if (this.value != null) {
            result = this.value;
        } else if (this.expression != null) {
            result = this.expression.stringValueOf(synCtx);
        } else {
            throw new SynapseException("A value or expression must be specified");
        }
        if (this.scope == null || "default".equals(this.scope)) {
            synCtx.setProperty(this.name, result);
        } else if ("axis2".equals(this.scope)) {
            Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
            org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
            axis2MessageCtx.setProperty(this.name, (Object)result);
            MediatorPropertyUtils.handleSpecialProperties(this.name, result, axis2MessageCtx);
        } else if ("axis2-client".equals(this.scope)) {
            Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
            org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
            axis2MessageCtx.getOptions().setProperty(this.name, (Object)result);
        } else if ("transport".equals(this.scope)) {
            HashMap<String, String> headersMap;
            Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
            org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
            Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
            if (headers != null && headers instanceof Map) {
                headersMap = (HashMap<String, String>)headers;
                headersMap.put(this.name, result);
            }
            if (headers == null) {
                headersMap = new HashMap<String, String>();
                headersMap.put(this.name, result);
                axis2MessageCtx.setProperty("TRANSPORT_HEADERS", headersMap);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public SynapsePath getExpression() {
        return this.expression;
    }

    public void setExpression(SynapsePath expression) {
        this.expression = expression;
    }

    public String getEvaluatedExpression(MessageContext synCtx) {
        return this.expression.stringValueOf(synCtx);
    }
}

