/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.util.logging.LoggingUtils;

public class MediatorLog
implements SynapseLog {
    private static final Log traceLog = LogFactory.getLog((String)"TRACE_LOGGER");
    private final Log defaultLog;
    private final boolean traceOn;
    private final MessageContext synCtx;

    public MediatorLog(Log defaultLog, boolean traceOn, MessageContext synCtx) {
        this.defaultLog = defaultLog;
        this.traceOn = traceOn;
        this.synCtx = synCtx;
    }

    @Override
    public boolean isTraceOrDebugEnabled() {
        return this.traceOn || this.isDebugEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        if (this.defaultLog.isDebugEnabled()) {
            return true;
        }
        return this.synCtx.getServiceLog() != null && this.synCtx.getServiceLog().isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        if (this.defaultLog.isTraceEnabled()) {
            return true;
        }
        return this.synCtx.getServiceLog() != null && this.synCtx.getServiceLog().isTraceEnabled();
    }

    @Override
    public void traceOrDebug(Object msg) {
        String formattedMsg = LoggingUtils.getFormattedLog(this.synCtx, msg);
        this.defaultLog.debug((Object)formattedMsg);
        if (this.traceOn) {
            traceLog.info((Object)formattedMsg);
        }
    }

    @Override
    public void traceOrDebugWarn(Object msg) {
        String formattedMsg = LoggingUtils.getFormattedLog(this.synCtx, msg);
        if (this.traceOn) {
            traceLog.warn((Object)formattedMsg);
        }
        if (this.defaultLog.isDebugEnabled()) {
            this.defaultLog.warn((Object)formattedMsg);
        }
    }

    @Override
    public boolean isTraceTraceEnabled() {
        return this.traceOn && traceLog.isTraceEnabled();
    }

    @Override
    public void traceTrace(Object msg) {
        if (this.traceOn) {
            traceLog.trace((Object)LoggingUtils.getFormattedLog(this.synCtx, msg));
        }
    }

    @Override
    public void auditLog(Object msg) {
        String formattedMsg = LoggingUtils.getFormattedLog(this.synCtx, msg);
        this.defaultLog.info((Object)formattedMsg);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().info(msg);
        }
        if (this.traceOn) {
            traceLog.info((Object)formattedMsg);
        }
    }

    @Override
    public void auditDebug(Object msg) {
        String formattedMsg = LoggingUtils.getFormattedLog(this.synCtx, msg);
        this.defaultLog.debug((Object)formattedMsg);
        if (this.synCtx.getServiceLog() != null && this.synCtx.getServiceLog().isDebugEnabled()) {
            this.synCtx.getServiceLog().debug(msg);
        }
        if (this.traceOn) {
            traceLog.debug((Object)formattedMsg);
        }
    }

    @Override
    public void auditTrace(Object msg) {
        String formattedMsg = LoggingUtils.getFormattedLog(this.synCtx, msg);
        if (this.defaultLog.isTraceEnabled()) {
            this.defaultLog.trace((Object)formattedMsg);
        }
        if (this.synCtx.getServiceLog() != null && this.synCtx.getServiceLog().isTraceEnabled()) {
            this.synCtx.getServiceLog().trace(msg);
        }
        if (this.traceOn) {
            traceLog.trace((Object)formattedMsg);
        }
    }

    @Override
    public void auditWarn(Object msg) {
        String formattedMsg = LoggingUtils.getFormattedLog(this.synCtx, msg);
        this.defaultLog.warn((Object)formattedMsg);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().warn(msg);
        }
        if (this.traceOn) {
            traceLog.warn((Object)formattedMsg);
        }
    }

    @Override
    public void auditError(Object msg) {
        String formattedMsg = LoggingUtils.getFormattedLog(this.synCtx, msg);
        this.defaultLog.error((Object)formattedMsg);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().error(msg);
        }
        if (this.traceOn) {
            traceLog.error((Object)formattedMsg);
        }
    }

    @Override
    public void auditFatal(Object msg) {
        String formattedMsg = LoggingUtils.getFormattedLog(this.synCtx, msg);
        this.defaultLog.fatal((Object)formattedMsg);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().fatal(msg);
        }
        if (this.traceOn) {
            traceLog.fatal((Object)formattedMsg);
        }
    }

    @Override
    public void error(Object msg) {
        String formattedMsg = LoggingUtils.getFormattedLog(this.synCtx, msg);
        this.defaultLog.error((Object)formattedMsg);
        if (this.traceOn) {
            traceLog.error((Object)formattedMsg);
        }
    }

    @Override
    public void logSynapseException(String msg, Throwable cause) {
        String formattedMsg = LoggingUtils.getFormattedLog(this.synCtx, msg);
        this.defaultLog.error((Object)formattedMsg, cause);
        if (this.synCtx.getServiceLog() != null) {
            this.synCtx.getServiceLog().error((Object)msg, cause);
        }
        if (this.traceOn) {
            traceLog.error((Object)formattedMsg, cause);
        }
    }
}

