/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.FaultStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.util.ConcurrencyThrottlingUtils;

public class MediatorFaultHandler
extends FaultHandler {
    private static final Log log = LogFactory.getLog(MediatorFaultHandler.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private Mediator faultMediator = null;

    public MediatorFaultHandler(Mediator faultMediator) {
        this.faultMediator = faultMediator;
    }

    @Override
    public void onFault(MessageContext synCtx) throws SynapseException {
        boolean traceOn = synCtx.getTracingState() == 1;
        boolean traceOrDebugOn = traceOn || log.isDebugEnabled();
        boolean isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        if (isStatisticsEnabled) {
            FaultStatisticCollector.reportFault(synCtx);
        }
        String name = null;
        if (this.faultMediator instanceof SequenceMediator) {
            name = ((SequenceMediator)this.faultMediator).getName();
            ContinuationStackManager.clearStack(synCtx);
            synCtx.setProperty("continuation.call", false);
        }
        if (name == null) {
            name = this.faultMediator.getClass().getName();
        }
        if (traceOrDebugOn) {
            this.traceOrDebugWarn(traceOn, "Executing fault handler mediator : " + name);
        }
        ConcurrencyThrottlingUtils.decrementConcurrencyThrottleAccessController(synCtx);
        synCtx.getServiceLog().warn((Object)("Executing fault sequence mediator : " + name));
        this.faultMediator.mediate(synCtx);
        if (isStatisticsEnabled) {
            CloseEventCollector.closeFlowForcefully(synCtx, true);
        }
    }

    public Mediator getFaultMediator() {
        return this.faultMediator;
    }

    public void setFaultMediator(Mediator faultMediator) {
        this.faultMediator = faultMediator;
    }

    private void traceOrDebugWarn(boolean traceOn, String msg) {
        if (traceOn) {
            trace.warn((Object)msg);
        }
        log.warn((Object)msg);
    }
}

