/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfigurable;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.debug.constructs.SynapseMediationFlowPoint;
import org.apache.synapse.mediators.FlowContinuableMediator;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.MediatorLog;
import org.apache.synapse.util.logging.LoggingUtils;

public abstract class AbstractMediator
implements Mediator,
AspectConfigurable {
    protected Log log;
    protected static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    protected int traceState = 2;
    private AspectConfiguration aspectConfiguration;
    private String description;
    private String shortDescription;
    private int mediatorPosition = 0;
    private boolean isBreakPoint = false;
    private boolean isSkipEnabled = false;
    private SynapseMediationFlowPoint flowPoint = null;
    private List<String> commentsList = new ArrayList<String>();

    protected AbstractMediator() {
        this.log = LogFactory.getLog(this.getClass());
    }

    public boolean divertMediationRoute(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled()) {
            if (this.isSkipEnabled()) {
                synCtx.getEnvironment().getSynapseDebugManager().advertiseMediationFlowSkip(synCtx, this.getRegisteredMediationFlowPoint());
                return true;
            }
            if (this.isBreakPoint()) {
                synCtx.getEnvironment().getSynapseDebugManager().advertiseMediationFlowBreakPoint(synCtx, this.getRegisteredMediationFlowPoint());
            }
        }
        return false;
    }

    @Override
    public String getType() {
        String cls = this.getClass().getName();
        int p = cls.lastIndexOf(".");
        if (p == -1) {
            return cls;
        }
        return cls.substring(p + 1);
    }

    @Override
    public int getTraceState() {
        return this.traceState;
    }

    @Override
    public void setTraceState(int traceState) {
        this.traceState = traceState;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setEffectiveTraceState(MessageContext synCtx) {
        if (this.traceState != 2) {
            synCtx.setTracingState(this.traceState);
        }
    }

    protected SynapseLog getLog(MessageContext synCtx) {
        return new MediatorLog(this.log, this.isTraceOn(synCtx), synCtx);
    }

    public boolean shouldTrace(int parentTraceState) {
        return this.traceState == 1 || this.traceState == 2 && parentTraceState == 1;
    }

    public boolean shouldTrace(MessageContext msgCtx) {
        return this.isTracingEnabled() || this.shouldCaptureTracing(msgCtx);
    }

    @Deprecated
    protected boolean isTraceOn(MessageContext msgCtx) {
        return this.isTracingEnabled() || this.shouldCaptureTracing(msgCtx);
    }

    @Deprecated
    protected boolean isTraceOrDebugOn(boolean isTraceOn) {
        return isTraceOn || this.log.isDebugEnabled();
    }

    @Deprecated
    protected void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)msg);
        }
    }

    @Deprecated
    protected void traceOrDebugWarn(boolean traceOn, String msg) {
        if (traceOn) {
            trace.warn((Object)msg);
        }
        if (this.log.isDebugEnabled()) {
            this.log.warn((Object)msg);
        }
    }

    @Deprecated
    protected void auditLog(String msg, MessageContext msgContext) {
        String formattedMsg = LoggingUtils.getFormattedLog(msgContext, msg);
        this.log.info((Object)formattedMsg);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().info((Object)msg);
        }
        if (this.shouldTrace(msgContext)) {
            trace.info((Object)formattedMsg);
        }
    }

    protected void handleException(String msg, MessageContext msgContext) {
        String formattedLog = LoggingUtils.getFormattedLog(msgContext, msg);
        this.log.error((Object)formattedLog);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().error((Object)msg);
        }
        if (this.shouldTrace(msgContext)) {
            trace.error((Object)formattedLog);
        }
        throw new SynapseException(msg);
    }

    @Deprecated
    protected void auditWarn(String msg, MessageContext msgContext) {
        String formattedMsg = LoggingUtils.getFormattedLog(msgContext, msg);
        this.log.warn((Object)formattedMsg);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().warn((Object)msg);
        }
        if (this.shouldTrace(msgContext)) {
            trace.warn((Object)formattedMsg);
        }
    }

    protected void handleException(String msg, Exception e, MessageContext msgContext) {
        String formattedLog = LoggingUtils.getFormattedLog(msgContext, msg);
        this.log.error((Object)formattedLog, (Throwable)e);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().error((Object)msg, (Throwable)e);
        }
        if (this.shouldTrace(msgContext)) {
            trace.error((Object)formattedLog, (Throwable)e);
        }
        throw new SynapseException(msg, e);
    }

    public boolean isStatisticsEnable() {
        return this.aspectConfiguration != null && this.aspectConfiguration.isStatisticsEnable();
    }

    public void disableStatistics() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.disableStatistics();
        }
    }

    public void enableStatistics() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.enableStatistics();
        }
    }

    public boolean isTracingEnabled() {
        return this.aspectConfiguration != null && this.aspectConfiguration.isTracingEnabled();
    }

    public void disableTracing() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.disableTracing();
        }
    }

    public void enableTracing() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.enableTracing();
        }
    }

    @Override
    public void configure(AspectConfiguration aspectConfiguration) {
        this.aspectConfiguration = aspectConfiguration;
    }

    @Override
    public AspectConfiguration getAspectConfiguration() {
        return this.aspectConfiguration;
    }

    @Override
    public boolean isContentAware() {
        return true;
    }

    @Override
    public boolean isContentAltering() {
        return false;
    }

    @Override
    public int getMediatorPosition() {
        return this.mediatorPosition;
    }

    @Override
    public void setMediatorPosition(int position) {
        this.mediatorPosition = position;
    }

    public String getInputType() {
        return null;
    }

    public String getOutputType() {
        return null;
    }

    public List<String> getCommentsList() {
        return this.commentsList;
    }

    public void setCommentsList(List<String> commentsList) {
        this.commentsList = commentsList;
    }

    @Override
    public String getMediatorName() {
        String cls = this.getClass().getName();
        return cls.substring(cls.lastIndexOf(".") + 1);
    }

    @Override
    public Integer reportOpenStatistics(MessageContext messageContext, boolean isContentAltering) {
        if (this instanceof FlowContinuableMediator) {
            return OpenEventCollector.reportFlowContinuableEvent(messageContext, this.getMediatorName(), ComponentType.MEDIATOR, this.getAspectConfiguration(), this.isContentAltering() || isContentAltering);
        }
        return OpenEventCollector.reportChildEntryEvent(messageContext, this.getMediatorName(), ComponentType.MEDIATOR, this.getAspectConfiguration(), this.isContentAltering() || isContentAltering);
    }

    @Override
    public void reportCloseStatistics(MessageContext messageContext, Integer currentIndex) {
        CloseEventCollector.closeEntryEvent(messageContext, this.getMediatorName(), ComponentType.MEDIATOR, currentIndex, this.isContentAltering());
    }

    public void registerMediationFlowPoint(SynapseMediationFlowPoint flowPoint) {
        this.flowPoint = flowPoint;
    }

    public void unregisterMediationFlowPoint() {
        if (!(this.flowPoint == null || this.isBreakPoint && this.isSkipEnabled)) {
            this.flowPoint = null;
        }
    }

    public SynapseMediationFlowPoint getRegisteredMediationFlowPoint() {
        return this.flowPoint;
    }

    public boolean isBreakPoint() {
        return this.isBreakPoint;
    }

    public boolean isSkipEnabled() {
        return this.isSkipEnabled;
    }

    public void setBreakPoint(boolean isBreakPoint) {
        this.isBreakPoint = isBreakPoint;
    }

    public void setSkipEnabled(boolean isSkipEnabled) {
        this.isSkipEnabled = isSkipEnabled;
    }

    protected boolean shouldCaptureTracing(MessageContext synCtx) {
        Boolean isCollectingTraces = (Boolean)synCtx.getProperty("mediation.flow.trace.collected");
        if (isCollectingTraces == null) {
            return false;
        }
        return isCollectingTraces;
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.aspectConfiguration == null) {
            this.aspectConfiguration = new AspectConfiguration(this.getMediatorName());
        }
        String sequenceId = StatisticIdentityGenerator.getIdForComponent(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(sequenceId);
        StatisticIdentityGenerator.reportingEndEvent(sequenceId, ComponentType.MEDIATOR, holder);
    }

    protected MediatorFaultHandler getLastSequenceFaultHandler(MessageContext synCtx) {
        FaultHandler o;
        Stack<FaultHandler> faultStack = synCtx.getFaultStack();
        if (faultStack != null && !faultStack.isEmpty() && (o = faultStack.peek()) instanceof MediatorFaultHandler) {
            return (MediatorFaultHandler)o;
        }
        return null;
    }
}

