/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.ListMediator;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public abstract class AbstractListMediator
extends AbstractMediator
implements ListMediator {
    private static final String MSG_BUILD_FAILURE_EXCEPTION_PATTERN = ".*(Wstx)(.*Exception)|.*MalformedJsonException|.*(synapse\\.commons\\.staxon\\.core)|.*(com\\.fasterxml\\.jackson\\.core)";
    protected Pattern msgBuildFailureExpattern = Pattern.compile(".*(Wstx)(.*Exception)|.*MalformedJsonException|.*(synapse\\.commons\\.staxon\\.core)|.*(com\\.fasterxml\\.jackson\\.core)");
    protected final List<Mediator> mediators = new ArrayList<Mediator>();
    private boolean sequenceContentAware = false;
    private static boolean isStreamXpathEnabled = SynapsePropertiesLoader.getBooleanProperty("synapse.streaming.xpath.enabled", Boolean.FALSE);

    @Override
    public boolean mediate(MessageContext synCtx) {
        return this.mediate(synCtx, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mediate(MessageContext synCtx, int mediatorPosition) {
        boolean returnVal = true;
        int parentsEffectiveTraceState = synCtx.getTracingState();
        this.setEffectiveTraceState(synCtx);
        int myEffectiveTraceState = synCtx.getTracingState();
        try {
            SynapseLog synLog = this.getLog(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Sequence <" + this.getType() + "> :: mediate()");
                synLog.traceOrDebug("Mediation started from mediator position : " + mediatorPosition);
            }
            int i = mediatorPosition;
            while (i < this.mediators.size()) {
                Mediator mediator = this.mediators.get(i);
                if (this.sequenceContentAware && (mediator.isContentAware() || isStreamXpathEnabled) && !Boolean.TRUE.equals(synCtx.getProperty("message.builder.invoked"))) {
                    this.buildMessage(synCtx, synLog);
                }
                if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                    Integer statisticReportingIndex = mediator.reportOpenStatistics(synCtx, i == mediatorPosition);
                    synCtx.setTracingState(myEffectiveTraceState);
                    if (!mediator.mediate(synCtx)) {
                        mediator.reportCloseStatistics(synCtx, statisticReportingIndex);
                        returnVal = false;
                        return returnVal;
                    }
                    mediator.reportCloseStatistics(synCtx, statisticReportingIndex);
                } else {
                    synCtx.setTracingState(myEffectiveTraceState);
                    if (!mediator.mediate(synCtx)) {
                        returnVal = false;
                        return returnVal;
                    }
                }
                ++i;
            }
            return returnVal;
        }
        catch (SynapseException synEx) {
            Matcher msgBuildFailureExMatcher = this.msgBuildFailureExpattern.matcher(ExceptionUtils.getStackTrace((Throwable)synEx));
            if (!msgBuildFailureExMatcher.find()) throw synEx;
            synCtx.setProperty("ERROR_CODE", 601000);
            synCtx.setProperty("ERROR_MESSAGE", synEx.getMessage().split("\n")[0]);
            synCtx.setProperty("ERROR_DETAIL", ExceptionUtils.getStackTrace((Throwable)synEx));
            synCtx.setProperty("ERROR_EXCEPTION", synEx.toString());
            this.consumeInputOnOmException(synCtx);
            throw synEx;
        }
        catch (Exception ex) {
            String errorMsg = ex.getMessage();
            Matcher msgBuildFailureExMatcher = this.msgBuildFailureExpattern.matcher(ExceptionUtils.getStackTrace((Throwable)ex));
            if (errorMsg == null) {
                errorMsg = "Runtime error occurred while mediating the message";
            }
            if (msgBuildFailureExMatcher.find()) {
                this.consumeInputOnOmException(synCtx);
            }
            this.handleException(errorMsg, ex, synCtx);
            return returnVal;
        }
        finally {
            synCtx.setTracingState(parentsEffectiveTraceState);
        }
    }

    private void buildMessage(MessageContext synCtx, SynapseLog synLog) {
        try {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Building message. Sequence <" + this.getType() + "> is content aware");
            }
            RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (boolean)false);
        }
        catch (Exception e) {
            this.handleException("Error while building message. " + e.getMessage(), e, synCtx);
        }
    }

    @Override
    public List<Mediator> getList() {
        return this.mediators;
    }

    @Override
    public boolean addChild(Mediator m) {
        return this.mediators.add(m);
    }

    public void addChild(int index, Mediator m) {
        this.mediators.add(index, m);
    }

    @Override
    public boolean addAll(List<Mediator> c) {
        return this.mediators.addAll(c);
    }

    @Override
    public Mediator getChild(int pos) {
        return this.mediators.get(pos);
    }

    @Override
    public boolean removeChild(Mediator m) {
        return this.mediators.remove(m);
    }

    @Override
    public Mediator removeChild(int pos) {
        return this.mediators.remove(pos);
    }

    @Override
    public void init(SynapseEnvironment se) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing child mediators of mediator : " + this.getType()));
        }
        for (int i = 0; i < this.mediators.size(); ++i) {
            Mediator mediator = this.mediators.get(i);
            mediator.setMediatorPosition(i);
            if (mediator instanceof ManagedLifecycle) {
                ((ManagedLifecycle)((Object)mediator)).init(se);
            }
            if (!mediator.isContentAware()) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(mediator.getType() + " is content aware, setting sequence <" + this.getType() + "> as content aware"));
            }
            this.sequenceContentAware = true;
        }
    }

    @Override
    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Destroying child mediators of mediator : " + this.getType()));
        }
        for (Mediator mediator : this.mediators) {
            if (!(mediator instanceof ManagedLifecycle)) continue;
            ((ManagedLifecycle)((Object)mediator)).destroy();
        }
    }

    @Override
    public boolean isContentAware() {
        return this.sequenceContentAware;
    }

    public void setStatisticIdForMediators(ArtifactHolder holder) {
        for (Mediator mediator : this.mediators) {
            mediator.setComponentStatisticsId(holder);
        }
    }

    private void consumeInputOnOmException(MessageContext synCtx) {
        SOAPEnvelope soapEnvelope;
        try {
            RelayUtils.discardRequestMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext());
        }
        catch (AxisFault axisFault) {
            this.log.error((Object)"Exception while consuming the input stream on Om Exception", (Throwable)axisFault);
        }
        if (synCtx.isSOAP11()) {
            soapEnvelope = OMAbstractFactory.getSOAP11Factory().createSOAPEnvelope();
            soapEnvelope.addChild((OMNode)OMAbstractFactory.getSOAP11Factory().createSOAPBody());
        } else {
            soapEnvelope = OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope();
            soapEnvelope.addChild((OMNode)OMAbstractFactory.getSOAP12Factory().createSOAPBody());
        }
        try {
            synCtx.setEnvelope(soapEnvelope);
        }
        catch (AxisFault e) {
            this.log.error((Object)"Exception or Error occurred resetting SOAP Envelope", (Throwable)e);
        }
    }
}

