/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.libraries.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.util.Utils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.deployers.SynapseArtifactDeploymentException;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.model.LibraryArtifact;
import org.apache.synapse.libraries.model.SynapseLibrary;

public class LibDeployerUtils {
    public static final String APP_UNZIP_DIR;
    private static final Log log;

    public static Library createSynapseLibrary(String libPath) {
        File libFile = new File(libPath);
        String extractPath = LibDeployerUtils.extractSynapseLib(libFile);
        SynapseLibrary synapseLib = LibDeployerUtils.populateDependencies(extractPath + "connector.xml");
        try {
            ClassLoader libLoader = Utils.getClassLoader((ClassLoader)LibDeployerUtils.class.getClassLoader(), (String)extractPath, (boolean)false);
            synapseLib.setLibClassLoader(libLoader);
        }
        catch (DeploymentException e) {
            throw new SynapseArtifactDeploymentException("Error setting up lib classpath for Synapse Library  : " + libFile.getAbsolutePath(), e);
        }
        LibDeployerUtils.searchAndResolveDependencies(extractPath, synapseLib);
        LibDeployerUtils.populateLocalEnties(synapseLib, extractPath + "local-entries");
        synapseLib.setFileName(libFile.getAbsolutePath());
        return synapseLib;
    }

    private static void populateLocalEnties(SynapseLibrary synapseLibrary, String localEntriesFilePath) {
        File dir = new File(localEntriesFilePath);
        if (dir.isDirectory()) {
            File[] entries;
            for (File file : entries = dir.listFiles()) {
                synapseLibrary.getLocalEntryArtifacts().put(file.getName(), file);
            }
        }
    }

    private static SynapseLibrary populateDependencies(String libXmlPath) {
        File f = new File(libXmlPath);
        if (!f.exists()) {
            throw new SynapseException("artifacts.xml file not found at : " + libXmlPath);
        }
        FileInputStream xmlInputStream = null;
        try {
            xmlInputStream = new FileInputStream(f);
            OMElement documentElement = new StAXOMBuilder((InputStream)xmlInputStream).getDocumentElement();
            if (documentElement == null) {
                throw new SynapseArtifactDeploymentException("Document element for artifacts.xml is null. Can't build the synapse library configuration");
            }
            Iterator artifactItr = documentElement.getChildrenWithLocalName("component");
            SynapseLibrary mainSynLibArtifact = null;
            mainSynLibArtifact = LibDeployerUtils.createSynapseLibraryWithDeps((OMElement)artifactItr.next());
            if (mainSynLibArtifact == null) {
                throw new SynapseArtifactDeploymentException("artifacts.xml is invalid. <artifact> element Not Found ");
            }
            SynapseLibrary synapseLibrary = mainSynLibArtifact;
            return synapseLibrary;
        }
        catch (FileNotFoundException e) {
            throw new SynapseArtifactDeploymentException("artifacts.xml File cannot be loaded from " + libXmlPath, e);
        }
        catch (XMLStreamException e) {
            throw new SynapseArtifactDeploymentException("Error while parsing the artifacts.xml file ", e);
        }
        finally {
            if (xmlInputStream != null) {
                try {
                    ((InputStream)xmlInputStream).close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing input stream.", (Throwable)e);
                }
            }
        }
    }

    private static SynapseLibrary createSynapseLibraryWithDeps(OMElement artifactEle) {
        if (artifactEle == null) {
            return null;
        }
        SynapseLibrary synLib = new SynapseLibrary(LibDeployerUtils.readAttribute(artifactEle, "name"), LibDeployerUtils.readAttribute(artifactEle, "package"));
        synLib.setDescription(LibDeployerUtils.readChildText(artifactEle, "description"));
        Iterator itr = artifactEle.getChildrenWithLocalName("dependency");
        while (itr.hasNext()) {
            OMElement depElement = (OMElement)itr.next();
            LibraryArtifact.Dependency dep = new LibraryArtifact.Dependency(LibDeployerUtils.readAttribute(depElement, "component"));
            synLib.addDependency(dep);
        }
        return synLib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void searchAndResolveDependencies(String rootDirPath, SynapseLibrary library) {
        ArrayList<LibraryArtifact> libraryArtifacts = new ArrayList<LibraryArtifact>();
        File extractedDir = new File(rootDirPath);
        File[] allFiles = extractedDir.listFiles();
        if (allFiles == null) {
            return;
        }
        for (File artifactDirectory : allFiles) {
            String directoryPath;
            String artifactXmlPath;
            File f;
            if (!artifactDirectory.isDirectory() || !(f = new File(artifactXmlPath = (directoryPath = artifactDirectory.getAbsolutePath()) + File.separator + "component.xml")).exists()) continue;
            LibraryArtifact artifact = null;
            FileInputStream xmlInputStream = null;
            try {
                xmlInputStream = new FileInputStream(f);
                artifact = LibDeployerUtils.buildArtifact(library, xmlInputStream, directoryPath);
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("Error while resolving synapse lib dir :" + artifactDirectory.getName() + " artifacts.xml File cannot be loaded from " + artifactXmlPath), (Throwable)e);
            }
            catch (Exception e) {
                log.warn((Object)("Error ocurred while resolving synapse lib dir :" + artifactDirectory.getName() + " for artifacts.xml path" + artifactXmlPath), (Throwable)e);
            }
            finally {
                if (xmlInputStream != null) {
                    try {
                        ((InputStream)xmlInputStream).close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while closing input stream.", (Throwable)e);
                    }
                }
            }
            if (artifact == null) {
                log.warn((Object)("Could not build lib artifact for path : " + directoryPath + " Synapse Library :" + library.getQName() + ". Continue searching for other lib artifacts"));
                continue;
            }
            libraryArtifacts.add(artifact);
        }
        boolean isDepsResolved = library.resolveDependencies(libraryArtifacts);
        if (!isDepsResolved) {
            throw new SynapseArtifactDeploymentException("Error when resolving Dependencies for lib : " + library.toString());
        }
    }

    private static LibraryArtifact buildArtifact(SynapseLibrary library, InputStream artifactXmlStream, String directoryPath) {
        LibraryArtifact artifact = null;
        try {
            OMElement artElement = new StAXOMBuilder(artifactXmlStream).getDocumentElement();
            if (!"component".equals(artElement.getLocalName())) {
                log.error((Object)("artifact.xml is invalid. Error occurred while resolving Synapse Library : " + library.getQName()));
                return null;
            }
            artifact = LibDeployerUtils.populateLibraryArtifact(artElement, directoryPath, null, library);
        }
        catch (XMLStreamException e) {
            throw new SynapseArtifactDeploymentException("Error parsing artifact.xml for path : " + directoryPath, e);
        }
        if (artifact == null || artifact.getName() == null) {
            log.error((Object)("Invalid artifact found in Synapse Library : " + library.getQName()));
            return null;
        }
        return artifact;
    }

    private static LibraryArtifact populateLibraryArtifact(OMElement artifactEle, String artifactPath, LibraryArtifact parent, SynapseLibrary library) {
        if (artifactEle == null || artifactPath == null) {
            return null;
        }
        LibraryArtifact artifact = new LibraryArtifact(LibDeployerUtils.readAttribute(artifactEle, "name"));
        artifact.setParent(parent);
        artifact.setType(LibDeployerUtils.readAttribute(artifactEle, "type"));
        artifact.setPath(artifactPath);
        artifact.setDescription(LibDeployerUtils.readChildText(artifactEle, "description"));
        library.addArtifactDescription(artifact);
        OMElement subArtifactsElement = artifactEle.getFirstChildWithName(new QName("subComponents"));
        if (subArtifactsElement != null) {
            Iterator subArtItr = subArtifactsElement.getChildrenWithLocalName("component");
            while (subArtItr.hasNext()) {
                LibraryArtifact subArtifact = LibDeployerUtils.populateLibraryArtifact((OMElement)subArtItr.next(), artifactPath, artifact, library);
                artifact.addSubArtifact(subArtifact);
            }
        }
        Iterator fileItr = artifactEle.getChildrenWithLocalName("file");
        while (fileItr.hasNext()) {
            OMElement fileElement = (OMElement)fileItr.next();
            artifact.setupFile(fileElement.getText());
        }
        return artifact;
    }

    public static void loadLibArtifacts(SynapseImport synImport, Library library) {
        if (synImport.getLibName().equals(library.getQName().getLocalPart()) && synImport.getLibPackage().equals(library.getPackage())) {
            library.setLibStatus(synImport.isStatus());
            library.loadLibrary();
        }
    }

    public static <T> T getLibArtifact(Map<String, Library> librarySet, String key, Class<T> type) {
        for (Library synapseLibrary : librarySet.values()) {
            try {
                Object artifact = synapseLibrary.getArtifact(key);
                if (artifact == null) continue;
                return (T)artifact;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static String getQualifiedName(SynapseImport synImport) {
        return new QName(synImport.getLibPackage(), synImport.getLibName()).toString();
    }

    public static String readAttribute(OMElement element, String attName) {
        if (element == null) {
            return null;
        }
        OMAttribute temp = element.getAttribute(new QName(attName));
        if (temp != null) {
            return temp.getAttributeValue();
        }
        return null;
    }

    public static String readChildText(OMElement element, String ln) {
        return LibDeployerUtils.readChildText(element, ln, null);
    }

    public static String readChildText(OMElement element, String ln, String ns) {
        if (element == null) {
            return null;
        }
        OMElement temp = element.getFirstChildWithName(new QName(ns, ln));
        if (temp != null) {
            return temp.getText();
        }
        return null;
    }

    public static String extractSynapseLib(File libFile) throws SynapseException {
        String dest = APP_UNZIP_DIR + File.separator + System.currentTimeMillis() + libFile.getName() + File.separator;
        LibDeployerUtils.createDir(dest);
        try {
            LibDeployerUtils.extract(libFile, dest);
        }
        catch (IOException e) {
            throw new SynapseException("Error while extracting Synapse Library : " + libFile.getName(), e);
        }
        return dest;
    }

    private static void extract(File sourcePath, String destPath) throws IOException {
        ZipFile zipFile = new ZipFile(sourcePath);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            String canonicalDirPath;
            ZipEntry entry = entries.nextElement();
            String canonicalEntryPath = new File(destPath + entry.getName()).getCanonicalPath();
            if (!canonicalEntryPath.startsWith(canonicalDirPath = new File(destPath).getCanonicalPath())) {
                throw new SynapseException("Entry is outside of the target dir: " + entry.getName());
            }
            if (entry.getName().startsWith("META-INF/")) continue;
            if (entry.isDirectory()) {
                LibDeployerUtils.createDir(destPath + entry.getName());
                continue;
            }
            LibDeployerUtils.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(destPath + entry.getName())));
        }
        zipFile.close();
    }

    public static void createDir(String path) {
        File temp = new File(path);
        if (!temp.exists() && !temp.mkdir()) {
            log.error((Object)("Error while creating directory : " + path));
        }
    }

    public static void deployingLocalEntries(Library library, SynapseConfiguration config) {
        Properties properties = SynapsePropertiesLoader.loadSynapseProperties();
        for (Map.Entry<String, Object> libararyEntryMap : library.getLocalEntryArtifacts().entrySet()) {
            File localEntryFileObj = (File)libararyEntryMap.getValue();
            OMElement document = LibDeployerUtils.getOMElement(localEntryFileObj);
            try {
                SynapseXMLConfigurationFactory.defineEntry(config, document, properties, library);
            }
            catch (Exception ex) {
                LibDeployerUtils.handleDeploymentError("Error while deploying local entries", ex);
            }
        }
    }

    private static void handleDeploymentError(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
    }

    private static OMElement getOMElement(File file) {
        FileInputStream is;
        OMElement document = null;
        try {
            is = FileUtils.openInputStream((File)file);
        }
        catch (IOException e) {
            LibDeployerUtils.handleException("Error while opening the file: " + file.getName() + " for reading", e);
            return null;
        }
        try {
            document = new StAXOMBuilder((InputStream)is).getDocumentElement();
            document.build();
            is.close();
        }
        catch (XMLStreamException e) {
            LibDeployerUtils.handleException("Error while parsing the content of the file: " + file.getName(), e);
        }
        catch (IOException e) {
            log.warn((Object)("Error while closing the input stream from the file: " + file.getName()), (Throwable)e);
        }
        return document;
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[40960];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static void main(String[] args) {
        new SynapseLibrary(null, null).resolveDependencies(null);
    }

    static {
        String javaTempDir = System.getProperty("java.io.tmpdir");
        APP_UNZIP_DIR = javaTempDir.endsWith(File.separator) ? javaTempDir + "libs" : javaTempDir + File.separator + "libs";
        LibDeployerUtils.createDir(APP_UNZIP_DIR);
        log = LogFactory.getLog(LibDeployerUtils.class);
    }
}

