/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.libraries.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.model.LibraryArtifact;

public class SynapseLibrary
implements Library {
    private String packageN = null;
    protected QName qualifiedName = null;
    public List<LibraryArtifact.Dependency> dependencies;
    private Map<String, LibraryArtifact> depNameToArtifactIndex = new HashMap<String, LibraryArtifact>();
    private Map<String, Object> libComponentIndex = new HashMap<String, Object>();
    private Map<String, String> libArtifactDetails = new HashMap<String, String>();
    private final Map<String, Object> localEntryArtifacts = new ConcurrentHashMap<String, Object>();
    private List<String> localEntries = new ArrayList<String>();
    private String description;
    private boolean isLoaded = false;
    private ClassLoader libClassLoader = null;
    private String fileName;
    private boolean libStatus = false;

    public SynapseLibrary(String name, String packageName) {
        this.packageN = packageName;
        this.qualifiedName = packageName != null && !"".equals(packageName) ? new QName(packageName, name) : new QName(name);
        this.dependencies = new ArrayList<LibraryArtifact.Dependency>();
    }

    @Override
    public QName getQName() {
        return this.qualifiedName;
    }

    public String getName() {
        return this.qualifiedName.getLocalPart();
    }

    public void addDependency(LibraryArtifact.Dependency artifactDep) {
        this.dependencies.add(artifactDep);
    }

    public void addComponent(String qualifiedName, Object libComponent) {
        this.libComponentIndex.put(qualifiedName, libComponent);
    }

    public void addArtifactDescription(LibraryArtifact artifact) {
        this.libArtifactDetails.put(artifact.getName(), artifact.getDescription());
    }

    @Override
    public String getArtifactDescription(String artifactName) {
        return this.libArtifactDetails.get(artifactName);
    }

    @Override
    public Map<String, String> getLibArtifactDetails() {
        return this.libArtifactDetails;
    }

    public void removeComponent(String qualifiedName) {
        this.libComponentIndex.remove(qualifiedName);
    }

    public boolean resolveDependencies(List<LibraryArtifact> unresolvedPrincipalArtifactList) {
        int unresolvedDeps = this.dependencies.size();
        block0: for (LibraryArtifact.Dependency dependency : this.dependencies) {
            for (LibraryArtifact current : unresolvedPrincipalArtifactList) {
                if (!dependency.resolveWith(current)) continue;
                --unresolvedDeps;
                this.depNameToArtifactIndex.put(dependency.getName(), current);
                continue block0;
            }
        }
        if (unresolvedDeps == 0) {
            this.dependencies.clear();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean loadLibrary() {
        if (!this.isLoaded) {
            for (String artifactName : this.depNameToArtifactIndex.keySet()) {
                this.loadLibrary(artifactName);
            }
        }
        this.isLoaded = true;
        return true;
    }

    public synchronized void loadLibrary(String artifactDependencyName) {
        LibraryArtifact libAr = this.depNameToArtifactIndex.get(artifactDependencyName);
        libAr.loadComponentsInto(this);
    }

    @Override
    public synchronized boolean unLoadLibrary() {
        this.libComponentIndex.clear();
        this.isLoaded = false;
        return true;
    }

    @Override
    public ClassLoader getLibClassLoader() {
        return this.libClassLoader;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void clear() {
        this.depNameToArtifactIndex.clear();
        this.libArtifactDetails.clear();
        this.libComponentIndex.clear();
    }

    @Override
    public Object getArtifact(String artifacName) {
        if (this.libComponentIndex.containsKey(artifacName)) {
            return this.libComponentIndex.get(artifacName);
        }
        return null;
    }

    @Override
    public Map<String, Object> getArtifacts() {
        return this.libComponentIndex;
    }

    public String toString() {
        return this.qualifiedName.toString();
    }

    @Override
    public String getPackage() {
        return this.packageN;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setLibClassLoader(ClassLoader libClassLoader) {
        this.libClassLoader = libClassLoader;
    }

    @Override
    public Map<String, Object> getLocalEntryArtifacts() {
        return this.localEntryArtifacts;
    }

    @Override
    public List<String> getLocalEntries() {
        return this.localEntries;
    }

    @Override
    public boolean getLibStatus() {
        return this.libStatus;
    }

    @Override
    public void setLibStatus(boolean status) {
        this.libStatus = status;
    }
}

