/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.inbound;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfigurable;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.inbound.InboundRequestProcessor;
import org.apache.synapse.inbound.InboundRequestProcessorFactory;
import org.apache.synapse.inbound.InboundTaskProcessor;
import org.apache.synapse.inbound.Utils;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class InboundEndpoint
implements AspectConfigurable,
ManagedLifecycle {
    protected static final Log log = LogFactory.getLog(InboundEndpoint.class);
    private String name;
    private String protocol;
    private String classImpl;
    private boolean isSuspend;
    private String injectingSeq;
    private String onErrorSeq;
    private Map<String, String> parametersMap = new LinkedHashMap<String, String>();
    private Map<String, String> parameterKeyMap = new LinkedHashMap<String, String>();
    private String fileName;
    private SynapseEnvironment synapseEnvironment;
    private InboundRequestProcessor inboundRequestProcessor;
    private String artifactContainerName;
    private boolean isEdited;
    private AspectConfiguration aspectConfiguration;
    private static final String secureVaultRegex = "\\{wso2:vault-lookup\\('(.*?)'\\)\\}";

    @Override
    public void init(SynapseEnvironment se) {
        log.info((Object)("Initializing Inbound Endpoint: " + this.getName()));
        this.synapseEnvironment = se;
        if (this.isSuspend) {
            log.info((Object)("Inbound endpoint " + this.name + " is currently suspended."));
            return;
        }
        this.inboundRequestProcessor = this.getInboundRequestProcessor();
        if (this.inboundRequestProcessor != null) {
            try {
                this.inboundRequestProcessor.init();
            }
            catch (Exception e) {
                String msg = "Error initializing inbound endpoint " + this.getName();
                log.error((Object)msg);
                throw new SynapseException(msg, e);
            }
        } else {
            String msg = "Inbound Request processor not found for Inbound EP : " + this.name + " Protocol: " + this.protocol + " Class" + this.classImpl;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
    }

    private InboundRequestProcessor getInboundRequestProcessor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Trying to fetch InboundRequestProcessor from classpath.. ");
        }
        Iterator<InboundRequestProcessorFactory> it = ServiceLoader.load(InboundRequestProcessorFactory.class, InboundRequestProcessorFactory.class.getClassLoader()).iterator();
        InboundProcessorParams params = this.populateParams();
        while (it.hasNext()) {
            InboundRequestProcessorFactory factory = it.next();
            InboundRequestProcessor inboundRequestProcessor = factory.createInboundProcessor(params);
            if (inboundRequestProcessor == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inbound Request Processor found in factory : " + factory.getClass().getName()));
            }
            return inboundRequestProcessor;
        }
        return null;
    }

    private InboundProcessorParams populateParams() {
        InboundProcessorParams inboundProcessorParams = new InboundProcessorParams();
        inboundProcessorParams.setProtocol(this.protocol);
        inboundProcessorParams.setClassImpl(this.classImpl);
        inboundProcessorParams.setName(this.name);
        inboundProcessorParams.setInjectingSeq(this.injectingSeq);
        inboundProcessorParams.setOnErrorSeq(this.onErrorSeq);
        inboundProcessorParams.setSynapseEnvironment(this.synapseEnvironment);
        Properties props = Utils.paramsToProperties(this.parametersMap);
        this.resolveSecureVaultExpressions(props);
        inboundProcessorParams.setProperties(props);
        return inboundProcessorParams;
    }

    public void destroy(boolean removeTask) {
        log.info((Object)("Destroying Inbound Endpoint: " + this.getName()));
        if (this.inboundRequestProcessor != null) {
            try {
                if (this.inboundRequestProcessor instanceof InboundTaskProcessor) {
                    ((InboundTaskProcessor)((Object)this.inboundRequestProcessor)).destroy(removeTask);
                } else {
                    this.inboundRequestProcessor.destroy();
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to destroy Inbound endpoint", (Throwable)e);
            }
        }
    }

    @Override
    public void destroy() {
        this.destroy(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean isSuspend() {
        return this.isSuspend;
    }

    public void setSuspend(boolean isSuspend) {
        this.isSuspend = isSuspend;
    }

    public String getInjectingSeq() {
        return this.injectingSeq;
    }

    public void setInjectingSeq(String injectingSeq) {
        this.injectingSeq = injectingSeq;
    }

    public String getOnErrorSeq() {
        return this.onErrorSeq;
    }

    public void setOnErrorSeq(String onErrorSeq) {
        this.onErrorSeq = onErrorSeq;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Map<String, String> getParametersMap() {
        return this.parametersMap;
    }

    public void addParameter(String name, String value) {
        this.parametersMap.put(name, value);
    }

    public void addParameter(String name, String value, String key) {
        this.addParameter(name, value);
        this.parameterKeyMap.put(name, key);
    }

    public String getParameter(String name) {
        return this.parametersMap.get(name);
    }

    public String getParameterKey(String name) {
        return this.parameterKeyMap.get(name);
    }

    public String getClassImpl() {
        return this.classImpl;
    }

    public void setClassImpl(String classImpl) {
        this.classImpl = classImpl;
    }

    public void setArtifactContainerName(String name) {
        this.artifactContainerName = name;
    }

    public String getArtifactContainerName() {
        return this.artifactContainerName;
    }

    public boolean getIsEdited() {
        return this.isEdited;
    }

    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    @Override
    public void configure(AspectConfiguration aspectConfiguration) {
        this.aspectConfiguration = aspectConfiguration;
    }

    @Override
    public AspectConfiguration getAspectConfiguration() {
        return this.aspectConfiguration;
    }

    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.aspectConfiguration == null) {
            this.aspectConfiguration = new AspectConfiguration(this.name);
        }
        String apiId = StatisticIdentityGenerator.getIdForComponent(this.name, ComponentType.INBOUNDENDPOINT, holder);
        this.aspectConfiguration.setUniqueId(apiId);
        String childId = null;
        if (this.injectingSeq != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent(this.injectingSeq, ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        }
        if (this.onErrorSeq != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent(this.onErrorSeq, ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        }
        StatisticIdentityGenerator.reportingEndEvent(apiId, ComponentType.INBOUNDENDPOINT, holder);
    }

    private void resolveSecureVaultExpressions(Properties props) {
        Pattern vaultLookupPattern = Pattern.compile(secureVaultRegex);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String value = (String)entry.getValue();
            Matcher lookupMatcher = vaultLookupPattern.matcher(value);
            String newParamValue = value;
            while (lookupMatcher.find()) {
                Value expression = null;
                String expressionStr = lookupMatcher.group(0).substring(1, lookupMatcher.group(0).length() - 1);
                try {
                    expression = new Value(new SynapseXPath(expressionStr));
                }
                catch (JaxenException e) {
                    log.error((Object)("Error while building the expression : " + expressionStr));
                }
                if (expression == null) continue;
                String resolvedValue = expression.evaluateValue(this.synapseEnvironment.createMessageContext());
                if (resolvedValue == null || resolvedValue.isEmpty()) {
                    log.warn((Object)("Found Empty value for expression : " + (Object)((Object)expression.getExpression())));
                    resolvedValue = "";
                }
                newParamValue = newParamValue.replaceFirst(secureVaultRegex, resolvedValue);
                props.put(entry.getKey(), newParamValue);
            }
        }
    }
}

