/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.oauth;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class TokenCache {
    private static final TokenCache instance = new TokenCache();
    private final Cache<String, String> tokenMap = CacheBuilder.newBuilder().expireAfterWrite(50L, TimeUnit.MINUTES).build();

    private TokenCache() {
    }

    public static TokenCache getInstance() {
        return instance;
    }

    public String getToken(String id, Callable<String> callable) throws ExecutionException {
        return (String)this.tokenMap.get((Object)id, callable);
    }

    public void removeToken(String id) {
        this.tokenMap.invalidate((Object)id);
    }
}

