/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.oauth;

import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.resolvers.ResolverFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.OAuthConfiguredHTTPEndpoint;
import org.apache.synapse.endpoints.oauth.AuthorizationCodeHandler;
import org.apache.synapse.endpoints.oauth.ClientCredentialsHandler;
import org.apache.synapse.endpoints.oauth.OAuthException;
import org.apache.synapse.endpoints.oauth.OAuthHandler;

public class OAuthUtils {
    private static final Log log = LogFactory.getLog(OAuthUtils.class);

    public static OAuthHandler getOAuthHandler(OMElement httpElement) throws OAuthException {
        OMElement oauthElement;
        OMElement authElement;
        if (httpElement != null && (authElement = httpElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "authentication"))) != null && (oauthElement = authElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "oauth"))) != null) {
            OAuthHandler oAuthHandler = OAuthUtils.getSpecificOAuthHandler(oauthElement);
            if (oAuthHandler != null) {
                return oAuthHandler;
            }
            throw new OAuthException("Invalid OAuth configuration");
        }
        return null;
    }

    private static OAuthHandler getSpecificOAuthHandler(OMElement oauthElement) {
        OAuthHandler oAuthHandler = null;
        OMElement authCodeElement = oauthElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "authorizationCode"));
        OMElement clientCredentialsElement = oauthElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "clientCredentials"));
        if (authCodeElement != null && clientCredentialsElement != null) {
            if (log.isDebugEnabled()) {
                log.error((Object)"Invalid OAuth configuration: AuthorizationCode and ClientCredentials grants are not allowed together");
            }
            return null;
        }
        if (authCodeElement != null) {
            oAuthHandler = OAuthUtils.getAuthorizationCodeHandler(authCodeElement);
        }
        if (clientCredentialsElement != null) {
            oAuthHandler = OAuthUtils.getClientCredentialsHandler(clientCredentialsElement);
        }
        return oAuthHandler;
    }

    private static AuthorizationCodeHandler getAuthorizationCodeHandler(OMElement authCodeElement) {
        String clientId = OAuthUtils.getChildValue(authCodeElement, "clientId");
        String clientSecret = OAuthUtils.getChildValue(authCodeElement, "clientSecret");
        String refreshToken = OAuthUtils.getChildValue(authCodeElement, "refreshToken");
        String tokenApiUrl = OAuthUtils.getChildValue(authCodeElement, "tokenUrl");
        if (clientId == null || clientSecret == null || refreshToken == null || tokenApiUrl == null) {
            if (log.isDebugEnabled()) {
                log.error((Object)"Invalid AuthorizationCode configuration");
            }
            return null;
        }
        return new AuthorizationCodeHandler(tokenApiUrl, clientId, clientSecret, refreshToken);
    }

    private static ClientCredentialsHandler getClientCredentialsHandler(OMElement clientCredentialsElement) {
        String clientId = OAuthUtils.getChildValue(clientCredentialsElement, "clientId");
        String clientSecret = OAuthUtils.getChildValue(clientCredentialsElement, "clientSecret");
        String tokenApiUrl = OAuthUtils.getChildValue(clientCredentialsElement, "tokenUrl");
        if (clientId == null || clientSecret == null || tokenApiUrl == null) {
            if (log.isDebugEnabled()) {
                log.error((Object)"Invalid ClientCredentials configuration");
            }
            return null;
        }
        return new ClientCredentialsHandler(tokenApiUrl, clientId, clientSecret);
    }

    private static String getChildValue(OMElement parentElement, String childName) {
        OMElement childElement = parentElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", childName));
        if (OAuthUtils.hasANonEmptyValue(childElement)) {
            return ResolverFactory.getInstance().getResolver(childElement.getText().trim()).resolve();
        }
        return null;
    }

    private static boolean hasANonEmptyValue(OMElement childElement) {
        return childElement != null && StringUtils.isNotBlank((String)childElement.getText());
    }

    public static String getRandomOAuthHandlerID() {
        String uuid = UIDGenerator.generateUID();
        return "oauth_" + uuid;
    }

    public static boolean retryOnOAuthFailure(OAuthConfiguredHTTPEndpoint httpEndpoint, MessageContext synapseInMsgCtx, MessageContext synapseOutMsgCtx) {
        Boolean hasRetried = (Boolean)synapseOutMsgCtx.getProperty("RETRIED_ON_OAUTH_FAILURE");
        if (hasRetried != null && hasRetried.booleanValue()) {
            return false;
        }
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synapseInMsgCtx).getAxis2MessageContext();
        Object statusCode = axis2MessageContext.getProperty("HTTP_SC");
        if (statusCode != null) {
            try {
                int httpStatus = Integer.parseInt(axis2MessageContext.getProperty("HTTP_SC").toString());
                if (httpStatus == 401) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Unable to set the HTTP status code from the property HTTP_SC with value: " + statusCode));
            }
        }
        return false;
    }

    public static void append401HTTPSC(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext axis2Ctx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object nonErrorCodesInMsgCtx = axis2Ctx.getProperty("non.error.http.status.codes");
        if (nonErrorCodesInMsgCtx instanceof Set) {
            Set nonErrorCodes = (Set)nonErrorCodesInMsgCtx;
            nonErrorCodes.add(401);
            axis2Ctx.setProperty("non.error.http.status.codes", (Object)nonErrorCodes);
        } else if (nonErrorCodesInMsgCtx instanceof String) {
            String strNonErrorCodes = ((String)nonErrorCodesInMsgCtx).trim();
            if (strNonErrorCodes.contains(String.valueOf(401))) {
                return;
            }
            if (!strNonErrorCodes.endsWith(",")) {
                strNonErrorCodes = strNonErrorCodes + ",";
            }
            strNonErrorCodes = strNonErrorCodes + String.valueOf(401);
            axis2Ctx.setProperty("non.error.http.status.codes", (Object)strNonErrorCodes);
        } else {
            axis2Ctx.setProperty("non.error.http.status.codes", (Object)String.valueOf(401));
        }
    }
}

