/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.oauth;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.oauth.OAuthClient;
import org.apache.synapse.endpoints.oauth.OAuthException;
import org.apache.synapse.endpoints.oauth.OAuthUtils;
import org.apache.synapse.endpoints.oauth.TokenCache;

public abstract class OAuthHandler {
    private final String id = OAuthUtils.getRandomOAuthHandlerID();
    private final String tokenApiUrl;

    protected OAuthHandler(String tokenApiUrl) {
        this.tokenApiUrl = tokenApiUrl;
    }

    public void setOAuthHeader(MessageContext messageContext) throws OAuthException {
        this.setAuthorizationHeader(messageContext, this.getToken());
    }

    private String getToken() throws OAuthException {
        try {
            return TokenCache.getInstance().getToken(this.id, new Callable<String>(){

                @Override
                public String call() throws OAuthException, IOException {
                    return OAuthClient.generateToken(OAuthHandler.this.tokenApiUrl, OAuthHandler.this.buildTokenRequestPayload(), OAuthHandler.this.getEncodedCredentials());
                }
            });
        }
        catch (ExecutionException e) {
            throw new OAuthException(e.getCause());
        }
    }

    private void setAuthorizationHeader(MessageContext messageContext, String accessToken) {
        Map transportHeaders = (Map)((Axis2MessageContext)messageContext).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
        transportHeaders.put("Authorization", "Bearer " + accessToken);
    }

    public void removeTokenFromCache() {
        TokenCache.getInstance().removeToken(this.id);
    }

    public String getTokenUrl() {
        return this.tokenApiUrl;
    }

    protected abstract String buildTokenRequestPayload();

    protected abstract String getEncodedCredentials();
}

