/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.oauth;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.synapse.endpoints.oauth.OAuthException;

public class OAuthClient {
    private static final Log log = LogFactory.getLog(OAuthClient.class);
    private static final CloseableHttpClient httpClient = OAuthClient.createHTTPClient();

    /*
     * Loose catch block
     */
    public static String generateToken(String tokenApiUrl, String payload, String credentials) throws OAuthException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing token generation request: [token-endpoint] " + tokenApiUrl));
        }
        HttpPost httpPost = new HttpPost(tokenApiUrl);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        httpPost.setHeader("Authorization", "Basic " + credentials);
        httpPost.setEntity((HttpEntity)new StringEntity(payload));
        try {
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                String string = OAuthClient.extractToken(response);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    private static String extractToken(CloseableHttpResponse response) throws OAuthException, IOException {
        String inputLine;
        int responseCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        Charset charset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), charset));
        StringBuilder stringBuilder = new StringBuilder();
        while ((inputLine = reader.readLine()) != null) {
            stringBuilder.append(inputLine);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response: [status-code] " + responseCode + " [message] " + stringBuilder.toString()));
        }
        if (responseCode != 200) {
            throw new OAuthException("Error while accessing the Token URL. " + response.getStatusLine());
        }
        JsonParser parser = new JsonParser();
        JsonObject jsonResponse = (JsonObject)parser.parse(stringBuilder.toString());
        if (jsonResponse.has("access_token")) {
            return jsonResponse.get("access_token").getAsString();
        }
        throw new OAuthException("Missing key [access_token] in the response from the OAuth server");
    }

    private static CloseableHttpClient createHTTPClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        return builder.build();
    }
}

