/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.oauth;

import org.apache.axiom.util.base64.Base64Utils;
import org.apache.synapse.endpoints.oauth.OAuthHandler;

public class ClientCredentialsHandler
extends OAuthHandler {
    private final String clientId;
    private final String clientSecret;

    public ClientCredentialsHandler(String tokenApiUrl, String clientId, String clientSecret) {
        super(tokenApiUrl);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    protected String buildTokenRequestPayload() {
        StringBuilder payload = new StringBuilder();
        payload.append("grant_type=client_credentials");
        payload.append("&client_id=").append(this.clientId);
        payload.append("&client_secret=").append(this.clientSecret);
        return payload.toString();
    }

    @Override
    protected String getEncodedCredentials() {
        return Base64Utils.encode((byte[])(this.clientId + ":" + this.clientSecret).getBytes());
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }
}

