/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.oauth;

import org.apache.axiom.util.base64.Base64Utils;
import org.apache.synapse.endpoints.oauth.OAuthHandler;

public class AuthorizationCodeHandler
extends OAuthHandler {
    private final String clientId;
    private final String clientSecret;
    private final String refreshToken;

    public AuthorizationCodeHandler(String tokenApiUrl, String clientId, String clientSecret, String refreshToken) {
        super(tokenApiUrl);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.refreshToken = refreshToken;
    }

    @Override
    protected String buildTokenRequestPayload() {
        StringBuilder payload = new StringBuilder();
        payload.append("grant_type=refresh_token").append("&refresh_token=").append(this.refreshToken);
        payload.append("&client_id=").append(this.clientId);
        payload.append("&client_secret=").append(this.clientSecret);
        return payload.toString();
    }

    @Override
    protected String getEncodedCredentials() {
        return Base64Utils.encode((byte[])(this.clientId + ":" + this.clientSecret).getBytes());
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }
}

