/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.dispatch;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.endpoints.dispatch.SessionCookie;
import org.apache.synapse.endpoints.dispatch.SessionInformation;

public abstract class AbstractDispatcher
implements Dispatcher {
    protected Log log = LogFactory.getLog(this.getClass());
    private static final String TRANSPORT_HEADERS = "TRANSPORT_HEADERS";
    private static final String[] SESSION_COOKIES = new String[]{"JSESSIONID", "PHPSESSID", "phpMyAdmin", "wordpress_test_cookie"};

    protected AbstractDispatcher() {
    }

    @Override
    public List<Endpoint> getEndpoints(SessionInformation sessionInformation) {
        return SALSessions.getInstance().getChildEndpoints(sessionInformation);
    }

    protected String extractSessionID(OMElement header, QName keyQName) {
        OMElement sgcIDElm = this.getHeaderBlock(header, keyQName);
        if (sgcIDElm != null) {
            String sgcID = sgcIDElm.getText();
            if (sgcID != null && !"".equals(sgcID)) {
                return sgcID.trim();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(keyQName + " is null or empty"));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Couldn't find the " + keyQName + " SOAP header to find the session"));
        }
        return null;
    }

    protected String extractSessionID(MessageContext synCtx, String key) {
        SessionCookie sessionCookie = this.extractSessionCookie(synCtx, key);
        if (sessionCookie != null) {
            return sessionCookie.getSessionId();
        }
        return null;
    }

    protected SessionCookie extractSessionCookie(MessageContext synCtx, String key) {
        if (key != null) {
            Map headerMap = this.getTransportHeaderMap(synCtx);
            if (headerMap != null) {
                Object cookieObj;
                Object hostObj = headerMap.get("Host");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("A request received with the Host Name : " + hostObj));
                }
                if ((cookieObj = headerMap.get(key)) instanceof String) {
                    String[] entries;
                    String cookie = (String)cookieObj;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Cookies String : " + cookie));
                    }
                    if ((entries = cookie.split(";")) == null || entries.length == 0) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Cannot find a session id for the cookie : " + cookie));
                        }
                        return null;
                    }
                    String sessionId = null;
                    String path = "Path=/";
                    for (String id : entries) {
                        if (sessionId == null && id != null && this.isASessionCookie(id)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Extracted SessionID : " + id));
                            }
                            sessionId = id.trim();
                            continue;
                        }
                        if (id == null || id.indexOf("Path") == -1) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Extracted Path : " + id));
                        }
                        path = id.trim();
                    }
                    if (sessionId != null) {
                        SessionCookie c = new SessionCookie();
                        c.setSessionId(sessionId);
                        c.setPath(path);
                        return c;
                    }
                    return null;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Couldn't find the " + key + " header to find the session"));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Couldn't find the TRANSPORT_HEADERS to find the session");
            }
        }
        return null;
    }

    private boolean isASessionCookie(String cookie) {
        for (String sessionCookie : SESSION_COOKIES) {
            if (cookie.indexOf(sessionCookie) == -1) continue;
            return true;
        }
        return false;
    }

    protected void removeSessionID(MessageContext synCtx, String key) {
        Map headerMap;
        if (key != null && (headerMap = this.getTransportHeaderMap(synCtx)) != null) {
            Object cookieObj = headerMap.remove(key);
            if (cookieObj instanceof String) {
                String[] sessionIds;
                String cookie = (String)cookieObj;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Cookies String : " + cookie));
                }
                if ((sessionIds = cookie.split(";")) == null || sessionIds.length == 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Cannot find a session id for the cookie : " + cookie));
                    }
                    return;
                }
                StringBuilder newCookie = new StringBuilder("");
                for (int i = 0; i < sessionIds.length; ++i) {
                    String sessionId = sessionIds[i];
                    if (sessionId != null && (sessionId.indexOf("JSESSIONID") != -1 || sessionId.indexOf("PHPSESSID") != -1 || sessionId.indexOf("phpMyAdmin") != -1 || sessionId.indexOf("wordpress_test_cookie") != -1)) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Extracted SessionID : " + sessionId));
                        continue;
                    }
                    newCookie.append(sessionId + "; ");
                }
                String modifiedCookie = "".equals(newCookie.toString()) ? "" : newCookie.substring(0, newCookie.lastIndexOf(";"));
                this.log.debug((Object)("Modified Cookie header: " + modifiedCookie));
                headerMap.put(key, modifiedCookie);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Couldn't find the " + key + " header to find the session"));
            }
        }
    }

    protected void removeSessionID(OMElement header, QName keyQName) {
        OMElement sgcIDElm = this.getHeaderBlock(header, keyQName);
        if (sgcIDElm != null) {
            sgcIDElm.detach();
        }
    }

    private Map getTransportHeaderMap(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object o = axis2MessageContext.getProperty(TRANSPORT_HEADERS);
        if (o != null && o instanceof Map) {
            return (Map)o;
        }
        return null;
    }

    private OMElement getHeaderBlock(OMElement soapHeader, QName keyQName) {
        if (soapHeader != null) {
            return soapHeader.getFirstChildWithName(keyQName);
        }
        return null;
    }
}

