/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.json.JSONObject;

public class WSDLEndpoint
extends AbstractEndpoint {
    private String wsdlURI;
    private OMElement wsdlDoc;
    private String serviceName;
    private String portName;

    @Override
    public void onFault(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext axis2MessageContext;
        Options options;
        EndpointReference to;
        this.logSetter();
        if (synCtx.getProperty("tenant.info.id") != null && (Integer)synCtx.getProperty("tenant.info.id") != -1234 && (to = (options = (axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext()).getOptions()).getTo()).getAddress() != null && to.getAddress().contains("local://")) {
            options.setTo(new EndpointReference(to.getAddress().substring("local://".length())));
        }
        if (this.getParentEndpoint() != null) {
            if (this.getContext().isMaxRetryLimitReached()) {
                this.getContext().onFailoverRetryLimit();
            } else if (this.isTimeout(synCtx)) {
                this.getContext().onTimeout();
            } else if (this.isSuspendFault(synCtx)) {
                this.getContext().onFault();
            }
        }
        this.setErrorOnMessage(synCtx, null, null);
        super.onFault(synCtx);
    }

    @Override
    public void onSuccess() {
        this.getContext().onSuccess();
    }

    @Override
    protected void createJsonRepresentation() {
        this.endpointJson = new JSONObject();
        this.endpointJson.put("name", (Object)this.getName());
        this.endpointJson.put("type", (Object)"WSDL Endpoint");
        this.endpointJson.put("wsdlUri", (Object)this.getWsdlURI());
        this.endpointJson.put("serviceName", (Object)this.getServiceName());
        this.endpointJson.put("portName", (Object)this.getPortName());
        this.setAdvancedProperties();
    }

    @Override
    public void send(MessageContext synCtx) {
        this.logSetter();
        if (this.getParentEndpoint() == null && !this.readyToSend()) {
            this.informFailure(synCtx, 303001, "Currently , WSDL endpoint : " + this.getContext());
        } else {
            super.send(synCtx);
        }
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public OMElement getWsdlDoc() {
        return this.wsdlDoc;
    }

    public void setWsdlDoc(OMElement wsdlDoc) {
        this.wsdlDoc = wsdlDoc;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }
}

