/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseArtifact;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.TemplateEndpoint;

public class Template
implements SynapseArtifact {
    private static Log log = LogFactory.getLog(Template.class);
    private OMElement element = null;
    private String name = null;
    private List<String> parameters = new ArrayList<String>();
    private String fileName = null;
    private String description = null;
    private String artifactContainerName;
    private boolean isEdited;
    private List<String> commentsList = new ArrayList<String>();

    public Endpoint create(TemplateEndpoint templateEndpoint, Properties properties) {
        OMElement clonedElement = this.element.cloneOMElement();
        this.replaceElement(templateEndpoint, clonedElement);
        return EndpointFactory.getEndpointFromElement(clonedElement, false, properties);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void addParameter(String name) {
        this.parameters.add(name);
    }

    public void setElement(OMElement element) {
        this.element = element;
    }

    public OMElement getElement() {
        return this.element;
    }

    private void replaceElement(TemplateEndpoint templateEndpoint, OMElement element) {
        String replace;
        Iterator attributesItr = element.getAllAttributes();
        while (attributesItr.hasNext()) {
            OMAttribute attribute = (OMAttribute)attributesItr.next();
            String replace2 = this.replace(attribute.getAttributeValue(), templateEndpoint);
            if (replace2 != null && replace2.contains("{system.prop")) {
                String newReplace = new String(replace2);
                Pattern pattern = Pattern.compile("\\{system(.*?)\\}");
                Matcher matcher = pattern.matcher(replace2);
                while (matcher.find()) {
                    String propStr = matcher.group(0);
                    String propName = propStr.substring(propStr.indexOf("{system.prop") + 13, propStr.length() - 1);
                    String propVal = System.getProperty(propName);
                    if (propVal != null) {
                        newReplace = newReplace.replace(propStr, propVal);
                        continue;
                    }
                    log.warn((Object)("System property " + propName + " not defined in JVM"));
                }
                log.info((Object)("Calculated replacement with system properties: " + newReplace));
                replace2 = newReplace;
            }
            if (replace2 == null) continue;
            attribute.setAttributeValue(replace2);
        }
        if (element.getText() != null && !"".equals(element.getText()) && (replace = this.replace(element.getText(), templateEndpoint)) != null) {
            element.setText(replace);
        }
        Iterator elemItr = element.getChildElements();
        while (elemItr.hasNext()) {
            OMElement childElement = (OMElement)elemItr.next();
            this.replaceElement(templateEndpoint, childElement);
        }
    }

    private String replace(String value, TemplateEndpoint templateEndpoint) {
        if (value.startsWith("$")) {
            String param = value.substring(1);
            if (templateEndpoint.getParameters().containsKey(param) && this.parameters.contains(param)) {
                return templateEndpoint.getParameterValue(param);
            }
        }
        return null;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getArtifactContainerName() {
        return this.artifactContainerName;
    }

    public void setArtifactContainerName(String artifactContainerName) {
        this.artifactContainerName = artifactContainerName;
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    public List<String> getCommentsList() {
        return this.commentsList;
    }

    public void setCommentsList(List<String> commentsList) {
        this.commentsList = commentsList;
    }
}

