/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.json.JSONObject;

public class ResolvingEndpoint
extends AbstractEndpoint {
    private SynapseXPath keyExpression = null;

    @Override
    public void send(MessageContext synCtx) {
        if (RuntimeStatisticCollector.isStatisticsEnabled()) {
            Integer currentIndex = null;
            if (this.getDefinition() != null) {
                currentIndex = OpenEventCollector.reportChildEntryEvent(synCtx, this.getReportingName(), ComponentType.ENDPOINT, this.getDefinition().getAspectConfiguration(), true);
            }
            try {
                this.sendMessage(synCtx);
            }
            finally {
                if (currentIndex != null) {
                    CloseEventCollector.closeEntryEvent(synCtx, this.getReportingName(), ComponentType.MEDIATOR, currentIndex, false);
                }
            }
        } else {
            this.sendMessage(synCtx);
        }
    }

    @Override
    protected void createJsonRepresentation() {
        this.endpointJson = new JSONObject();
        this.endpointJson.put("name", (Object)this.getName());
        this.endpointJson.put("type", (Object)"Resolving Endpoint");
    }

    public void sendMessage(MessageContext synCtx) {
        String key = this.keyExpression.stringValueOf(synCtx);
        Endpoint ep = this.loadAndInitEndpoint(((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext(), key);
        if (ep != null) {
            ep.send(synCtx);
        } else {
            this.informFailure(synCtx, 305100, "Couldn't find the endpoint with the key : " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint loadAndInitEndpoint(ConfigurationContext cc, String key) {
        Parameter parameter = cc.getAxisConfiguration().getParameter("synapse.config");
        Parameter synEnvParameter = cc.getAxisConfiguration().getParameter("synapse.env");
        if (parameter.getValue() instanceof SynapseConfiguration && synEnvParameter.getValue() instanceof SynapseEnvironment) {
            Endpoint ep;
            SynapseConfiguration synCfg = (SynapseConfiguration)parameter.getValue();
            SynapseEnvironment synapseEnvironment = (SynapseEnvironment)synEnvParameter.getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading real endpoint with key : " + key));
            }
            if ((ep = synCfg.getEndpoint(key)) != null && !ep.isInitialized()) {
                Endpoint endpoint = ep;
                synchronized (endpoint) {
                    if (!ep.isInitialized()) {
                        ep.init(synapseEnvironment);
                    }
                }
            }
            return ep;
        }
        return null;
    }

    public SynapseXPath getKeyExpression() {
        return this.keyExpression;
    }

    public void setKeyExpression(SynapseXPath keyExpression) {
        this.keyExpression = keyExpression;
    }
}

