/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.clustering.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.util.MessageHelper;
import org.json.JSONObject;

public class RecipientListEndpoint
extends AbstractEndpoint {
    private static final Log log = LogFactory.getLog(RecipientListEndpoint.class);
    private static final String DELIMETER = ",";
    private List<Member> members;
    private Map<String, Endpoint> dynamicEndpointPool;
    private Value dynamicEnpointSet;
    public static final int DEFAULT_MAX_POOL = 20;
    private boolean failover;
    private int currentPool;
    private SynapseEnvironment env = null;

    public RecipientListEndpoint(int poolsize) {
        this.dynamicEndpointPool = Collections.synchronizedMap(new DynamicEndpointPool(poolsize));
        this.currentPool = poolsize;
    }

    public RecipientListEndpoint() {
        this.currentPool = 20;
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        if (!this.initialized) {
            super.init(synapseEnvironment);
        }
        this.env = synapseEnvironment;
        this.setContentAware(true);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected void createJsonRepresentation() {
        this.endpointJson = new JSONObject();
        this.endpointJson.put("name", (Object)this.getName());
        this.endpointJson.put("type", (Object)"Recipient List Endpoint");
        this.endpointJson.put("poolSize", this.getCurrentPoolSize());
        this.endpointJson.put("children", (Object)this.getEndpointChildrenAsJson(this.getChildren()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(MessageContext synCtx) {
        if (RuntimeStatisticCollector.isStatisticsEnabled()) {
            boolean retry;
            Integer currentIndex = null;
            boolean bl = retry = synCtx.getProperty("last_endpoint") != null;
            if (this.getDefinition() != null && !retry) {
                currentIndex = OpenEventCollector.reportChildEntryEvent(synCtx, this.getReportingName(), ComponentType.ENDPOINT, this.getDefinition().getAspectConfiguration(), true);
            }
            try {
                this.sendMessage(synCtx);
            }
            finally {
                if (currentIndex != null) {
                    CloseEventCollector.closeEntryEvent(synCtx, this.getReportingName(), ComponentType.MEDIATOR, currentIndex, false);
                }
            }
        } else {
            this.sendMessage(synCtx);
        }
    }

    public void sendMessage(MessageContext synCtx) {
        this.logSetter();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending using Recipient List " + this.toString()));
        }
        if (this.getContext().isState(4)) {
            this.informFailure(synCtx, 303000, "RecipientList endpoint : " + this.getName() != null ? this.getName() : "AnonymousEndpoint - is inactive");
            return;
        }
        List<Endpoint> children = this.getChildren();
        if (children != null && !children.isEmpty()) {
            this.sendToEndpointList(synCtx, children);
        } else if (this.members != null && !this.members.isEmpty()) {
            this.sendToApplicationMembers(synCtx);
        } else if (this.dynamicEnpointSet != null) {
            this.sendToDynamicMembers(synCtx);
        } else {
            String msg = "No child endpoints nor member elements available";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
    }

    private void sendToEndpointList(MessageContext synCtx, List<Endpoint> children) {
        int i = 0;
        boolean foundEndpoint = false;
        try {
            RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (boolean)false);
        }
        catch (Exception e) {
            this.handleException("Error while building message", e, synCtx);
        }
        for (Endpoint childEndpoint : children) {
            if (!childEndpoint.readyToSend()) continue;
            foundEndpoint = true;
            MessageContext newCtx = null;
            try {
                newCtx = MessageHelper.cloneMessageContext(synCtx);
            }
            catch (AxisFault e) {
                this.handleException("Error cloning the message context", (Exception)((Object)e), synCtx);
            }
            newCtx.setProperty("messageSequence", String.valueOf(i++) + "/" + children.size());
            this.evaluateProperties(newCtx);
            newCtx.pushFaultHandler(this);
            try {
                childEndpoint.send(newCtx);
            }
            catch (SynapseException e) {
                String msg = "Child Endpoint " + (childEndpoint.getName() != null ? childEndpoint.getName() : "AnonymousEndpoint") + " of Recipient List endpoint " + (this.getName() != null ? this.getName() : "AnonymousEndpoint") + " encountered an error while sending the message";
                log.warn((Object)msg);
            }
        }
        if (!foundEndpoint) {
            String msg = "Recipient List endpoint : " + (this.getName() != null ? this.getName() : "AnonymousEndpoint") + " - no ready child endpoints";
            log.warn((Object)msg);
            this.informFailure(synCtx, 303000, msg);
        }
    }

    private void sendToDynamicMembers(MessageContext synCtx) {
        String dynamicUrlStr = this.dynamicEnpointSet.evaluateValue(synCtx);
        String[] dynamicUrlSet = dynamicUrlStr.split(DELIMETER);
        if (dynamicUrlSet.length == 0) {
            log.warn((Object)("No recipient/s was derived from the expression : " + this.dynamicEnpointSet.toString()));
            return;
        }
        ArrayList<Endpoint> children = new ArrayList<Endpoint>();
        for (String url : dynamicUrlSet) {
            if (url == null || "".equals(url.trim())) continue;
            Endpoint epFromPool = this.dynamicEndpointPool.get(url);
            if (epFromPool == null) {
                AddressEndpoint endpoint = new AddressEndpoint();
                endpoint.setEnableMBeanStats(false);
                endpoint.setName("DYNAMIC_RECIPIENT_LIST_EP_" + UUID.randomUUID());
                EndpointDefinition definition = new EndpointDefinition();
                definition.setReplicationDisabled(true);
                definition.setAddress(url);
                endpoint.setDefinition(definition);
                endpoint.init(this.env);
                this.dynamicEndpointPool.put(url, endpoint);
                children.add(endpoint);
                continue;
            }
            children.add(epFromPool);
        }
        if (children.size() > 0) {
            this.sendToEndpointList(synCtx, children);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Halted sending messages to recipients. No recipient found !!! : " + dynamicUrlStr));
        }
    }

    private void sendToApplicationMembers(MessageContext synCtx) {
        int i = 0;
        boolean foundEndpoint = false;
        for (Member member : this.members) {
            org.apache.axis2.context.MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            String transport = axis2MsgCtx.getTransportIn().getName();
            if (!transport.equals("http") && !transport.equals("https")) {
                log.error((Object)("Cannot deliver for non-HTTP/S transport " + transport));
                continue;
            }
            MessageContext newCtx = null;
            try {
                newCtx = MessageHelper.cloneMessageContext(synCtx);
            }
            catch (AxisFault e) {
                this.handleException("Error cloning the message context", (Exception)((Object)e), synCtx);
            }
            newCtx.setProperty("messageSequence", String.valueOf(i++) + "/" + this.members.size());
            this.evaluateProperties(newCtx);
            String address = newCtx.getTo().getAddress();
            if (address.indexOf(":") != -1) {
                try {
                    address = new URL(address).getPath();
                }
                catch (MalformedURLException e) {
                    String msg = "URL " + address + " is malformed";
                    log.error((Object)msg, (Throwable)e);
                    throw new SynapseException(msg, e);
                }
            }
            EndpointReference epr = new EndpointReference(transport + "://" + member.getHostName() + ":" + ("http".equals(transport) ? member.getHttpPort() : member.getHttpsPort()) + address);
            newCtx.setTo(epr);
            newCtx.pushFaultHandler(this);
            AddressEndpoint endpoint = new AddressEndpoint();
            EndpointDefinition definition = new EndpointDefinition();
            endpoint.setDefinition(definition);
            endpoint.init(newCtx.getEnvironment());
            if (!endpoint.readyToSend()) continue;
            foundEndpoint = true;
            endpoint.send(newCtx);
        }
        if (!foundEndpoint) {
            String msg = "Recipient List endpoint : " + (this.getName() != null ? this.getName() : "AnonymousEndpoint") + " - no ready child members";
            log.warn((Object)msg);
            this.informFailure(synCtx, 303000, msg);
        }
    }

    @Override
    public boolean readyToSend() {
        if (this.getContext().isState(4)) {
            return false;
        }
        for (Endpoint endpoint : this.getChildren()) {
            if (!endpoint.readyToSend()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Recipient List " + this.toString() + " has at least one endpoint at ready state"));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        this.logOnChildEndpointFail(endpoint, synMessageContext);
        String msg = "";
        if (log.isDebugEnabled()) {
            msg = "Recipient List endpoint : " + (this.getName() != null ? this.getName() : "AnonymousEndpoint") + " - one of the recipients encounterd an error while sending the message ";
            log.debug((Object)msg);
        }
        this.informFailure(synMessageContext, 303000, msg);
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public void setMembers(List<Member> members) {
        this.members = members;
    }

    public boolean isFailover() {
        return this.failover;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public Value getDynamicEnpointSet() {
        return this.dynamicEnpointSet;
    }

    public void setDynamicEnpointSet(Value dynamicEnpointSet) {
        this.dynamicEnpointSet = dynamicEnpointSet;
    }

    public int getCurrentPoolSize() {
        return this.currentPool;
    }

    private static class DynamicEndpointPool<String, Endpoint>
    extends LinkedHashMap<String, Endpoint> {
        private final int maxPoolSize;

        public DynamicEndpointPool(int max) {
            super(max + 1, 1.0f, true);
            this.maxPoolSize = max;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Endpoint> eldest) {
            return super.size() > this.maxPoolSize;
        }
    }
}

