/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import org.apache.axis2.AxisFault;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.HTTPEndpoint;
import org.apache.synapse.endpoints.oauth.MessageCache;
import org.apache.synapse.endpoints.oauth.OAuthException;
import org.apache.synapse.endpoints.oauth.OAuthHandler;
import org.apache.synapse.endpoints.oauth.OAuthUtils;
import org.apache.synapse.util.MessageHelper;

public class OAuthConfiguredHTTPEndpoint
extends HTTPEndpoint {
    private final OAuthHandler oAuthHandler;

    public OAuthConfiguredHTTPEndpoint(OAuthHandler oAuthHandler) {
        this.oAuthHandler = oAuthHandler;
    }

    @Override
    public void send(MessageContext synCtx) {
        try {
            this.oAuthHandler.setOAuthHeader(synCtx);
            if (synCtx.getProperty("blockingMsgSender") != null) {
                OAuthUtils.append401HTTPSC(synCtx);
            }
            MessageContext cloneMessageContext = MessageHelper.cloneMessageContext(synCtx);
            MessageCache.getInstance().addMessageContext(synCtx.getMessageID(), cloneMessageContext);
            super.send(synCtx);
        }
        catch (OAuthException e) {
            this.handleError(synCtx, "Could not generate access token for oauth configured http endpoint " + this.getName(), e);
        }
        catch (AxisFault axisFault) {
            this.handleError(synCtx, "Error cloning the message context for oauth configured http endpoint " + this.getName(), (Exception)((Object)axisFault));
        }
    }

    public MessageContext retryCallWithNewToken(MessageContext synCtx) {
        this.oAuthHandler.removeTokenFromCache();
        synCtx.setProperty("RETRIED_ON_OAUTH_FAILURE", true);
        this.send(synCtx);
        return synCtx;
    }

    @Override
    public void destroy() {
        this.oAuthHandler.removeTokenFromCache();
        super.destroy();
    }

    public OAuthHandler getOauthHandler() {
        return this.oAuthHandler;
    }

    private void handleError(MessageContext synCtx, String message, Exception exception) {
        String errorMsg = message + " " + exception.getMessage();
        this.log.error((Object)errorMsg);
        this.informFailure(synCtx, 303003, errorMsg);
    }
}

