/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointContext;
import org.apache.synapse.endpoints.EndpointView;
import org.json.JSONObject;

public class IndirectEndpoint
extends AbstractEndpoint {
    private String key = null;
    private Endpoint realEndpoint = null;

    @Override
    public void send(MessageContext synCtx) {
        this.logSetter();
        this.reLoadAndInitEndpoint(((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext());
        if (this.realEndpoint != null) {
            this.realEndpoint.send(synCtx);
        } else {
            this.informFailure(synCtx, 305100, "Couldn't find the endpoint with the key : " + this.key);
        }
    }

    @Override
    protected void createJsonRepresentation() {
        this.endpointJson = new JSONObject();
        this.endpointJson.put("name", (Object)this.getName());
        this.endpointJson.put("type", (Object)"Indirect Endpoint");
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public boolean readyToSend() {
        try {
            return this.realEndpoint.readyToSend();
        }
        catch (NullPointerException e) {
            this.log.info((Object)("Could not find endpoint with key " + this.key + ". Could not verify Endpoint ready to send status."));
            return false;
        }
    }

    @Override
    public void setName(String endpointName) {
    }

    @Override
    public EndpointContext getContext() {
        return this.realEndpoint.getContext();
    }

    @Override
    public List<Endpoint> getChildren() {
        return this.realEndpoint.getChildren();
    }

    @Override
    public EndpointView getMetricsMBean() {
        return this.realEndpoint.getMetricsMBean();
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        ConfigurationContext cc = ((Axis2SynapseEnvironment)synapseEnvironment).getAxis2ConfigurationContext();
        this.reLoadAndInitEndpoint(cc);
    }

    @Override
    public String toString() {
        return "Indirect Endpoint [" + this.key + "]";
    }

    public Endpoint getRealEndpoint(MessageContext synCtx) {
        this.reLoadAndInitEndpoint(((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext());
        return this.realEndpoint;
    }

    private synchronized void reLoadAndInitEndpoint(ConfigurationContext cc) {
        Parameter parameter = cc.getAxisConfiguration().getParameter("synapse.config");
        Parameter synEnvParameter = cc.getAxisConfiguration().getParameter("synapse.env");
        if (parameter.getValue() instanceof SynapseConfiguration && synEnvParameter.getValue() instanceof SynapseEnvironment) {
            boolean reLoad;
            SynapseConfiguration synCfg = (SynapseConfiguration)parameter.getValue();
            SynapseEnvironment synapseEnvironment = (SynapseEnvironment)synEnvParameter.getValue();
            boolean bl = reLoad = this.realEndpoint == null;
            if (!reLoad) {
                Entry entry = synCfg.getEntryDefinition(this.key);
                if (entry != null && entry.isDynamic()) {
                    if (!entry.isCached() || entry.isExpired()) {
                        reLoad = true;
                    }
                } else {
                    reLoad = true;
                }
            }
            if (reLoad) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Loading real endpoint with key : " + this.key));
                }
                this.realEndpoint = synCfg.getEndpoint(this.key);
                if (this.realEndpoint != null && !this.realEndpoint.isInitialized()) {
                    this.realEndpoint.init(synapseEnvironment);
                }
            } else {
                Endpoint epr = synCfg.getEndpoint(this.key);
                if (epr != this.realEndpoint) {
                    this.realEndpoint = epr;
                    if (this.realEndpoint != null && !this.realEndpoint.isInitialized() && this.realEndpoint instanceof ManagedLifecycle) {
                        this.realEndpoint.init(synapseEnvironment);
                    }
                }
            }
        }
    }
}

