/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Set;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.json.JSONObject;

public class HTTPEndpoint
extends AbstractEndpoint {
    private UriTemplate uriTemplate;
    private String httpMethod;
    private SynapseXPath httpMethodExpression;
    private boolean legacySupport = false;
    public static String legacyPrefix = "legacy-encoding:";

    @Override
    public void onFault(MessageContext synCtx) {
        this.logSetter();
        if (this.getContext().isMaxRetryLimitReached()) {
            this.getContext().onFailoverRetryLimit();
        } else if (this.isTimeout(synCtx)) {
            this.getContext().onTimeout();
        } else if (this.isSuspendFault(synCtx)) {
            this.getContext().onFault();
        }
        this.setErrorOnMessage(synCtx, null, null);
        super.onFault(synCtx);
    }

    @Override
    public void onSuccess() {
        if (this.getContext() != null) {
            this.getContext().onSuccess();
        }
    }

    @Override
    protected void createJsonRepresentation() {
        this.endpointJson = new JSONObject();
        this.endpointJson.put("name", (Object)this.getName());
        this.endpointJson.put("type", (Object)"HTTP Endpoint");
        this.endpointJson.put("method", (Object)this.getHttpMethod());
        this.endpointJson.put("uriTemplate", (Object)this.getUriTemplate().expand());
        this.endpointJson.put("errorHandler", (Object)this.getErrorHandler());
        this.setAdvancedProperties();
    }

    @Override
    public void send(MessageContext synCtx) {
        this.logSetter();
        this.executeEpTypeSpecificFunctions(synCtx);
        if (this.getParentEndpoint() == null && !this.readyToSend()) {
            this.informFailure(synCtx, 303001, "Currently , Address endpoint : " + this.getContext());
        } else {
            super.send(synCtx);
        }
    }

    @Override
    public void executeEpTypeSpecificFunctions(MessageContext synCtx) {
        this.processUrlTemplate(synCtx);
        this.processHttpMethod(synCtx);
    }

    private void processHttpMethod(MessageContext synCtx) {
        if (this.httpMethod != null) {
            super.getDefinition().setHTTPEndpoint(true);
            synCtx.setProperty("HTTP_METHOD", this.httpMethod);
        }
    }

    private String decodeString(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)"Encoding is not supported", (Throwable)e);
            }
            return value;
        }
    }

    private void processUrlTemplate(MessageContext synCtx) throws VariableExpansionException {
        HashMap<String, String> variables = new HashMap<String, String>();
        Set propertySet = synCtx.getPropertyKeySet();
        UriTemplate template = null;
        String evaluatedUri = "";
        if (this.legacySupport) {
            for (Object propertyKey : propertySet) {
                Object objProperty;
                if (propertyKey.toString() == null || !propertyKey.toString().startsWith("uri.var.") && !propertyKey.toString().startsWith("query.param.") || (objProperty = synCtx.getProperty(propertyKey.toString())) == null) continue;
                if (objProperty instanceof String) {
                    variables.put(propertyKey.toString(), this.decodeString((String)synCtx.getProperty(propertyKey.toString())));
                    continue;
                }
                variables.put(propertyKey.toString(), this.decodeString(String.valueOf(synCtx.getProperty(propertyKey.toString()))));
            }
            for (MediatorProperty property : this.getProperties()) {
                if (property.getName().toString() == null || !property.getName().toString().startsWith("uri.var.") && !property.getName().toString().startsWith("query.param.")) continue;
                variables.put(property.getName(), this.decodeString(property.getValue()));
            }
            template = UriTemplate.fromTemplate((String)this.uriTemplate.getTemplate());
            if (template != null) {
                template.set(variables);
            }
            if (variables.isEmpty()) {
                evaluatedUri = template.getTemplate();
            } else {
                try {
                    String decodedString = URLDecoder.decode(template.expand(), "UTF-8");
                    URL url = new URL(decodedString);
                    URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
                    evaluatedUri = uri.toURL().toString();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Expanded URL : " + evaluatedUri));
                    }
                }
                catch (URISyntaxException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Invalid URL syntax for HTTP Endpoint: " + this.getName()), (Throwable)e);
                    }
                    evaluatedUri = template.getTemplate();
                }
                catch (VariableExpansionException e) {
                    this.log.debug((Object)("No URI Template variables defined in HTTP Endpoint: " + this.getName()));
                    evaluatedUri = template.getTemplate();
                }
                catch (MalformedURLException e) {
                    this.log.debug((Object)("Invalid URL for HTTP Endpoint: " + this.getName()));
                    evaluatedUri = template.getTemplate();
                }
                catch (UnsupportedEncodingException e) {
                    this.log.debug((Object)("Exception while decoding the URL in HTTP Endpoint: " + this.getName()));
                    evaluatedUri = template.getTemplate();
                }
            }
        } else {
            for (Object propertyKey : propertySet) {
                Object objProperty;
                if (propertyKey.toString() == null || !propertyKey.toString().startsWith("uri.var.") && !propertyKey.toString().startsWith("query.param.") || (objProperty = synCtx.getProperty(propertyKey.toString())) == null) continue;
                if (objProperty instanceof String) {
                    variables.put(propertyKey.toString(), (String)synCtx.getProperty(propertyKey.toString()));
                    continue;
                }
                variables.put(propertyKey.toString(), String.valueOf(synCtx.getProperty(propertyKey.toString())));
            }
            for (MediatorProperty property : this.getProperties()) {
                if (property.getName().toString() == null || !property.getName().toString().startsWith("uri.var.") && !property.getName().toString().startsWith("query.param.")) continue;
                variables.put(property.getName(), property.getValue());
            }
            String tmpl = this.uriTemplate.getTemplate().charAt(0) == '{' && this.uriTemplate.getTemplate().charAt(1) != '+' ? "{+" + this.uriTemplate.getTemplate().substring(1) : this.uriTemplate.getTemplate();
            template = UriTemplate.fromTemplate((String)tmpl);
            if (template != null) {
                template.set(variables);
            }
            if (variables.isEmpty()) {
                evaluatedUri = template.getTemplate();
            } else {
                try {
                    URI uri = new URI(template.expand());
                    evaluatedUri = uri.toString();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Expanded URL : " + evaluatedUri));
                    }
                }
                catch (URISyntaxException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Invalid URL syntax for HTTP Endpoint: " + this.getName()), (Throwable)e);
                    }
                    evaluatedUri = template.getTemplate();
                }
                catch (VariableExpansionException e) {
                    this.log.debug((Object)("No URI Template variables defined in HTTP Endpoint: " + this.getName()));
                    evaluatedUri = template.getTemplate();
                }
            }
        }
        if (evaluatedUri != null) {
            synCtx.setTo(new EndpointReference(evaluatedUri));
            if (super.getDefinition() != null) {
                synCtx.setProperty("DYNAMIC_URL_VALUE", evaluatedUri);
            }
        }
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public UriTemplate getUriTemplate() {
        return this.uriTemplate;
    }

    public SynapseXPath getHttpMethodExpression() {
        return this.httpMethodExpression;
    }

    public void setUriTemplate(UriTemplate uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public void setHttpMethodExpression(SynapseXPath httpMethodExpression) {
        this.httpMethodExpression = httpMethodExpression;
    }

    public boolean isLegacySupport() {
        return this.legacySupport;
    }

    public void setLegacySupport(boolean legacySupport) {
        this.legacySupport = legacySupport;
    }
}

