/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.TemplateEndpoint;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.json.JSONObject;

public class FailoverEndpoint
extends AbstractEndpoint {
    private Endpoint currentEndpoint = null;
    private boolean dynamic = true;
    private boolean isBuildMessageAttAvailable = false;
    private boolean buildMessageAtt = false;
    private boolean buildMessage = false;

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        if (!this.initialized) {
            super.init(synapseEnvironment);
            this.buildMessage = Boolean.parseBoolean(SynapsePropertiesLoader.getPropertyValue("build.message.on.failover.enable", "false"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(MessageContext synCtx) {
        if (RuntimeStatisticCollector.isStatisticsEnabled()) {
            boolean retry;
            Integer currentIndex = null;
            boolean bl = retry = synCtx.getProperty("last_endpoint") != null;
            if (this.getDefinition() != null && !retry) {
                currentIndex = OpenEventCollector.reportChildEntryEvent(synCtx, this.getReportingName(), ComponentType.ENDPOINT, this.getDefinition().getAspectConfiguration(), true);
            }
            try {
                this.sendMessage(synCtx);
            }
            finally {
                if (currentIndex != null) {
                    CloseEventCollector.closeEntryEvent(synCtx, this.getReportingName(), ComponentType.MEDIATOR, currentIndex, false);
                }
            }
        } else {
            this.sendMessage(synCtx);
        }
    }

    private void sendMessage(MessageContext synCtx) {
        this.logSetter();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Failover Endpoint : " + this.getName()));
        }
        if (this.getContext().isState(4)) {
            this.informFailure(synCtx, 303000, "Failover endpoint : " + this.getName() != null ? this.getName() : "AnonymousEndpoint - is inactive");
            return;
        }
        boolean isARetry = false;
        HashMap<String, Object> mEndpointLog = null;
        if (synCtx.getProperty("last_endpoint") == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this + " Building the SoapEnvelope"));
            }
            if (this.isBuildMessageAttAvailable) {
                if (this.buildMessageAtt) {
                    this.buildMessage(synCtx);
                }
            } else if (this.buildMessage) {
                this.buildMessage(synCtx);
            }
            synCtx.getEnvelope().buildWithAttachments();
            if (Boolean.TRUE.equals(((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("message.builder.invoked"))) {
                synCtx.setProperty("LB_FO_ENDPOINT_ORIGINAL_MESSAGE", synCtx.getEnvelope());
            }
            mEndpointLog = new HashMap<String, Object>();
            synCtx.setProperty("endpoint_log", mEndpointLog);
        } else {
            isARetry = true;
            mEndpointLog = (HashMap<String, Object>)synCtx.getProperty("endpoint_log");
        }
        if (this.getChildren().isEmpty()) {
            this.informFailure(synCtx, 303000, "FailoverLoadbalance endpoint : " + this.getName() + " - no child endpoints");
            return;
        }
        this.evaluateProperties(synCtx);
        if (this.dynamic) {
            boolean foundEndpoint = false;
            for (Endpoint endpoint : this.getChildren()) {
                if (!endpoint.readyToSend()) continue;
                foundEndpoint = true;
                if (isARetry && this.metricsMBean != null) {
                    this.metricsMBean.reportSendingFault(304100);
                }
                synCtx.pushFaultHandler(this);
                if (endpoint instanceof AbstractEndpoint) {
                    org.apache.axis2.context.MessageContext axisMC = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                    Pipe pipe = (Pipe)axisMC.getProperty("pass-through.pipe");
                    if (pipe != null) {
                        pipe.forceSetSerializationRest();
                    }
                    if (axisMC.getProperty("pass-through.pipe") != null) {
                        ((AbstractEndpoint)endpoint).setContentAware(true);
                        ((AbstractEndpoint)endpoint).setForceBuildMC(true);
                        if (endpoint instanceof TemplateEndpoint && ((TemplateEndpoint)endpoint).getRealEndpoint() != null && ((TemplateEndpoint)endpoint).getRealEndpoint() instanceof AbstractEndpoint) {
                            ((AbstractEndpoint)((TemplateEndpoint)endpoint).getRealEndpoint()).setContentAware(true);
                            ((AbstractEndpoint)((TemplateEndpoint)endpoint).getRealEndpoint()).setForceBuildMC(true);
                        }
                    }
                }
                if (endpoint.getName() != null) {
                    mEndpointLog.put(endpoint.getName(), null);
                }
                endpoint.send(synCtx);
                break;
            }
            if (!foundEndpoint) {
                String msg = "Failover endpoint : " + (this.getName() != null ? this.getName() : "AnonymousEndpoint") + " - no ready child endpoints";
                this.log.warn((Object)msg);
                this.informFailure(synCtx, 303000, msg);
            }
        } else {
            if (this.currentEndpoint == null) {
                this.currentEndpoint = this.getChildren().get(0);
            }
            if (this.currentEndpoint.readyToSend()) {
                if (isARetry && this.metricsMBean != null) {
                    this.metricsMBean.reportSendingFault(304100);
                }
                synCtx.pushFaultHandler(this);
                this.currentEndpoint.send(synCtx);
            } else {
                boolean foundEndpoint = false;
                for (Endpoint endpoint : this.getChildren()) {
                    if (!endpoint.readyToSend()) continue;
                    foundEndpoint = true;
                    this.currentEndpoint = endpoint;
                    if (isARetry && this.metricsMBean != null) {
                        this.metricsMBean.reportSendingFault(304100);
                    }
                    synCtx.pushFaultHandler(this);
                    this.currentEndpoint.send(synCtx);
                    break;
                }
                if (!foundEndpoint) {
                    String msg = "Failover endpoint : " + (this.getName() != null ? this.getName() : "AnonymousEndpoint") + " - no ready child endpoints";
                    this.log.warn((Object)msg);
                    this.informFailure(synCtx, 303000, msg);
                }
            }
        }
    }

    @Override
    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        if (synMessageContext.getProperty("LB_FO_ENDPOINT_ORIGINAL_MESSAGE") != null) {
            try {
                synMessageContext.setEnvelope((SOAPEnvelope)synMessageContext.getProperty("LB_FO_ENDPOINT_ORIGINAL_MESSAGE"));
            }
            catch (AxisFault ex) {
                this.log.error((Object)"Couldn't restore the original message to the failover endpoint", (Throwable)ex);
            }
        }
        this.logOnChildEndpointFail(endpoint, synMessageContext);
        if (((AbstractEndpoint)endpoint).isRetry(synMessageContext)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this + " Retry Attempt for Request with [Message ID : " + synMessageContext.getMessageID() + "], [To : " + synMessageContext.getTo() + "]"));
            }
            this.send(synMessageContext);
        } else {
            String msg = "Failover endpoint : " + (this.getName() != null ? this.getName() : "AnonymousEndpoint") + " - one of the child endpoints encounterd a non-retry error, not sending message to another endpoint";
            this.log.warn((Object)msg);
            this.informFailure(synMessageContext, 303000, msg);
        }
    }

    @Override
    public boolean readyToSend() {
        if (this.getContext().isState(4)) {
            return false;
        }
        for (Endpoint endpoint : this.getChildren()) {
            if (!endpoint.readyToSend()) continue;
            this.currentEndpoint = endpoint;
            return true;
        }
        return false;
    }

    @Override
    protected void createJsonRepresentation() {
        this.endpointJson = new JSONObject();
        this.endpointJson.put("name", (Object)this.getName());
        this.endpointJson.put("type", (Object)"Failover Endpoint");
        this.endpointJson.put("children", (Object)this.getEndpointChildrenAsJson(this.getChildren()));
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isBuildMessageAtt() {
        return this.buildMessageAtt;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void setBuildMessageAtt(boolean buildMessage) {
        this.buildMessageAtt = buildMessage;
    }

    public void setBuildMessageAttAvailable(boolean available) {
        this.isBuildMessageAttAvailable = available;
    }

    private void buildMessage(MessageContext synCtx) {
        try {
            RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext());
        }
        catch (IOException | XMLStreamException ex) {
            this.handleException("Error while building the message", ex, synCtx);
        }
    }
}

