/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfigurable;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.endpoints.Endpoint;

public class EndpointDefinition
implements AspectConfigurable {
    private static final Log log = LogFactory.getLog(EndpointDefinition.class);
    public static final String DYNAMIC_URL_VALUE = "DYNAMIC_URL_VALUE";
    public Endpoint leafEndpoint = null;
    private String address = null;
    @Deprecated
    private boolean reliableMessagingOn = false;
    private boolean addressingOn = false;
    private String addressingVersion = null;
    private boolean securityOn = false;
    @Deprecated
    private String wsRMPolicyKey = null;
    private String wsSecPolicyKey = null;
    private String inboundWsSecPolicyKey = null;
    private String outboundWsSecPolicyKey = null;
    private boolean useSeparateListener = false;
    private boolean forcePOX = false;
    private boolean forceGET = false;
    private boolean forceSOAP11 = false;
    private boolean forceSOAP12 = false;
    private boolean forceREST = false;
    private boolean isHTTPEndpoint = false;
    private boolean useMTOM = false;
    private boolean useSwa = false;
    private String format = null;
    private String charSetEncoding;
    private SynapsePath dynamicTimeout = null;
    private boolean replicationDisabled = false;
    private long timeoutDuration = 0L;
    private long effectiveTimeout = 0L;
    private int timeoutAction = 100;
    private long initialSuspendDuration = -1L;
    private float suspendProgressionFactor = 1.0f;
    private long suspendMaximumDuration = Long.MAX_VALUE;
    private final List<Integer> suspendErrorCodes = new ArrayList<Integer>();
    private int retriesOnTimeoutBeforeSuspend = 0;
    private int retryDurationOnTimeout = 0;
    private final List<Integer> timeoutErrorCodes = new ArrayList<Integer>();
    private AspectConfiguration aspectConfiguration;
    private final List<Integer> retryDisabledErrorCodes = new ArrayList<Integer>();
    private final List<Integer> retryEnabledErrorCodes = new ArrayList<Integer>();
    private SynapseConstants.ENDPOINT_TIMEOUT_TYPE endpointTimeoutType;
    private SynapsePath dynamicPolicy = null;

    public EndpointDefinition() {
        try {
            this.effectiveTimeout = SynapseConfigUtils.getGlobalTimeoutInterval();
            this.endpointTimeoutType = SynapseConstants.ENDPOINT_TIMEOUT_TYPE.GLOBAL_TIMEOUT;
        }
        catch (Exception ex) {
            String msg = "Error while reading global timeout interval";
            log.error((Object)msg, (Throwable)ex);
            throw new SynapseException(msg, ex);
        }
    }

    public void setDynamicTimeoutExpression(SynapsePath expression) {
        this.dynamicTimeout = expression;
    }

    public SynapsePath getDynamicTimeoutExpression() {
        return this.dynamicTimeout;
    }

    public boolean isDynamicTimeoutEndpoint() {
        return this.dynamicTimeout != null;
    }

    public long evaluateDynamicEndpointTimeout(MessageContext synCtx) {
        long timeoutMilliSeconds;
        try {
            String stringValue = this.dynamicTimeout.stringValueOf(synCtx);
            if (stringValue != null) {
                timeoutMilliSeconds = Long.parseLong(stringValue.trim());
            } else {
                log.warn((Object)"Error while evaluating dynamic endpoint timeout expression.Synapse global timeout is taken as effective timeout.");
                timeoutMilliSeconds = this.effectiveTimeout;
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Error while evaluating dynamic endpoint timeout expression.Synapse global timeout is taken as effective timeout.");
            timeoutMilliSeconds = this.effectiveTimeout;
        }
        if (timeoutMilliSeconds > this.effectiveTimeout) {
            return this.effectiveTimeout;
        }
        return timeoutMilliSeconds;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddress(MessageContext messageContext) {
        if (this.address == null) {
            return null;
        }
        String addressString = this.address;
        String dynamicUrl = (String)messageContext.getProperty(DYNAMIC_URL_VALUE);
        if (dynamicUrl != null && !dynamicUrl.isEmpty()) {
            addressString = dynamicUrl;
        }
        boolean matches = false;
        int s = 0;
        Pattern pattern = Pattern.compile("\\$\\{.*?\\}");
        StringBuffer computedAddress = new StringBuffer();
        Matcher matcher = pattern.matcher(addressString);
        while (matcher.find()) {
            Object property = messageContext.getProperty(addressString.substring(matcher.start() + 2, matcher.end() - 1));
            if (property == null) continue;
            computedAddress.append(addressString.substring(s, matcher.start()));
            computedAddress.append(property.toString());
            s = matcher.end();
            matches = true;
        }
        if (!matches) {
            return addressString;
        }
        computedAddress.append(addressString.substring(s, addressString.length()));
        return computedAddress.toString();
    }

    public String getDynamicAddress(MessageContext messageContext) {
        if (this.address == null) {
            return null;
        }
        String addressString = this.address;
        String dynamicUrl = (String)messageContext.getProperty(DYNAMIC_URL_VALUE);
        if (dynamicUrl != null && !dynamicUrl.isEmpty()) {
            addressString = dynamicUrl;
        }
        return addressString;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Deprecated
    public boolean isReliableMessagingOn() {
        return this.reliableMessagingOn;
    }

    @Deprecated
    public void setReliableMessagingOn(boolean reliableMessagingOn) {
        this.reliableMessagingOn = reliableMessagingOn;
    }

    public boolean isAddressingOn() {
        return this.addressingOn;
    }

    public void setAddressingOn(boolean addressingOn) {
        this.addressingOn = addressingOn;
    }

    public String getAddressingVersion() {
        return this.addressingVersion;
    }

    public void setAddressingVersion(String addressingVersion) {
        this.addressingVersion = addressingVersion;
    }

    public boolean isSecurityOn() {
        return this.securityOn;
    }

    public void setSecurityOn(boolean securityOn) {
        this.securityOn = securityOn;
    }

    public String getWsSecPolicyKey() {
        return this.wsSecPolicyKey;
    }

    public void setWsSecPolicyKey(String wsSecPolicyKey) {
        this.wsSecPolicyKey = wsSecPolicyKey;
    }

    public String getInboundWsSecPolicyKey() {
        return this.inboundWsSecPolicyKey;
    }

    public void setInboundWsSecPolicyKey(String inboundWsSecPolicyKey) {
        this.inboundWsSecPolicyKey = inboundWsSecPolicyKey;
    }

    public String getOutboundWsSecPolicyKey() {
        return this.outboundWsSecPolicyKey;
    }

    public void setOutboundWsSecPolicyKey(String outboundWsSecPolicyKey) {
        this.outboundWsSecPolicyKey = outboundWsSecPolicyKey;
    }

    @Deprecated
    public String getWsRMPolicyKey() {
        return this.wsRMPolicyKey;
    }

    @Deprecated
    public void setWsRMPolicyKey(String wsRMPolicyKey) {
        this.wsRMPolicyKey = wsRMPolicyKey;
    }

    public void setUseSeparateListener(boolean b) {
        this.useSeparateListener = b;
    }

    public boolean isUseSeparateListener() {
        return this.useSeparateListener;
    }

    public void setForcePOX(boolean forcePOX) {
        this.forcePOX = forcePOX;
    }

    public boolean isForcePOX() {
        return this.forcePOX;
    }

    public boolean isForceGET() {
        return this.forceGET;
    }

    public void setForceGET(boolean forceGET) {
        this.forceGET = forceGET;
    }

    public void setForceSOAP11(boolean forceSOAP11) {
        this.forceSOAP11 = forceSOAP11;
    }

    public boolean isForceSOAP11() {
        return this.forceSOAP11;
    }

    public void setForceSOAP12(boolean forceSOAP12) {
        this.forceSOAP12 = forceSOAP12;
    }

    public boolean isForceSOAP12() {
        return this.forceSOAP12;
    }

    public boolean isForceREST() {
        return this.forceREST;
    }

    public void setForceREST(boolean forceREST) {
        this.forceREST = forceREST;
    }

    public boolean isUseMTOM() {
        return this.useMTOM;
    }

    public void setUseMTOM(boolean useMTOM) {
        this.useMTOM = useMTOM;
    }

    public boolean isUseSwa() {
        return this.useSwa;
    }

    public void setUseSwa(boolean useSwa) {
        this.useSwa = useSwa;
    }

    public long getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public long getEffectiveTimeout() {
        return this.effectiveTimeout;
    }

    public void setTimeoutDuration(long timeoutDuration) {
        this.timeoutDuration = timeoutDuration;
        this.effectiveTimeout = timeoutDuration;
        this.endpointTimeoutType = SynapseConstants.ENDPOINT_TIMEOUT_TYPE.ENDPOINT_TIMEOUT;
    }

    public int getTimeoutAction() {
        return this.timeoutAction;
    }

    public void setTimeoutAction(int timeoutAction) {
        this.timeoutAction = timeoutAction;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getCharSetEncoding() {
        return this.charSetEncoding;
    }

    public void setCharSetEncoding(String charSetEncoding) {
        this.charSetEncoding = charSetEncoding;
    }

    public long getInitialSuspendDuration() {
        return this.initialSuspendDuration;
    }

    public void setInitialSuspendDuration(long initialSuspendDuration) {
        this.initialSuspendDuration = initialSuspendDuration;
    }

    public float getSuspendProgressionFactor() {
        return this.suspendProgressionFactor;
    }

    public void setSuspendProgressionFactor(float suspendProgressionFactor) {
        this.suspendProgressionFactor = suspendProgressionFactor;
    }

    public long getSuspendMaximumDuration() {
        return this.suspendMaximumDuration;
    }

    public void setSuspendMaximumDuration(long suspendMaximumDuration) {
        this.suspendMaximumDuration = suspendMaximumDuration;
    }

    public int getRetriesOnTimeoutBeforeSuspend() {
        return this.retriesOnTimeoutBeforeSuspend;
    }

    public void setRetriesOnTimeoutBeforeSuspend(int retriesOnTimeoutBeforeSuspend) {
        this.retriesOnTimeoutBeforeSuspend = retriesOnTimeoutBeforeSuspend;
    }

    public int getRetryDurationOnTimeout() {
        return this.retryDurationOnTimeout;
    }

    public void setRetryDurationOnTimeout(int retryDurationOnTimeout) {
        this.retryDurationOnTimeout = retryDurationOnTimeout;
    }

    public List<Integer> getSuspendErrorCodes() {
        return this.suspendErrorCodes;
    }

    public List<Integer> getTimeoutErrorCodes() {
        return this.timeoutErrorCodes;
    }

    public List<Integer> getRetryDisabledErrorCodes() {
        return this.retryDisabledErrorCodes;
    }

    public List<Integer> getRetryEnableErrorCodes() {
        return this.retryEnabledErrorCodes;
    }

    public boolean isReplicationDisabled() {
        return this.replicationDisabled;
    }

    public void setReplicationDisabled(boolean replicationDisabled) {
        this.replicationDisabled = replicationDisabled;
    }

    public void addSuspendErrorCode(int code) {
        this.suspendErrorCodes.add(code);
    }

    public void addTimeoutErrorCode(int code) {
        this.timeoutErrorCodes.add(code);
    }

    public void addRetryDisabledErrorCode(int code) {
        this.retryDisabledErrorCodes.add(code);
    }

    public void addRetryEnabledErrorCode(int code) {
        this.retryEnabledErrorCodes.add(code);
    }

    public boolean isHTTPEndpoint() {
        return this.isHTTPEndpoint;
    }

    public void setHTTPEndpoint(boolean HTTPEndpoint2) {
        this.isHTTPEndpoint = HTTPEndpoint2;
    }

    public String toString() {
        if (this.leafEndpoint != null) {
            return this.leafEndpoint.toString();
        }
        if (this.address != null) {
            return "Address [" + this.address + "]";
        }
        return "[unknown endpoint]";
    }

    public void setLeafEndpoint(Endpoint leafEndpoint) {
        this.leafEndpoint = leafEndpoint;
    }

    public boolean isStatisticsEnable() {
        return this.aspectConfiguration != null && this.aspectConfiguration.isStatisticsEnable();
    }

    public void disableStatistics() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.disableStatistics();
        }
    }

    public void enableStatistics() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.enableStatistics();
        }
    }

    public boolean isTracingEnabled() {
        return this.aspectConfiguration != null && this.aspectConfiguration.isTracingEnabled();
    }

    public void disableTracing() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.disableTracing();
        }
    }

    public void enableTracing() {
        if (this.aspectConfiguration != null) {
            this.aspectConfiguration.enableTracing();
        }
    }

    @Override
    public void configure(AspectConfiguration aspectConfiguration) {
        this.aspectConfiguration = aspectConfiguration;
    }

    @Override
    public AspectConfiguration getAspectConfiguration() {
        return this.aspectConfiguration;
    }

    public SynapseConstants.ENDPOINT_TIMEOUT_TYPE getEndpointTimeoutType() {
        return this.endpointTimeoutType;
    }

    public void setEndpointTimeoutType(SynapseConstants.ENDPOINT_TIMEOUT_TYPE endpointTimeoutType) {
        this.endpointTimeoutType = endpointTimeoutType;
    }

    public SynapsePath getDynamicPolicy() {
        return this.dynamicPolicy;
    }

    public void setDynamicPolicy(SynapsePath dynamicPolicy) {
        this.dynamicPolicy = dynamicPolicy;
    }

    public boolean isDynamicPolicy() {
        return this.dynamicPolicy != null;
    }

    public String evaluateDynamicEndpointSecurityPolicy(MessageContext synCtx) {
        String wsSePolicy;
        String stringValue = this.dynamicPolicy.stringValueOf(synCtx);
        if (stringValue != null) {
            wsSePolicy = stringValue.trim();
        } else {
            log.warn((Object)"Error while evaluating dynamic endpoint timeout expression.Synapse global timeout is taken as effective timeout.");
            wsSePolicy = this.wsSecPolicyKey;
        }
        return wsSePolicy;
    }
}

