/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.json.JSONObject;

public class DefaultEndpoint
extends AbstractEndpoint {
    @Override
    public void onFault(MessageContext synCtx) {
        this.logSetter();
        if (this.getContext().isMaxRetryLimitReached()) {
            this.getContext().onFailoverRetryLimit();
        } else if (this.isTimeout(synCtx)) {
            this.getContext().onTimeout();
        } else if (this.isSuspendFault(synCtx)) {
            this.getContext().onFault();
        }
        this.setErrorOnMessage(synCtx, null, null);
        super.onFault(synCtx);
    }

    @Override
    public void onSuccess() {
        if (this.getContext() != null) {
            this.getContext().onSuccess();
        }
    }

    @Override
    protected void createJsonRepresentation() {
        this.endpointJson = new JSONObject();
        this.endpointJson.put("name", (Object)this.getName());
        this.endpointJson.put("type", (Object)"Default Endpoint");
        this.endpointJson.put("children", (Object)this.getEndpointChildrenAsJson(this.getChildren()));
        this.setAdvancedProperties();
    }

    @Override
    public void send(MessageContext synCtx) {
        this.logSetter();
        if (synCtx.getTo().isWSAddressingAnonymous()) {
            this.log.warn((Object)"'To' header was set to http://www.w3.org/2005/08/addressing/anonymous, Message will be passed to the fault sequence");
            this.informFailure(synCtx, 303001, "'To' header was set to http://www.w3.org/2005/08/addressing/anonymous");
            return;
        }
        org.apache.axis2.context.MessageContext messageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Pipe pipe = (Pipe)messageContext.getProperty("pass-through.pipe");
        if (pipe != null && !Boolean.TRUE.equals(messageContext.getProperty("message.builder.invoked")) && messageContext.getProperty("To") == null) {
            try {
                RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (boolean)false);
            }
            catch (Exception e) {
                this.handleException("Error while building message", e, synCtx);
            }
        }
        if (this.getParentEndpoint() == null && !this.readyToSend()) {
            this.informFailure(synCtx, 303001, "Currently , Default endpoint : " + this.getContext());
        } else {
            super.send(synCtx);
        }
    }
}

