/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.json.JSONObject;

public class ClassEndpoint
extends AbstractEndpoint {
    private final Map<String, String> parameters = new HashMap<String, String>();
    private Endpoint classEndpoint;

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setClassEndpoint(Endpoint classEndpoint) {
        this.classEndpoint = classEndpoint;
    }

    public Endpoint getClassEndpoint() {
        return this.classEndpoint;
    }

    @Override
    public void send(MessageContext synCtx) {
        if (RuntimeStatisticCollector.isStatisticsEnabled()) {
            Integer currentIndex = null;
            if (this.getDefinition() != null) {
                currentIndex = OpenEventCollector.reportChildEntryEvent(synCtx, this.getReportingName(), ComponentType.ENDPOINT, this.getDefinition().getAspectConfiguration(), true);
            }
            try {
                this.sendMessage(synCtx);
            }
            finally {
                if (currentIndex != null) {
                    CloseEventCollector.closeEntryEvent(synCtx, this.getReportingName(), ComponentType.MEDIATOR, currentIndex, false);
                }
            }
        } else {
            this.sendMessage(synCtx);
        }
    }

    @Override
    protected void createJsonRepresentation() {
        this.endpointJson = new JSONObject();
        this.endpointJson.put("name", (Object)this.getName());
        this.endpointJson.put("type", (Object)"Class Endpoint");
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initiate the synapse environment of the class endpoint");
        }
        try {
            this.classEndpoint.init(synapseEnvironment);
        }
        catch (Exception e) {
            throw new SynapseException("Error occured when initiate the class endpoint", e);
        }
    }

    public void sendMessage(MessageContext synMessageContext) {
        this.logSetter();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Start sending message");
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Message : " + synMessageContext.getEnvelope()));
            }
        }
        try {
            this.classEndpoint.send(synMessageContext);
        }
        catch (Exception e) {
            throw new SynapseException("Error occured when execute the class endpoint", e);
        }
    }
}

