/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.json.JSONObject;

public class AddressEndpoint
extends AbstractEndpoint {
    @Override
    public void onFault(MessageContext synCtx) {
        this.logSetter();
        if (this.getContext().isMaxRetryLimitReached()) {
            this.getContext().onFailoverRetryLimit();
        } else if (this.isTimeout(synCtx)) {
            this.getContext().onTimeout();
        } else if (this.isSuspendFault(synCtx)) {
            this.getContext().onFault();
        }
        this.setErrorOnMessage(synCtx, null, null);
        super.onFault(synCtx);
    }

    @Override
    public void onSuccess() {
        if (this.getContext() != null) {
            this.getContext().onSuccess();
        }
    }

    @Override
    protected void createJsonRepresentation() {
        this.endpointJson = new JSONObject();
        this.endpointJson.put("name", (Object)this.getName());
        this.endpointJson.put("type", (Object)"Address Endpoint");
        this.endpointJson.put("address", (Object)this.getDefinition().getAddress());
        this.setAdvancedProperties();
    }

    @Override
    public void send(MessageContext synCtx) {
        this.logSetter();
        if (this.getParentEndpoint() == null && !this.readyToSend()) {
            this.informFailure(synCtx, 303001, "Currently , Address endpoint : " + this.getContext());
        } else {
            super.send(synCtx);
        }
    }
}

