/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.PropertyInclude;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessController;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessReplicator;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointContext;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.EndpointView;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.util.logging.LoggingUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractEndpoint
extends FaultHandler
implements Endpoint,
PropertyInclude {
    protected Log log;
    protected static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private String endpointName = null;
    private String description = null;
    private Endpoint parentEndpoint = null;
    private List<Endpoint> children = null;
    private EndpointDefinition definition = null;
    protected volatile boolean initialized = false;
    private EndpointContext context = null;
    protected Boolean isClusteringEnabled = null;
    EndpointView metricsMBean = null;
    protected String fileName;
    private Map<String, MediatorProperty> properties = new HashMap<String, MediatorProperty>();
    protected boolean anonymous = false;
    protected String errorHandler = null;
    private boolean enableMBeanStats = true;
    private boolean contentAware = false;
    private boolean forceBuildMC = false;
    protected String artifactContainerName;
    private boolean isEdited = false;
    public static final String NAME_JSON_ATT = "name";
    public static final String TYPE_JSON_ATT = "type";
    public static final String CHILDREN_JSON_ATT = "children";
    JSONObject endpointJson = null;
    private List<String> commentsList = new ArrayList<String>();

    protected AbstractEndpoint() {
        this.log = LogFactory.getLog(this.getClass());
    }

    @Override
    public EndpointView getMetricsMBean() {
        return this.metricsMBean;
    }

    @Override
    public EndpointContext getContext() {
        return this.context;
    }

    @Override
    public String getName() {
        return this.endpointName;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public EndpointDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(EndpointDefinition definition) {
        this.definition = definition;
        definition.setLeafEndpoint(this);
    }

    public Endpoint getParentEndpoint() {
        return this.parentEndpoint;
    }

    @Override
    public void setParentEndpoint(Endpoint parentEndpoint) {
        this.parentEndpoint = parentEndpoint;
    }

    @Override
    public List<Endpoint> getChildren() {
        return this.children;
    }

    public void setChildren(List<Endpoint> children) {
        this.children = children;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        if (this.endpointName != null) {
            return "Endpoint [" + this.endpointName + "]";
        }
        return "AnonymousEndpoint";
    }

    @Override
    public void setName(String endpointName) {
        this.endpointName = endpointName;
        if (this.enableMBeanStats) {
            this.metricsMBean = new EndpointView(endpointName, this);
            MBeanRegistrar.getInstance().registerMBean((Object)this.metricsMBean, "Endpoint", endpointName);
        }
    }

    @Override
    public void setArtifactContainerName(String name) {
        this.artifactContainerName = name;
    }

    @Override
    public String getArtifactContainerName() {
        return this.artifactContainerName;
    }

    @Override
    public boolean getIsEdited() {
        return this.isEdited;
    }

    @Override
    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    public void setEnableMBeanStats(boolean flag) {
        this.enableMBeanStats = flag;
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        ConfigurationContext cc = ((Axis2SynapseEnvironment)synapseEnvironment).getAxis2ConfigurationContext();
        if (!this.initialized) {
            ClusteringAgent clusteringAgent = cc.getAxisConfiguration().getClusteringAgent();
            this.isClusteringEnabled = clusteringAgent != null && clusteringAgent.getStateManager() != null ? Boolean.TRUE : Boolean.FALSE;
            this.context = new EndpointContext(this.getName(), this.getDefinition(), this.isClusteringEnabled, cc, this.metricsMBean);
        }
        this.initialized = true;
        if (this.children != null) {
            for (Endpoint e : this.children) {
                e.init(synapseEnvironment);
            }
        }
        this.contentAware = this.definition != null && (this.definition.getFormat() != null && !this.definition.getFormat().equals("rest") || this.definition.isSecurityOn() || this.definition.isReliableMessagingOn() || this.definition.isAddressingOn() || this.definition.isUseMTOM() || this.definition.isUseSwa());
    }

    public List<String> getCommentsList() {
        return this.commentsList;
    }

    public void setCommentsList(List<String> commentsList) {
        this.commentsList = commentsList;
    }

    @Override
    public boolean readyToSend() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized, endpoint must be in initialized state");
        }
        return this.context != null && this.context.readyToSend();
    }

    @Override
    public void send(MessageContext synCtx) {
        this.logSetter();
        Integer statisticReportingIndex = null;
        boolean isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        if (isStatisticsEnabled) {
            statisticReportingIndex = OpenEventCollector.reportEntryEvent(synCtx, this.getReportingName(), this.definition.getAspectConfiguration(), ComponentType.ENDPOINT);
        }
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (!this.initialized) {
            throw new IllegalStateException("not initialized, endpoint must be in initialized state");
        }
        this.prepareForEndpointStatistics(synCtx);
        if (traceOrDebugOn) {
            String address = this.definition.getAddress();
            if (address == null && synCtx.getTo() != null && synCtx.getTo().getAddress() != null) {
                address = synCtx.getTo().getAddress();
            }
            this.traceOrDebug(traceOn, "Sending message through endpoint : " + this.getName() + " resolving to address = " + address);
            this.traceOrDebug(traceOn, "SOAPAction: " + (synCtx.getSoapAction() != null ? synCtx.getSoapAction() : "null"));
            this.traceOrDebug(traceOn, "WSA-Action: " + (synCtx.getWSAAction() != null ? synCtx.getWSAAction() : "null"));
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Envelope : \n" + synCtx.getEnvelope()));
            }
        }
        if (this.errorHandler != null) {
            Mediator errorHandlerMediator = synCtx.getSequence(this.errorHandler);
            if (errorHandlerMediator != null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Setting the onError handler : " + this.errorHandler + " for the endpoint : " + this.endpointName);
                }
                synCtx.pushFaultHandler(new MediatorFaultHandler(errorHandlerMediator));
            } else {
                this.log.warn((Object)("onError handler sequence : " + this.errorHandler + " for : " + this.endpointName + " cannot be found"));
            }
        }
        synCtx.pushFaultHandler(this);
        synCtx.setProperty("last_endpoint", this);
        org.apache.axis2.context.MessageContext axis2Ctx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        axis2Ctx.setProperty("METRICS_COLLECTOR", (Object)this.metricsMBean);
        if (this.contentAware) {
            try {
                RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (boolean)false);
                axis2Ctx.setProperty("FORCE_RESPONSE_EARLY_BUILD", (Object)Boolean.TRUE);
                if (this.forceBuildMC) {
                    ((Axis2MessageContext)synCtx).getAxis2MessageContext().getEnvelope().build();
                }
            }
            catch (Exception e) {
                this.handleException("Error while building message", e, synCtx);
            }
        }
        this.evaluateProperties(synCtx);
        MediatorProperty preserveEnv = this.getProperty("PRESERVE_ENVELOPE");
        if (preserveEnv != null && JavaUtils.isTrueExplicitly((String)(preserveEnv.getValue() != null ? preserveEnv.getValue() : preserveEnv.getEvaluatedExpression(synCtx)))) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Preserving the envelope by building it before sending, since it is explicitly set");
            }
            synCtx.getEnvelope().build();
        }
        synCtx.getEnvironment().send(this.definition, synCtx);
        if (isStatisticsEnabled) {
            CloseEventCollector.closeEntryEvent(synCtx, this.getReportingName(), ComponentType.ENDPOINT, statisticReportingIndex, false);
        }
    }

    public boolean isLeafEndpoint() {
        return this.children == null || this.children.size() == 0;
    }

    @Override
    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
    }

    public void executeEpTypeSpecificFunctions(MessageContext synCtx) {
    }

    protected boolean isTimeout(MessageContext synCtx) {
        Object error = synCtx.getProperty("ERROR_CODE");
        Integer errorCode = 0;
        if (error != null) {
            try {
                errorCode = Integer.parseInt(error.toString());
            }
            catch (NumberFormatException e) {
                errorCode = 0;
            }
        }
        if (errorCode != null) {
            if (this.definition.getTimeoutErrorCodes().isEmpty()) {
                boolean isClosed;
                boolean isTimeout = 101504 == errorCode;
                boolean bl = isClosed = 101505 == errorCode;
                if (isTimeout || isClosed) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Encountered a default HTTP connection " + (isClosed ? "close" : "timeout") + " error : " + errorCode));
                    }
                    return true;
                }
            } else if (this.definition.getTimeoutErrorCodes().contains(errorCode)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Encountered a mark for suspension error : " + errorCode + " defined error codes are : " + this.definition.getTimeoutErrorCodes()));
                }
                return true;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Encountered a non-timeout error sending to " + this.toString() + ", error code : " + errorCode));
        }
        return false;
    }

    protected boolean isRetry(MessageContext synCtx) {
        Integer errorCode = (Integer)synCtx.getProperty("ERROR_CODE");
        if (errorCode != null && this.definition != null) {
            if (this.definition.getRetryDisabledErrorCodes().contains(errorCode)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Encountered a retry disabled error : " + errorCode + ", defined retry disabled error codes are : " + this.definition.getRetryDisabledErrorCodes()));
                }
                return false;
            }
            if (this.definition.getRetryEnableErrorCodes().size() > 0) {
                if (this.definition.getRetryEnableErrorCodes().contains(errorCode)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Encountered a retry enabled error : " + errorCode + ", defined retry Enable error codes are : " + this.definition.getRetryEnableErrorCodes()));
                    }
                    return true;
                }
                return false;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Encountered an error sending to endpoint : " + this.endpointName + ", with error code : " + errorCode + ", but not a retry disabled error"));
        }
        return true;
    }

    protected boolean isSuspendFault(MessageContext synCtx) {
        Integer errorCode = (Integer)synCtx.getProperty("ERROR_CODE");
        if (errorCode != null) {
            if (this.definition.getSuspendErrorCodes().isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(this.toString() + " encountered a fatal error : " + errorCode));
                }
                return true;
            }
            if (this.definition.getSuspendErrorCodes().contains(errorCode)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Encountered a suspend error : " + errorCode + " defined suspend codes are : " + this.definition.getSuspendErrorCodes()));
                }
                return true;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Encountered a non-fatal error sending to " + this.toString() + ", error code : " + errorCode + ". Error will be handled, but endpoint will not fail"));
        }
        return false;
    }

    @Override
    public void onFault(MessageContext synCtx) {
        EndpointDefinition endpointDefinition = this.getDefinition();
        if (endpointDefinition != null && endpointDefinition.getTimeoutAction() == 101) {
            this.log.info((Object)"Ignoring fault handlers since the timeout action is set to DISCARD");
        } else {
            this.logSetter();
            this.invokeNextFaultHandler(synCtx);
        }
    }

    @Override
    public void onSuccess() {
    }

    protected boolean isTraceOn(MessageContext msgCtx) {
        return this.definition.getAspectConfiguration() != null && this.definition.getAspectConfiguration().isTracingEnabled();
    }

    protected boolean isTraceOrDebugOn(boolean isTraceOn) {
        return isTraceOn || this.log.isDebugEnabled();
    }

    protected void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)msg);
        }
    }

    protected void prepareForEndpointStatistics(MessageContext synCtx) {
        if (this.definition != null && this.definition.isStatisticsEnable()) {
            String opName = null;
            if (synCtx.getProperty("endpoint.operation") != null) {
                opName = synCtx.getProperty("endpoint.operation").toString();
            } else if (synCtx instanceof Axis2MessageContext) {
                AxisOperation operation = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getAxisOperation();
                if (operation != null) {
                    opName = operation.getName().getLocalPart();
                }
                if (opName == null || SynapseConstants.SYNAPSE_OPERATION_NAME.getLocalPart().equals(opName)) {
                    String soapAction = synCtx.getSoapAction();
                    opName = null;
                    if (soapAction != null) {
                        int index = soapAction.indexOf("urn:");
                        opName = index >= 0 ? soapAction.substring("urn:".length()) : soapAction;
                    }
                }
            }
            AspectConfiguration oldConfiguration = this.definition.getAspectConfiguration();
            if (opName != null) {
                AspectConfiguration newConfiguration = new AspectConfiguration(oldConfiguration.getId() + "__" + opName);
                if (oldConfiguration.isStatisticsEnable()) {
                    newConfiguration.enableStatistics();
                }
                if (oldConfiguration.isTracingEnabled()) {
                    newConfiguration.enableTracing();
                }
            }
        }
    }

    protected void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SynapseException(msg);
    }

    protected void handleException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    protected void handleException(String msg, Exception e, MessageContext msgCtx) {
        String formattedLog = LoggingUtils.getFormattedLog(msgCtx, msg);
        this.log.error((Object)formattedLog, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    protected void logOnChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        this.log.warn((Object)(this + " Detect a Failure in a child endpoint : " + endpoint));
    }

    protected void informFailure(MessageContext synCtx, int errorCode, String errorMsg) {
        Boolean isConcurrencyThrottleEnabled = (Boolean)synCtx.getProperty("synapse.concurrency.throttle");
        if (isConcurrencyThrottleEnabled != null && isConcurrencyThrottleEnabled.booleanValue()) {
            ConcurrentAccessController concurrentAccessController = (ConcurrentAccessController)synCtx.getProperty("synapse.concurrent.access.controller");
            int available = concurrentAccessController.incrementAndGet();
            int concurrentLimit = concurrentAccessController.getLimit();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Concurrency Throttle : Connection returned :: " + available + " of available of " + concurrentLimit + " connections"));
            }
            ConcurrentAccessReplicator concurrentAccessReplicator = (ConcurrentAccessReplicator)synCtx.getProperty("synapse.concurrent.access.replicator");
            String throttleKey = (String)synCtx.getProperty("synapse.concurrency.throttle.key");
            if (concurrentAccessReplicator != null) {
                concurrentAccessReplicator.replicate(throttleKey, Boolean.valueOf(true));
            }
        }
        if (synCtx.getProperty("last_endpoint") == null) {
            this.setErrorOnMessage(synCtx, errorCode, errorMsg);
        }
        this.invokeNextFaultHandler(synCtx);
    }

    protected void setErrorOnMessage(MessageContext synCtx, Integer errorCode, String errorMsg) {
        Map mEndpointLog = (Map)synCtx.getProperty("endpoint_log");
        if (mEndpointLog != null) {
            AbstractEndpoint lastEndpoint = (AbstractEndpoint)synCtx.getProperty("last_endpoint");
            Object oErrorCode = synCtx.getProperty("ERROR_CODE");
            if (lastEndpoint != null && lastEndpoint.getName() != null && oErrorCode != null) {
                try {
                    mEndpointLog.put(lastEndpoint.getName(), (Integer)oErrorCode);
                }
                catch (NumberFormatException nfe) {
                    this.log.error((Object)"Unable to get the error code for endpoint");
                }
            }
        }
        synCtx.setProperty("ERROR_CODE", errorCode);
        synCtx.setProperty("ERROR_MESSAGE", errorMsg);
        synCtx.setProperty("ERROR_DETAIL", errorMsg);
        synCtx.setProperty("ERROR_EXCEPTION", errorMsg);
    }

    private void invokeNextFaultHandler(MessageContext synCtx) {
        Stack<FaultHandler> faultStack = synCtx.getFaultStack();
        if (!faultStack.isEmpty()) {
            FaultHandler faultHandler = faultStack.pop();
            if (faultHandler instanceof Endpoint) {
                ((Endpoint)((Object)faultHandler)).onChildEndpointFail(this, synCtx);
            } else if (faultHandler instanceof MediatorFaultHandler) {
                if (!this.executeLastSequenceFaultHandler(synCtx)) {
                    faultHandler.handleFault(synCtx);
                }
            } else {
                faultHandler.handleFault(synCtx);
            }
        } else {
            this.executeLastSequenceFaultHandler(synCtx);
        }
    }

    private boolean executeLastSequenceFaultHandler(MessageContext synCtx) {
        Object errorCode = synCtx.getProperty("ERROR_CODE");
        Object lastSequenceFaultHandler = synCtx.getProperty("LAST_SEQ_FAULT_HANDLER");
        if (lastSequenceFaultHandler != null && errorCode != null && errorCode instanceof Integer && (Integer)errorCode == 101503) {
            ((FaultHandler)lastSequenceFaultHandler).handleFault(synCtx, null);
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        if (this.metricsMBean != null) {
            this.metricsMBean.destroy();
        }
        if (this.enableMBeanStats) {
            MBeanRegistrar.getInstance().unRegisterMBean("Endpoint", this.endpointName);
        }
        this.metricsMBean = null;
        this.initialized = false;
    }

    @Override
    public void addProperty(MediatorProperty property) {
        this.properties.put(property.getName(), property);
    }

    @Override
    public MediatorProperty getProperty(String name) {
        MediatorProperty value = this.properties.get(name);
        if (value == null && this.getParentEndpoint() instanceof PropertyInclude) {
            value = ((PropertyInclude)((Object)this.getParentEndpoint())).getProperty(name);
        }
        return value;
    }

    @Override
    public Collection<MediatorProperty> getProperties() {
        return this.properties.values();
    }

    @Override
    public MediatorProperty removeProperty(String name) {
        return this.properties.remove(name);
    }

    @Override
    public void addProperties(Collection<MediatorProperty> mediatorProperties) {
        for (MediatorProperty property : mediatorProperties) {
            this.properties.put(property.getName(), property);
        }
    }

    @Override
    public String getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setContentAware(boolean contentAware) {
        this.contentAware = contentAware;
    }

    public void setForceBuildMC(boolean forceBuildMC) {
        this.forceBuildMC = forceBuildMC;
    }

    protected void evaluateProperties(MessageContext synCtx) {
        Set<Map.Entry<String, MediatorProperty>> propertySet = this.properties.entrySet();
        for (Map.Entry<String, MediatorProperty> e : propertySet) {
            e.getValue().evaluate(synCtx);
        }
    }

    public void logSetter() {
        CustomLogSetter.getInstance().setLogAppender(this.artifactContainerName);
    }

    public String getReportingName() {
        if (this.endpointName != null) {
            return this.endpointName;
        }
        return "AnonymousEndpoint";
    }

    private boolean isStatisticCollected() {
        return this.definition.getAspectConfiguration() != null && this.definition.getAspectConfiguration().isStatisticsEnable() && this.endpointName != null;
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this instanceof IndirectEndpoint) {
            String sequenceId = StatisticIdentityGenerator.getIdReferencingComponent(((IndirectEndpoint)this).getKey(), ComponentType.ENDPOINT, holder);
            StatisticIdentityGenerator.reportingEndEvent(sequenceId, ComponentType.ENDPOINT, holder);
        } else {
            if (this.definition == null) {
                EndpointDefinition definition = new EndpointDefinition();
                this.setDefinition(definition);
            }
            if (this.definition.getAspectConfiguration() == null) {
                this.definition.configure(new AspectConfiguration(this.getReportingName()));
            }
            String sequenceId = StatisticIdentityGenerator.getIdForComponent(this.getReportingName(), ComponentType.ENDPOINT, holder);
            this.definition.getAspectConfiguration().setUniqueId(sequenceId);
            StatisticIdentityGenerator.reportingEndEvent(sequenceId, ComponentType.ENDPOINT, holder);
        }
    }

    protected void setAdvancedProperties() {
        JSONObject advancedProps = new JSONObject();
        this.endpointJson.put("advanced", (Object)advancedProps);
        this.setSuspendStateProperties(this.getDefinition(), advancedProps);
        this.setTimeoutStateProperties(this.getDefinition(), advancedProps);
    }

    private void setTimeoutStateProperties(EndpointDefinition definition, JSONObject advancedProps) {
        JSONObject timeoutStateProps = new JSONObject();
        advancedProps.put("timeoutState", (Object)timeoutStateProps);
        timeoutStateProps.put("errorCodes", definition.getTimeoutErrorCodes());
        timeoutStateProps.put("reties", definition.getRetriesOnTimeoutBeforeSuspend());
    }

    private void setSuspendStateProperties(EndpointDefinition definition, JSONObject advancedProps) {
        JSONObject suspendStatePros = new JSONObject();
        advancedProps.put("suspendState", (Object)suspendStatePros);
        suspendStatePros.put("errorCodes", definition.getSuspendErrorCodes());
        suspendStatePros.put("maxDuration", definition.getSuspendMaximumDuration());
        suspendStatePros.put("initialDuration", definition.getInitialSuspendDuration());
    }

    protected JSONArray getEndpointChildrenAsJson(List<Endpoint> children) {
        JSONArray childrenJsonList = new JSONArray();
        if (children != null && children.size() != 0) {
            for (Endpoint child : children) {
                childrenJsonList.put((Object)child.getJsonRepresentation());
            }
        }
        return childrenJsonList;
    }

    @Override
    public JSONObject getJsonRepresentation() {
        if (this.endpointJson == null) {
            this.createJsonRepresentation();
        }
        return this.endpointJson;
    }

    protected abstract void createJsonRepresentation();
}

