/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SynapseArtifactDeploymentStore {
    private Map<String, String> fileName2ArtifactName = new HashMap<String, String>();
    private Map<String, String> updatingArtifacts = new HashMap<String, String>();
    private Set<String> restoredFiles = new HashSet<String>();
    private Set<String> backedUpFiles = new HashSet<String>();
    private String mainSeqLstUpdatedFile = "main.xml";
    private String faultSeqLstUpdatedFile = "fault.xml";
    private static final Log log = LogFactory.getLog(SynapseArtifactDeploymentStore.class);
    private Map<String, ClassLoader> classMediatorClassLoaders = new HashMap<String, ClassLoader>();

    public void addArtifact(String fileName, String artifactName) {
        if (!this.fileName2ArtifactName.containsKey(fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added deployment artifact with file : " + fileName));
            }
            this.fileName2ArtifactName.put(fileName, artifactName);
        } else {
            log.error((Object)("An artifact has already been loaded from the file : " + fileName));
        }
    }

    public boolean containsFileName(String fileName) {
        return this.fileName2ArtifactName.containsKey(SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName));
    }

    public String getArtifactNameForFile(String fileName) {
        return this.fileName2ArtifactName.get(SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName));
    }

    public void removeArtifactWithFileName(String fileName) {
        fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing deployment artifact with file : " + fileName));
        }
        this.fileName2ArtifactName.remove(fileName);
    }

    public void addUpdatingArtifact(String fileName, String artifactName) {
        fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added updating file : " + fileName));
        }
        this.updatingArtifacts.put(fileName, artifactName);
    }

    public boolean isUpdatingArtifact(String fileName) {
        return this.updatingArtifacts.containsKey(SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName));
    }

    public String getUpdatingArtifactWithFileName(String fileName) {
        return this.updatingArtifacts.get(SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName));
    }

    public void removeUpdatingArtifact(String fileName) {
        fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing the updating file : " + fileName));
        }
        this.updatingArtifacts.remove(fileName);
    }

    public void addRestoredArtifact(String fileName) {
        fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added restored file : " + fileName));
        }
        this.restoredFiles.add(fileName);
    }

    public boolean isRestoredFile(String fileName) {
        return this.restoredFiles.contains(SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName));
    }

    public void removeRestoredFile(String fileName) {
        fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing restored file : " + fileName));
        }
        this.restoredFiles.remove(fileName);
    }

    public void addBackedUpArtifact(String fileName) {
        fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added backup file : " + fileName));
        }
        this.backedUpFiles.add(fileName);
    }

    public boolean isBackedUpArtifact(String fileName) {
        return this.backedUpFiles.contains(SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName));
    }

    public void removeBackedUpArtifact(String fileName) {
        fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing backup file : " + fileName));
        }
        this.backedUpFiles.remove(fileName);
    }

    public static String getNormalizedAbsolutePath(String fileName) {
        String path;
        File file = new File(fileName);
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            log.warn((Object)("Error while computing the canonical path of file: " + fileName));
            path = file.getAbsolutePath();
        }
        return FilenameUtils.normalize((String)path);
    }

    public String getMainSeqLstUpdatedFile() {
        return this.mainSeqLstUpdatedFile;
    }

    public void setMainSeqLstUpdatedFile(String mainSeqLstUpdatedFile) {
        String mainSeqFile;
        this.mainSeqLstUpdatedFile = mainSeqFile = mainSeqLstUpdatedFile.substring(mainSeqLstUpdatedFile.lastIndexOf(File.separator) + 1);
    }

    public String getFaultSeqLstUpdatedFile() {
        return this.faultSeqLstUpdatedFile;
    }

    public void setFaultSeqLstUpdatedFile(String faultSeqLstUpdatedFile) {
        String faultSeqFile;
        this.faultSeqLstUpdatedFile = faultSeqFile = faultSeqLstUpdatedFile.substring(faultSeqLstUpdatedFile.lastIndexOf(File.separator) + 1);
    }

    public Map<String, ClassLoader> getClassMediatorClassLoaders() {
        return this.classMediatorClassLoaders;
    }

    public void addClassMediatorClassLoader(String path, ClassLoader classLoader) {
        this.classMediatorClassLoaders.put(path, classLoader);
    }

    public void removeClassMediatorClassLoader(String path) {
        this.classMediatorClassLoaders.remove(path);
    }
}

