/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.inbound.InboundEndpointFactory;
import org.apache.synapse.config.xml.inbound.InboundEndpointSerializer;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;

public class InboundEndpointDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(InboundEndpointDeployer.class);
    private static String ARTIFACT_TYPE = "inbound-endpoint";

    @Override
    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        CustomLogSetter.getInstance().setLogAppender(this.customLogContent);
        if (log.isDebugEnabled()) {
            log.debug((Object)("InboundEndpoint deployment from file : " + fileName + " : Started"));
        }
        try {
            InboundEndpoint inboundEndpoint = InboundEndpointFactory.createInboundEndpoint(artifactConfig, this.getSynapseConfiguration());
            if (inboundEndpoint != null) {
                inboundEndpoint.setArtifactContainerName(this.customLogContent);
                inboundEndpoint.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inbound Endpoint named '" + inboundEndpoint.getName() + "' has been built from the file " + fileName));
                }
                inboundEndpoint.init(this.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the Inbound Endpoint: " + inboundEndpoint.getName()));
                }
                this.getSynapseConfiguration().addInboundEndpoint(inboundEndpoint.getName(), inboundEndpoint);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inbound Endpoint deployment from file : " + fileName + " : Completed"));
                }
                String startTime = String.valueOf(System.currentTimeMillis());
                this.executeExtendedSynapseHandlerOnArtifactDeployment(inboundEndpoint.getName(), ARTIFACT_TYPE, startTime);
                log.info((Object)("Inbound Endpoint named '" + inboundEndpoint.getName() + "' has been deployed from file : " + fileName));
                return inboundEndpoint.getName();
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Inbound Endpoint deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    @Override
    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Inbound Endpoint update from file : " + fileName + " has started"));
        }
        try {
            InboundEndpoint inboundEndpoint = InboundEndpointFactory.createInboundEndpoint(artifactConfig, this.getSynapseConfiguration());
            if (inboundEndpoint == null) {
                this.handleSynapseArtifactDeploymentError("Inbound Endpoint update failed. The artifact defined in the file: " + fileName + " is not a valid Inbound Endpoint.");
                return null;
            }
            CustomLogSetter.getInstance().setLogAppender(inboundEndpoint.getArtifactContainerName());
            inboundEndpoint.setFileName(new File(fileName).getName());
            inboundEndpoint.setArtifactContainerName(this.customLogContent);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inbound Endpoint: " + inboundEndpoint.getName() + " has been built from the file: " + fileName));
            }
            InboundEndpoint existingInboundEndpoint = this.getSynapseConfiguration().getInboundEndpoint(existingArtifactName);
            existingInboundEndpoint.destroy();
            inboundEndpoint.init(this.getSynapseEnvironment());
            if (existingArtifactName.equals(inboundEndpoint.getName())) {
                this.getSynapseConfiguration().updateInboundEndpoint(existingArtifactName, inboundEndpoint);
            } else {
                this.getSynapseConfiguration().addInboundEndpoint(inboundEndpoint.getName(), inboundEndpoint);
                this.getSynapseConfiguration().removeInboundEndpoint(existingArtifactName);
                log.info((Object)("Inbound Endpoint: " + existingArtifactName + " has been undeployed"));
            }
            log.info((Object)("Inbound Endpoint: " + inboundEndpoint.getName() + " has been updated from the file: " + fileName));
            this.waitForCompletion();
            return inboundEndpoint.getName();
        }
        catch (DeploymentException e) {
            this.handleSynapseArtifactDeploymentError("Error while updating the Inbound Endpoint from the file: " + fileName);
            return null;
        }
    }

    @Override
    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Undeployment of the Inbound Endpoint named : " + artifactName + " : Started"));
        }
        try {
            InboundEndpoint inboundEndpoint = this.getSynapseConfiguration().getInboundEndpoint(artifactName);
            if (inboundEndpoint != null) {
                CustomLogSetter.getInstance().setLogAppender(inboundEndpoint.getArtifactContainerName());
                inboundEndpoint.destroy();
                this.getSynapseConfiguration().removeInboundEndpoint(artifactName);
                String unDeployTime = String.valueOf(System.currentTimeMillis());
                this.executeSynapseHandlerOnArtifactUnDeployment(inboundEndpoint.getName(), ARTIFACT_TYPE, unDeployTime);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Undeployment of the Inbound Endpoint named : " + artifactName + " : Completed"));
                }
                log.info((Object)("Inbound Endpoint named '" + inboundEndpoint.getName() + "' has been undeployed"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Inbound Endpoint " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Undeployment of Inbound Endpoint named : " + artifactName + " : Failed", e);
        }
    }

    @Override
    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring the Inbound Endpoint with name : " + artifactName + " : Started"));
        }
        try {
            InboundEndpoint inboundEndpoint = this.getSynapseConfiguration().getInboundEndpoint(artifactName);
            CustomLogSetter.getInstance().setLogAppender(inboundEndpoint != null ? inboundEndpoint.getArtifactContainerName() : "");
            OMElement inboundEndpointElement = InboundEndpointSerializer.serializeInboundEndpoint(inboundEndpoint);
            if (inboundEndpoint.getFileName() != null) {
                String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "inbound-endpoints" + File.separator + inboundEndpoint.getFileName();
                this.writeToFile(inboundEndpointElement, fileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring the Inbound Endpoint with name : " + artifactName + " : Completed"));
                }
                log.info((Object)("Inbound Endpoint named '" + artifactName + "' has been restored"));
            } else {
                this.handleSynapseArtifactDeploymentError("Couldn't restore the Inbound Endpoint named '" + artifactName + "', filename cannot be found");
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the Inbound Endpoint named '" + artifactName + "' has failed", e);
        }
    }
}

