/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.SynapseImportFactory;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.util.LibDeployerUtils;

public class ImportDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(ImportDeployer.class);

    @Override
    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Synapse Import Deployment from file : " + fileName + " : Started"));
        }
        try {
            SynapseImport synImport = SynapseImportFactory.createImport(artifactConfig, properties);
            String synImportQualfiedName = LibDeployerUtils.getQualifiedName(synImport);
            SynapseImport existingImport = this.getSynapseConfiguration().getSynapseImports().get(synImportQualfiedName);
            if (existingImport != null) {
                log.warn((Object)("Synapse Import with the name : " + synImportQualfiedName + " already exists! Could not load multiple Imports of same type."));
                String backedUp = this.backupFile(new File(fileName));
                log.info((Object)("Synapse Import with the name : " + synImportQualfiedName + " is now backed up in : " + backedUp));
                return null;
            }
            if (synImport != null) {
                synImport.setFileName(new File(fileName).getName());
                this.getSynapseConfiguration().addSynapseImport(synImportQualfiedName, synImport);
                Library synLib = this.getSynapseConfiguration().getSynapseLibraries().get(synImportQualfiedName);
                if (synLib != null) {
                    if (synImport.isStatus()) {
                        synLib.getArtifacts().put("SynapseConfiguration", this.getSynapseConfiguration());
                        LibDeployerUtils.loadLibArtifacts(synImport, synLib);
                    } else {
                        synLib.setLibStatus(false);
                        synLib.unLoadLibrary();
                    }
                }
                log.info((Object)("Synapse Library Import named '" + synImportQualfiedName + " has been deployed from file : " + fileName));
                return synImportQualfiedName;
            }
            this.handleSynapseArtifactDeploymentError("Synapse Import Deployment Failed. The artifact described in the file " + fileName + " is not a valid import");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Sequence Deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    @Override
    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Synapse Import Deployment from file : " + fileName + " : Started"));
        }
        try {
            SynapseImport synImport = SynapseImportFactory.createImport(artifactConfig, properties);
            String synImportQualfiedName = LibDeployerUtils.getQualifiedName(synImport);
            if (synImport == null) {
                this.handleSynapseArtifactDeploymentError("Synapse Import update failed. The artifact defined in the file: " + fileName + " is not a valid import.");
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Synapse Import: " + synImportQualfiedName + " has been built from the file: " + fileName));
            }
            if (existingArtifactName.equals(synImportQualfiedName)) {
                synImport.setFileName(new File(fileName).getName());
                this.getSynapseConfiguration().addSynapseImport(synImportQualfiedName, synImport);
                Library synLib = this.getSynapseConfiguration().getSynapseLibraries().get(synImportQualfiedName);
                if (synLib != null) {
                    if (synImport.isStatus()) {
                        synLib.unLoadLibrary();
                        synLib.getArtifacts().put("SynapseConfiguration", this.getSynapseConfiguration());
                        LibDeployerUtils.loadLibArtifacts(synImport, synLib);
                    } else {
                        synLib.setLibStatus(false);
                        synLib.unLoadLibrary();
                    }
                }
                log.info((Object)("Synapse Library Import named '" + synImportQualfiedName + " has been deployed from file : " + fileName));
            } else {
                SynapseImport existingImport = this.getSynapseConfiguration().getSynapseImports().get(synImportQualfiedName);
                if (existingImport != null) {
                    log.warn((Object)("Synapse Import with the name : " + synImportQualfiedName + " already exists! Could not load multiple Imports of same type."));
                    String backedUp = this.backupFile(new File(fileName));
                    log.info((Object)("Synapse Import with the name : " + synImportQualfiedName + " is now backed up in : " + backedUp));
                    return null;
                }
                synImport.setFileName(new File(fileName).getName());
                this.getSynapseConfiguration().addSynapseImport(synImportQualfiedName, synImport);
                Library synLib = this.getSynapseConfiguration().getSynapseLibraries().get(synImportQualfiedName);
                synLib.unLoadLibrary();
                if (synLib != null) {
                    synLib.getArtifacts().put("SynapseConfiguration", this.getSynapseConfiguration());
                    LibDeployerUtils.loadLibArtifacts(synImport, synLib);
                }
                log.info((Object)("Synapse Library Import named '" + synImportQualfiedName + " has been deployed from file : " + fileName));
            }
            log.info((Object)("Synapse Import: " + synImportQualfiedName + " has been updated from the file: " + fileName));
            this.waitForCompletion();
            return synImportQualfiedName;
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Error while updating the Synapse Import from the file: " + fileName);
            return null;
        }
    }

    @Override
    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Undeployment of the Synapse Import named : " + artifactName + " : Started"));
        }
        try {
            SynapseImport undeployingImport = this.getSynapseConfiguration().getSynapseImports().get(artifactName);
            if (undeployingImport != null) {
                this.getSynapseConfiguration().removeSynapseImport(artifactName);
                Library synLib = this.getSynapseConfiguration().getSynapseLibraries().get(artifactName);
                if (synLib != null) {
                    synLib.unLoadLibrary();
                    synLib.setLibStatus(false);
                }
                log.info((Object)("Synapse Import : " + artifactName + "' has been undeployed"));
            } else {
                log.warn((Object)("Synapse Import : " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Undeployement of Synapse Import named : " + artifactName + " : Failed", e);
        }
    }

    @Override
    public void restoreSynapseArtifact(String artifactName) {
    }

    private String backupFile(File file) throws DeploymentException {
        String filePath = FilenameUtils.normalize((String)file.getAbsolutePath());
        String backupFilePath = filePath + ".back";
        int backupIndex = 0;
        while (backupIndex >= 0) {
            if (new File(backupFilePath).exists()) {
                backupFilePath = filePath + "." + ++backupIndex + ".back";
                continue;
            }
            backupIndex = -1;
            try {
                FileUtils.moveFile((File)file, (File)new File(backupFilePath));
            }
            catch (IOException e) {
                this.handleSynapseArtifactDeploymentError("Error while backing up the artifact: " + file.getName(), e);
            }
        }
        return backupFilePath;
    }
}

