/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.Parameter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;

public class ClassMediatorDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(ClassMediatorDeployer.class);
    private ConfigurationContext cfgCtx = null;

    public void init(ConfigurationContext configurationContext) {
        this.cfgCtx = configurationContext;
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String mediatorPath = FilenameUtils.normalize((String)deploymentFileData.getAbsolutePath());
        log.info((Object)("Deploying Class mediators from file : " + mediatorPath));
        ClassLoader mediatorLoader = Utils.getClassLoader((ClassLoader)ClassMediatorDeployer.class.getClassLoader(), (String)mediatorPath, (boolean)false);
        this.getDeploymentStore().addClassMediatorClassLoader(mediatorPath, mediatorLoader);
    }

    public void undeploy(String fileName) throws DeploymentException {
        String mediatorPath = FilenameUtils.normalize((String)fileName);
        log.info((Object)("Undeploying Class mediator : " + mediatorPath.substring(mediatorPath.lastIndexOf(File.separator) + 1)));
        this.getDeploymentStore().removeClassMediatorClassLoader(mediatorPath);
    }

    private SynapseArtifactDeploymentStore getDeploymentStore() throws DeploymentException {
        Parameter synCfgParam = this.cfgCtx.getAxisConfiguration().getParameter("synapse.config");
        if (synCfgParam == null) {
            throw new DeploymentException("Error retrieving deployment store. SynapseConfiguration not found");
        }
        return ((SynapseConfiguration)synCfgParam.getValue()).getArtifactDeploymentStore();
    }

    public void setDirectory(String s) {
    }

    public void setExtension(String s) {
    }
}

