/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.AbstractExtendedSynapseHandler;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.ServerState;
import org.apache.synapse.SynapseHandler;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.deployers.SynapseArtifactDeploymentException;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;

public abstract class AbstractSynapseArtifactDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(AbstractSynapseArtifactDeployer.class);
    protected Log deployerLog = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected ConfigurationContext cfgCtx;
    protected String customLogContent;

    protected AbstractSynapseArtifactDeployer() {
    }

    public void init(ConfigurationContext configCtx) {
        this.cfgCtx = configCtx;
    }

    private boolean isHotDeploymentEnabled() {
        try {
            return this.getSynapseConfiguration().isAllowHotUpdate();
        }
        catch (DeploymentException e) {
            log.warn((Object)"Error while retrieving the SynapseConfiguration", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        SynapseArtifactDeploymentStore deploymentStore;
        if (this.getServerContextInformation().getServerState() != ServerState.STARTED) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipped the artifact deployment (since the Synapse server doesn't seem to be started yet), from file : " + deploymentFileData.getAbsolutePath()));
            }
            return;
        }
        if (!this.isHotDeploymentEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Hot deployment has been suspended - Ignoring");
            }
            return;
        }
        String filename = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(deploymentFileData.getAbsolutePath());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deployment of the synapse artifact from file : " + filename + " : STARTED"));
        }
        if ((deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore()).isRestoredFile(filename)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restored artifact detected with filename : " + filename));
            }
            deploymentStore.removeRestoredFile(filename);
            return;
        }
        try (FileInputStream in = FileUtils.openInputStream((File)new File(filename));){
            OMElement element = new StAXOMBuilder(StAXUtils.createXMLStreamReader((InputStream)in)).getDocumentElement();
            Properties properties = new Properties();
            properties.put("CLASS_MEDIATOR_LOADERS", deploymentStore.getClassMediatorClassLoaders());
            properties.put("resolve.root", this.getSynapseEnvironment().getServerContextInformation().getServerConfigurationInformation().getResolveRoot());
            properties.put("SynapseConfiguration", this.getSynapseConfiguration());
            String artifactName = null;
            if (deploymentStore.isUpdatingArtifact(filename)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating artifact detected with filename : " + filename));
                }
                String existingArtifactName = deploymentStore.getUpdatingArtifactWithFileName(filename);
                deploymentStore.removeUpdatingArtifact(filename);
                try {
                    artifactName = this.updateSynapseArtifact(element, filename, existingArtifactName, properties);
                }
                catch (Exception ex) {
                    log.error((Object)("Update of the Synapse Artifact from file : " + filename + " : Failed!"), (Throwable)ex);
                    log.info((Object)("The updated file has been backed up into : " + this.backupFile(deploymentFileData.getFile())));
                    log.info((Object)("Restoring the existing artifact into the file : " + filename));
                    this.restoreSynapseArtifact(existingArtifactName);
                    deploymentStore.addArtifact(filename, existingArtifactName);
                    artifactName = existingArtifactName;
                    throw new DeploymentException((Throwable)ex);
                }
            }
            try {
                if (filename.matches(".*/main-\\d+\\.\\d+\\.\\d+\\.xml")) {
                    artifactName = this.updateDefaultSequence(filename, element, properties, deploymentStore.getMainSeqLstUpdatedFile(), deploymentStore);
                    String mainSeqFileName = filename.substring(filename.lastIndexOf(File.separator) + 1);
                    deploymentStore.setMainSeqLstUpdatedFile(mainSeqFileName);
                } else if (filename.matches(".*/fault-\\d+\\.\\d+\\.\\d+\\.xml")) {
                    artifactName = this.updateDefaultSequence(filename, element, properties, deploymentStore.getFaultSeqLstUpdatedFile(), deploymentStore);
                    String faultSeqFileName = filename.substring(filename.lastIndexOf(File.separator) + 1);
                    deploymentStore.setFaultSeqLstUpdatedFile(faultSeqFileName);
                } else {
                    artifactName = this.deploySynapseArtifact(element, filename, properties);
                }
            }
            catch (NoClassDefFoundError | SynapseArtifactDeploymentException e) {
                log.error((Object)("Deployment of the Synapse Artifact from file : " + filename + " : Failed!"), e);
                log.info((Object)("The file has been backed up into : " + this.backupFile(deploymentFileData.getFile())));
                throw new DeploymentException(e);
            }
            if (artifactName != null) {
                deploymentStore.addArtifact(filename, artifactName);
            }
        }
        catch (IOException ex) {
            this.handleDeploymentError("Deployment of synapse artifact failed. Error reading " + filename + " : " + ex.getMessage(), ex, filename);
            throw new DeploymentException((Throwable)ex);
        }
        catch (XMLStreamException ex) {
            this.handleDeploymentError("Deployment of synapse artifact failed. Error parsing " + filename + " : " + ex.getMessage(), ex, filename);
            throw new DeploymentException((Throwable)ex);
        }
        catch (OMException ex) {
            this.handleDeploymentError("Deployment of synapse artifact failed. Error parsing " + filename + " : " + ex.getMessage(), (Exception)((Object)ex), filename);
            throw new DeploymentException((Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deployment of the synapse artifact from file : " + filename + " : COMPLETED"));
        }
    }

    public void undeploy(String fileName) throws DeploymentException {
        block21: {
            SynapseArtifactDeploymentStore deploymentStore;
            if (!this.isHotDeploymentEnabled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Hot deployment has been suspended - Ignoring");
                }
                return;
            }
            fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Undeployment of the synapse artifact from file : " + fileName + " : STARTED"));
            }
            if ((deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore()).isBackedUpArtifact(fileName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("BackedUp artifact detected with filename : " + fileName));
                }
                deploymentStore.removeBackedUpArtifact(fileName);
                return;
            }
            if (deploymentStore.containsFileName(fileName)) {
                File undeployingFile = new File(fileName);
                if (undeployingFile.exists()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Marking artifact as updating from file : " + fileName));
                    }
                    if (!deploymentStore.isRestoredFile(fileName)) {
                        deploymentStore.addUpdatingArtifact(fileName, deploymentStore.getArtifactNameForFile(fileName));
                        deploymentStore.removeArtifactWithFileName(fileName);
                    }
                } else {
                    String artifactName = deploymentStore.getArtifactNameForFile(fileName);
                    try {
                        if (fileName.matches(".*main-\\d+\\.\\d+\\.\\d+\\.xml")) {
                            String mainSeqFileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
                            if (mainSeqFileName.equals(deploymentStore.getMainSeqLstUpdatedFile())) {
                                this.resetDefaultSequence("main.xml", fileName, deploymentStore);
                                deploymentStore.setMainSeqLstUpdatedFile("main.xml");
                            }
                            break block21;
                        }
                        if (fileName.matches(".*fault-\\d+\\.\\d+\\.\\d+\\.xml")) {
                            String faultSeqFileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
                            if (faultSeqFileName.equals(deploymentStore.getFaultSeqLstUpdatedFile())) {
                                this.resetDefaultSequence("fault.xml", fileName, deploymentStore);
                                deploymentStore.setFaultSeqLstUpdatedFile("fault.xml");
                            }
                            break block21;
                        }
                        this.undeploySynapseArtifact(artifactName);
                        deploymentStore.removeArtifactWithFileName(fileName);
                    }
                    catch (SynapseArtifactDeploymentException sade) {
                        log.error((Object)("Unable to undeploy the artifact from file : " + fileName), (Throwable)sade);
                        log.info((Object)("Restoring the artifact into the file : " + fileName));
                        this.restoreSynapseArtifact(artifactName);
                    }
                    catch (IOException ioe) {
                        log.error((Object)("Unable to undeploy the artifact from file : " + fileName), (Throwable)ioe);
                        log.info((Object)("Restoring the artifact into the file : " + fileName));
                        this.restoreSynapseArtifact(artifactName);
                    }
                    catch (XMLStreamException xmlse) {
                        log.error((Object)("Unable to undeploy the artifact from file : " + fileName), (Throwable)xmlse);
                        log.info((Object)("Restoring the artifact into the file : " + fileName));
                        this.restoreSynapseArtifact(artifactName);
                    }
                }
            } else {
                String msg = "Artifact representing the filename " + fileName + " is not deployed on Synapse";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("UnDeployment of the synapse artifact from file : " + fileName + " : COMPLETED"));
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public abstract String deploySynapseArtifact(OMElement var1, String var2, Properties var3);

    public abstract String updateSynapseArtifact(OMElement var1, String var2, String var3, Properties var4);

    public abstract void undeploySynapseArtifact(String var1);

    public abstract void restoreSynapseArtifact(String var1);

    protected SynapseConfiguration getSynapseConfiguration() throws DeploymentException {
        Parameter synCfgParam = this.cfgCtx.getAxisConfiguration().getParameter("synapse.config");
        if (synCfgParam == null) {
            throw new DeploymentException("SynapseConfiguration not found. Are you sure that you are running Synapse?");
        }
        return (SynapseConfiguration)synCfgParam.getValue();
    }

    protected SynapseEnvironment getSynapseEnvironment() throws DeploymentException {
        Parameter synCfgParam = this.cfgCtx.getAxisConfiguration().getParameter("synapse.env");
        if (synCfgParam == null) {
            throw new DeploymentException("SynapseEnvironment not found. Are you sure that you are running Synapse?");
        }
        return (SynapseEnvironment)synCfgParam.getValue();
    }

    protected ServerConfigurationInformation getServerConfigurationInformation() throws DeploymentException {
        Parameter serverCfgParam = this.cfgCtx.getAxisConfiguration().getParameter("synapse.server.config.info");
        if (serverCfgParam == null) {
            throw new DeploymentException("SynapseConfigurationInformation not found. Are you sure that you are running Synapse?");
        }
        return (ServerConfigurationInformation)serverCfgParam.getValue();
    }

    protected ServerContextInformation getServerContextInformation() throws DeploymentException {
        Parameter serverCtxParam = this.cfgCtx.getAxisConfiguration().getParameter("synapse.server.context.info");
        if (serverCtxParam == null) {
            throw new DeploymentException("ServerContextInformation not found. Are you sure that you are running Synapse?");
        }
        return (ServerContextInformation)serverCtxParam.getValue();
    }

    protected void writeToFile(OMElement content, String fileName) throws Exception {
        SynapseArtifactDeploymentStore deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore();
        deploymentStore.addRestoredArtifact(fileName);
        FileOutputStream out = FileUtils.openOutputStream((File)new File(fileName));
        XMLPrettyPrinter.prettify((OMElement)content, (OutputStream)out);
        out.flush();
        ((OutputStream)out).close();
    }

    protected void waitForCompletion() {
        long timeout = 2000L;
        Parameter param = this.cfgCtx.getAxisConfiguration().getParameter("hotupdate.timeout");
        if (param != null && param.getValue() != null) {
            timeout = Long.parseLong(param.getValue().toString());
        }
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void handleSynapseArtifactDeploymentError(String msg) {
        this.deployerLog.error((Object)msg);
        throw new SynapseArtifactDeploymentException(msg);
    }

    protected void handleSynapseArtifactDeploymentError(String msg, Exception e) {
        this.deployerLog.error((Object)msg, (Throwable)e);
        throw new SynapseArtifactDeploymentException(msg, e);
    }

    private void handleDeploymentError(String msg, Exception e, String fileName) throws DeploymentException {
        fileName = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(fileName);
        log.error((Object)msg, (Throwable)e);
        SynapseArtifactDeploymentStore deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore();
        if (deploymentStore.isUpdatingArtifact(fileName)) {
            this.backupFile(new File(fileName));
            log.info((Object)("Restoring the existing artifact into the file : " + fileName));
            this.restoreSynapseArtifact(deploymentStore.getUpdatingArtifactWithFileName(fileName));
            deploymentStore.addArtifact(fileName, deploymentStore.getUpdatingArtifactWithFileName(fileName));
            deploymentStore.removeUpdatingArtifact(fileName);
        }
    }

    private String backupFile(File file) throws DeploymentException {
        String isWorker = System.getProperty("workerNode");
        if (isWorker != null) {
            return "NO_BACKUP_ON_WORKER.INFO";
        }
        String filePath = SynapseArtifactDeploymentStore.getNormalizedAbsolutePath(file.getAbsolutePath());
        SynapseArtifactDeploymentStore deploymentStore = this.getSynapseConfiguration().getArtifactDeploymentStore();
        deploymentStore.addBackedUpArtifact(filePath);
        String backupFilePath = filePath + ".back";
        int backupIndex = 0;
        while (backupIndex >= 0) {
            if (new File(backupFilePath).exists()) {
                backupFilePath = filePath + "." + ++backupIndex + ".back";
                continue;
            }
            backupIndex = -1;
            try {
                FileUtils.moveFile((File)file, (File)new File(backupFilePath));
            }
            catch (IOException e) {
                log.warn((Object)"Error while backing up the artifact: ", (Throwable)e);
                return "ERROR_WHILE_BACKING_UP_ARTIFACT";
            }
        }
        return backupFilePath;
    }

    private void resetDefaultSequence(String sequenceFileName, String fileName, SynapseArtifactDeploymentStore deploymentStore) throws IOException, XMLStreamException {
        String dirpath = fileName.substring(0, fileName.lastIndexOf(File.separator));
        String seqOrgi = dirpath + File.separator + sequenceFileName;
        FileInputStream in = FileUtils.openInputStream((File)new File(seqOrgi));
        OMElement element = new StAXOMBuilder(StAXUtils.createXMLStreamReader((InputStream)in)).getDocumentElement();
        Properties properties = new Properties();
        properties.put("resolve.root", this.getSynapseEnvironment().getServerContextInformation().getServerConfigurationInformation().getResolveRoot());
        String existingArtifactName = deploymentStore.getArtifactNameForFile(fileName);
        deploymentStore.removeArtifactWithFileName(fileName);
        String artifactName = this.updateSynapseArtifact(element, seqOrgi, existingArtifactName, properties);
        if (artifactName != null) {
            deploymentStore.addArtifact(seqOrgi, artifactName);
        }
    }

    private String updateDefaultSequence(String filename, OMElement element, Properties properties, String lstupdFile, SynapseArtifactDeploymentStore deploymentStore) {
        String derpath = filename.substring(0, filename.lastIndexOf(File.separator));
        String seqFile = derpath + File.separator + lstupdFile;
        String existingArtifactName = deploymentStore.getArtifactNameForFile(seqFile);
        deploymentStore.removeArtifactWithFileName(seqFile);
        String artifactName = this.updateSynapseArtifact(element, filename, existingArtifactName, properties);
        return artifactName;
    }

    public void setCustomLog(String artifactContainerName, String tenantId) {
        if (artifactContainerName == null) {
            this.customLogContent = null;
            return;
        }
        this.customLogContent = "[ Deployed From Artifact Container: " + artifactContainerName + " ] ";
    }

    protected void executeExtendedSynapseHandlerOnArtifactDeployment(String artifactName, String artifactType, String startTime) throws DeploymentException {
        List<SynapseHandler> handlers = this.getSynapseEnvironment().getSynapseHandlers();
        for (SynapseHandler handler : handlers) {
            AbstractExtendedSynapseHandler abstractExtendedSynapseHandler;
            if (!(handler instanceof AbstractExtendedSynapseHandler) || (abstractExtendedSynapseHandler = (AbstractExtendedSynapseHandler)handler).handleArtifactDeployment(artifactName, artifactType, startTime)) continue;
            log.warn((Object)"Synapse not executed in the artifact deployment in path");
        }
    }

    protected void executeSynapseHandlerOnArtifactUnDeployment(String artifactName, String artifactType, String unDeployTime) throws DeploymentException {
        List<SynapseHandler> handlers = this.getSynapseEnvironment().getSynapseHandlers();
        for (SynapseHandler handler : handlers) {
            AbstractExtendedSynapseHandler abstractExtendedSynapseHandler;
            if (!(handler instanceof AbstractExtendedSynapseHandler) || (abstractExtendedSynapseHandler = (AbstractExtendedSynapseHandler)handler).handleArtifactUnDeployment(artifactName, artifactType, unDeployTime)) continue;
            log.warn((Object)"Synapse not executed in the artifact undeployment in path");
        }
    }
}

