/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.debug.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.debug.SynapseDebugManager;
import org.apache.synapse.debug.constructs.SynapseMediationComponent;
import org.apache.synapse.debug.constructs.SynapseMediationFlowPoint;
import org.apache.synapse.debug.utils.MediatorTreeTraverseUtil;
import org.apache.synapse.debug.utils.SequenceDebugUtil;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.template.TemplateMediator;

public class TemplateDebugUtil {
    private static SynapseDebugManager debugManager = SynapseDebugManager.getInstance();
    private static final Log log = LogFactory.getLog(SequenceDebugUtil.class);

    public static void registerTemplateMediationFlowBreakPoint(SynapseConfiguration synCfg, String templateKey, int[] position, boolean registerMode) {
        SynapseMediationFlowPoint breakPoint = new SynapseMediationFlowPoint();
        breakPoint.setSynapseMediationComponent(SynapseMediationComponent.TEMPLATE);
        breakPoint.setKey(templateKey);
        breakPoint.setMediatorPosition(position);
        TemplateMediator templateMediator = null;
        templateMediator = synCfg.getSequenceTemplate(templateKey);
        if (templateMediator != null) {
            Mediator current_mediator = null;
            current_mediator = MediatorTreeTraverseUtil.getMediatorReference(synCfg, templateMediator, position);
            if (current_mediator != null) {
                breakPoint.setMediatorReference(current_mediator);
                if (registerMode) {
                    if (!((AbstractMediator)current_mediator).isBreakPoint()) {
                        ((AbstractMediator)current_mediator).setBreakPoint(true);
                        ((AbstractMediator)current_mediator).registerMediationFlowPoint(breakPoint);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Registered breakpoint at mediator position " + TemplateDebugUtil.logMediatorPosition(breakPoint) + " for Template key " + breakPoint.getKey()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Failed register breakpoint. Already breakpoint enabled at mediator position " + TemplateDebugUtil.logMediatorPosition(breakPoint) + " for Template key " + breakPoint.getKey()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already breakpoint enabled at mediator position").toString());
                    }
                } else if (((AbstractMediator)current_mediator).isBreakPoint()) {
                    ((AbstractMediator)current_mediator).unregisterMediationFlowPoint();
                    ((AbstractMediator)current_mediator).setBreakPoint(false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unregistered breakpoint at mediator position " + TemplateDebugUtil.logMediatorPosition(breakPoint) + " for Template key " + breakPoint.getKey()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed unregister breakpoint. Already breakpoint disabled at mediator position " + TemplateDebugUtil.logMediatorPosition(breakPoint) + " for Template key " + breakPoint.getKey()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already breakpoint disabled at mediator position").toString());
                }
            } else if (registerMode) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed register breakpoint. Non existing mediator position at " + TemplateDebugUtil.logMediatorPosition(breakPoint) + " for Template key " + breakPoint.getKey()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed unregister breakpoint. Non existing mediator position at " + TemplateDebugUtil.logMediatorPosition(breakPoint) + " for Template key " + breakPoint.getKey()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            }
        } else if (registerMode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed register breakpoint. Non existing template for key " + breakPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing template").toString());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed unregister breakpoint. Non existing template for key " + breakPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing template").toString());
        }
    }

    public static void registerTemplateMediationFlowSkip(SynapseConfiguration synCfg, String templateKey, int[] position, boolean registerMode) {
        SynapseMediationFlowPoint skipPoint = new SynapseMediationFlowPoint();
        skipPoint.setSynapseMediationComponent(SynapseMediationComponent.TEMPLATE);
        skipPoint.setKey(templateKey);
        skipPoint.setMediatorPosition(position);
        TemplateMediator templateMediator = null;
        templateMediator = synCfg.getSequenceTemplate(templateKey);
        if (templateMediator != null) {
            Mediator current_mediator = null;
            current_mediator = MediatorTreeTraverseUtil.getMediatorReference(synCfg, templateMediator, position);
            if (current_mediator != null) {
                skipPoint.setMediatorReference(current_mediator);
                if (registerMode) {
                    if (!((AbstractMediator)current_mediator).isSkipEnabled()) {
                        ((AbstractMediator)current_mediator).setSkipEnabled(true);
                        ((AbstractMediator)current_mediator).registerMediationFlowPoint(skipPoint);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Registered skip at mediator position " + TemplateDebugUtil.logMediatorPosition(skipPoint) + " for Template key " + skipPoint.getKey()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Failed register skip. Already skip enabled at mediator position " + TemplateDebugUtil.logMediatorPosition(skipPoint) + " for Template key " + skipPoint.getKey()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already skip enabled at mediator position").toString());
                    }
                } else if (((AbstractMediator)current_mediator).isSkipEnabled()) {
                    ((AbstractMediator)current_mediator).unregisterMediationFlowPoint();
                    ((AbstractMediator)current_mediator).setSkipEnabled(false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unregistered skip at mediator position " + TemplateDebugUtil.logMediatorPosition(skipPoint) + " for Template key " + skipPoint.getKey()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed unregister skip. Already skip disabled at mediator position " + TemplateDebugUtil.logMediatorPosition(skipPoint) + " for Template key " + skipPoint.getKey()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already skip disabled at mediator position").toString());
                }
            } else if (registerMode) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed register skip. Non existing mediator position at " + TemplateDebugUtil.logMediatorPosition(skipPoint) + " for Template key " + skipPoint.getKey()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed unregister skip. Non existing mediator position at " + TemplateDebugUtil.logMediatorPosition(skipPoint) + " for Template key " + skipPoint.getKey()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            }
        } else if (registerMode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed register skip. Non existing template for key " + skipPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing template").toString());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed unregister skip. Non existing template for key " + skipPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing template").toString());
        }
    }

    protected static String logMediatorPosition(SynapseMediationFlowPoint flowPoint) {
        String position = "";
        for (int count = 0; count < flowPoint.getMediatorPosition().length; ++count) {
            if (count != 0) {
                position = position.concat("-->");
            }
            position = position.concat("(" + String.valueOf(flowPoint.getMediatorPosition()[count]) + ")");
        }
        return position;
    }
}

