/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.debug.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SwitchCase;
import org.apache.synapse.debug.constructs.EnclosedInlinedSequence;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.builtin.CommentMediator;
import org.apache.synapse.mediators.builtin.ForEachMediator;
import org.apache.synapse.mediators.eip.aggregator.AggregateMediator;
import org.apache.synapse.mediators.eip.splitter.CloneMediator;
import org.apache.synapse.mediators.eip.splitter.IterateMediator;
import org.apache.synapse.mediators.filters.FilterMediator;
import org.apache.synapse.mediators.filters.SwitchMediator;
import org.apache.synapse.mediators.template.InvokeMediator;

public class MediatorTreeTraverseUtil {
    private static final Log log = LogFactory.getLog(MediatorTreeTraverseUtil.class);

    public static Mediator getMediatorReference(SynapseConfiguration synCfg, Mediator seqMediator, int[] position) {
        Mediator current_mediator = null;
        for (int counter = 0; counter < position.length; ++counter) {
            int correctedPosition;
            int mediatorCount;
            if (counter == 0) {
                mediatorCount = ((AbstractListMediator)seqMediator).getList().size();
                if (mediatorCount > (correctedPosition = MediatorTreeTraverseUtil.getCorrectedPossition((AbstractListMediator)seqMediator, position[counter]))) {
                    current_mediator = ((AbstractListMediator)seqMediator).getChild(correctedPosition);
                } else {
                    log.warn((Object)("Mediator position requested is larger than last index : " + position[counter]));
                }
            }
            if (current_mediator == null || counter == 0) continue;
            if (current_mediator instanceof InvokeMediator) {
                current_mediator = synCfg.getSequenceTemplate(((InvokeMediator)current_mediator).getTargetTemplate());
            } else if (current_mediator instanceof FilterMediator) {
                if (position[counter] == 0) {
                    if (((FilterMediator)current_mediator).getElseMediator() != null) {
                        current_mediator = ((FilterMediator)current_mediator).getElseMediator();
                        continue;
                    }
                    if (((FilterMediator)current_mediator).getElseKey() == null) continue;
                    current_mediator = synCfg.getSequence(((FilterMediator)current_mediator).getElseKey());
                    continue;
                }
                if (position[counter] == 1) {
                    if (((FilterMediator)current_mediator).getThenKey() != null) {
                        current_mediator = synCfg.getSequence(((FilterMediator)current_mediator).getThenKey());
                        continue;
                    }
                    if (++counter >= position.length) continue;
                    mediatorCount = ((AbstractListMediator)current_mediator).getList().size();
                    if (mediatorCount > (correctedPosition = MediatorTreeTraverseUtil.getCorrectedPossition((AbstractListMediator)current_mediator, position[counter]))) {
                        current_mediator = ((AbstractListMediator)current_mediator).getChild(correctedPosition);
                        continue;
                    }
                    log.warn((Object)("Mediator position requested is larger than last index : " + position[counter]));
                    continue;
                }
            } else {
                if (current_mediator instanceof SwitchMediator) {
                    if (position[counter] == 0) {
                        SwitchCase switchCase = ((SwitchMediator)current_mediator).getDefaultCase();
                        if (switchCase != null) {
                            current_mediator = switchCase.getCaseMediator();
                            continue;
                        }
                        current_mediator = null;
                        continue;
                    }
                    SwitchCase switchCase = ((SwitchMediator)current_mediator).getCases().get(position[counter] - 1);
                    if (switchCase != null) {
                        current_mediator = switchCase.getCaseMediator();
                        continue;
                    }
                    current_mediator = null;
                    continue;
                }
                if (current_mediator instanceof AggregateMediator) {
                    if (((AggregateMediator)current_mediator).getOnCompleteSequence() != null) {
                        current_mediator = ((AggregateMediator)current_mediator).getOnCompleteSequence();
                    } else if (((AggregateMediator)current_mediator).getOnCompleteSequenceRef() != null) {
                        current_mediator = synCfg.getSequence(((AggregateMediator)current_mediator).getOnCompleteSequenceRef());
                    }
                } else if (current_mediator instanceof ForEachMediator) {
                    if (((ForEachMediator)current_mediator).getSequence() != null) {
                        current_mediator = ((ForEachMediator)current_mediator).getSequence();
                    } else if (((ForEachMediator)current_mediator).getSequenceRef() != null) {
                        current_mediator = synCfg.getSequence(((ForEachMediator)current_mediator).getSequenceRef());
                    }
                } else if (current_mediator instanceof IterateMediator) {
                    if (((IterateMediator)current_mediator).getTarget().getSequence() != null) {
                        current_mediator = ((IterateMediator)current_mediator).getTarget().getSequence();
                    } else if (((IterateMediator)current_mediator).getTarget().getSequenceRef() != null) {
                        current_mediator = synCfg.getSequence(((IterateMediator)current_mediator).getTarget().getSequenceRef());
                    }
                } else {
                    if (current_mediator instanceof CloneMediator) {
                        if (((CloneMediator)current_mediator).getTargets().get(position[counter]).getSequence() != null) {
                            current_mediator = ((CloneMediator)current_mediator).getTargets().get(position[counter]).getSequence();
                            continue;
                        }
                        if (((CloneMediator)current_mediator).getTargets().get(position[counter]).getSequenceRef() == null) continue;
                        current_mediator = synCfg.getSequence(((CloneMediator)current_mediator).getTargets().get(position[counter]).getSequenceRef());
                        continue;
                    }
                    if (current_mediator.getType().equals("ThrottleMediator")) {
                        current_mediator = ((EnclosedInlinedSequence)((Object)current_mediator)).getInlineSequence(synCfg, position[counter]);
                        continue;
                    }
                    if (current_mediator.getType().equals("EntitlementMediator")) {
                        current_mediator = ((EnclosedInlinedSequence)((Object)current_mediator)).getInlineSequence(synCfg, position[counter]);
                        continue;
                    }
                    if (current_mediator.getType().equals("CacheMediator")) {
                        current_mediator = ((EnclosedInlinedSequence)((Object)current_mediator)).getInlineSequence(synCfg, 0);
                    }
                }
            }
            if (current_mediator != null && current_mediator instanceof AbstractListMediator) {
                mediatorCount = ((AbstractListMediator)current_mediator).getList().size();
                if (mediatorCount > (correctedPosition = MediatorTreeTraverseUtil.getCorrectedPossition((AbstractListMediator)current_mediator, position[counter]))) {
                    current_mediator = ((AbstractListMediator)current_mediator).getChild(correctedPosition);
                    continue;
                }
                log.warn((Object)("Mediator position requested is larger than last index : " + position[counter]));
                continue;
            }
            current_mediator = null;
            break;
        }
        return current_mediator;
    }

    private static int getCorrectedPossition(AbstractListMediator seqMediator, int position) {
        int positionWithComments = 0;
        int positionWithoutComments = 0;
        for (Mediator mediator : seqMediator.getList()) {
            if (!(mediator instanceof CommentMediator)) {
                if (positionWithoutComments == position) {
                    return positionWithComments;
                }
                ++positionWithoutComments;
            }
            ++positionWithComments;
        }
        return position;
    }
}

