/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.debug.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.debug.SynapseDebugManager;
import org.apache.synapse.debug.constructs.SequenceMediationFlowPoint;
import org.apache.synapse.debug.constructs.SynapseMediationComponent;
import org.apache.synapse.debug.constructs.SynapseMediationFlowPoint;
import org.apache.synapse.debug.constructs.SynapseSequenceType;
import org.apache.synapse.debug.utils.MediatorTreeTraverseUtil;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.mediators.AbstractMediator;

public class InboundEndpointDebugUtil {
    private static SynapseDebugManager debugManager = SynapseDebugManager.getInstance();
    private static final Log log = LogFactory.getLog(InboundEndpointDebugUtil.class);

    public static void registerInboundSequenceMediationFlowBreakPoint(SynapseConfiguration synCfg, String sequenceType, String inboundKey, int[] position, boolean registerMode) {
        SynapseSequenceType synapseSequenceType = SynapseSequenceType.valueOf(sequenceType.toUpperCase());
        SequenceMediationFlowPoint breakPoint = new SequenceMediationFlowPoint();
        breakPoint.setSynapseMediationComponent(SynapseMediationComponent.SEQUENCE);
        breakPoint.setKey(inboundKey);
        breakPoint.setMediatorPosition(position);
        breakPoint.setSequenceBaseType("inbound");
        breakPoint.setSynapseSequenceType(synapseSequenceType);
        Mediator seqMediator = null;
        InboundEndpoint inbound = null;
        inbound = synCfg.getInboundEndpoint(inboundKey);
        if (inbound != null) {
            if (synapseSequenceType.equals((Object)SynapseSequenceType.INBOUND_SEQ)) {
                seqMediator = synCfg.getSequence(inbound.getInjectingSeq());
            } else if (synapseSequenceType.equals((Object)SynapseSequenceType.INBOUND_FAULTSEQ)) {
                seqMediator = synCfg.getSequence(inbound.getOnErrorSeq());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Non existing Inbound Endpoint for key " + breakPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "inbound not found").toString());
            return;
        }
        if (seqMediator != null) {
            Mediator current_mediator = null;
            current_mediator = MediatorTreeTraverseUtil.getMediatorReference(synCfg, seqMediator, position);
            if (current_mediator != null) {
                breakPoint.setMediatorReference(current_mediator);
                if (registerMode) {
                    if (!((AbstractMediator)current_mediator).isBreakPoint()) {
                        ((AbstractMediator)current_mediator).setBreakPoint(true);
                        ((AbstractMediator)current_mediator).registerMediationFlowPoint(breakPoint);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Registered breakpoint at mediator position " + InboundEndpointDebugUtil.logMediatorPosition(breakPoint) + " for Inbound Endpoint key " + breakPoint.getKey() + " sequence " + breakPoint.getSynapseSequenceType().toString()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Failed register breakpoint. Already breakpoint enabled at mediator position " + InboundEndpointDebugUtil.logMediatorPosition(breakPoint) + " for Inbound Endpoint key " + breakPoint.getKey() + " sequence " + breakPoint.getSynapseSequenceType().toString()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already breakpoint enabled at mediator position").toString());
                    }
                } else if (((AbstractMediator)current_mediator).isBreakPoint()) {
                    ((AbstractMediator)current_mediator).unregisterMediationFlowPoint();
                    ((AbstractMediator)current_mediator).setBreakPoint(false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unregistered breakpoint at mediator position " + InboundEndpointDebugUtil.logMediatorPosition(breakPoint) + " for Inbound Endpoint key " + breakPoint.getKey() + " sequence " + breakPoint.getSynapseSequenceType().toString()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed unregister breakpoint. Already breakpoint disabled at mediator position " + InboundEndpointDebugUtil.logMediatorPosition(breakPoint) + " for Inbound Endpoint key " + breakPoint.getKey() + " sequence " + breakPoint.getSynapseSequenceType().toString()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already breakpoint disabled at mediator position").toString());
                }
            } else if (registerMode) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed register breakpoint. Non existing mediator position at " + InboundEndpointDebugUtil.logMediatorPosition(breakPoint) + " for Inbound Endpoint key " + breakPoint.getKey() + " sequence " + breakPoint.getSynapseSequenceType().toString()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed unregister breakpoint. Non existing mediator position at " + InboundEndpointDebugUtil.logMediatorPosition(breakPoint) + " for Inbound Endpoint key " + breakPoint.getKey() + " sequence " + breakPoint.getSynapseSequenceType().toString()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            }
        } else if (registerMode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed register breakpoint. Non existing sequence " + breakPoint.getSynapseSequenceType().toString() + " for Inbound Endpoint key " + breakPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing sequence").toString());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed unregister breakpoint. Non existing sequence " + breakPoint.getSynapseSequenceType().toString() + " for Inbound Endpoint key " + breakPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing sequence").toString());
        }
    }

    public static void registerInboundSequenceMediationFlowSkip(SynapseConfiguration synCfg, String seqType, String inboundKey, int[] position, boolean registerMode) {
        SynapseSequenceType synapseSequenceType = SynapseSequenceType.valueOf(seqType.toUpperCase());
        SequenceMediationFlowPoint skipPoint = new SequenceMediationFlowPoint();
        skipPoint.setSynapseMediationComponent(SynapseMediationComponent.SEQUENCE);
        skipPoint.setKey(inboundKey);
        skipPoint.setMediatorPosition(position);
        skipPoint.setSequenceBaseType("inbound");
        skipPoint.setSynapseSequenceType(synapseSequenceType);
        Mediator seqMediator = null;
        InboundEndpoint inbound = null;
        inbound = synCfg.getInboundEndpoint(inboundKey);
        if (inbound != null) {
            if (synapseSequenceType.equals((Object)SynapseSequenceType.INBOUND_SEQ)) {
                seqMediator = synCfg.getSequence(inbound.getInjectingSeq());
            } else if (synapseSequenceType.equals((Object)SynapseSequenceType.INBOUND_FAULTSEQ)) {
                seqMediator = synCfg.getSequence(inbound.getOnErrorSeq());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Non existing Inbound Endpoint for key " + skipPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "inbound not found").toString());
            return;
        }
        if (seqMediator != null) {
            Mediator current_mediator = null;
            current_mediator = MediatorTreeTraverseUtil.getMediatorReference(synCfg, seqMediator, position);
            if (current_mediator != null) {
                skipPoint.setMediatorReference(current_mediator);
                if (registerMode) {
                    if (!((AbstractMediator)current_mediator).isSkipEnabled()) {
                        ((AbstractMediator)current_mediator).setSkipEnabled(true);
                        ((AbstractMediator)current_mediator).registerMediationFlowPoint(skipPoint);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Registered skip at mediator position " + InboundEndpointDebugUtil.logMediatorPosition(skipPoint) + " for Inbound Endpoint key " + skipPoint.getKey() + " sequence " + skipPoint.getSynapseSequenceType().toString()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Failed register skip. Already skip enabled at mediator position " + InboundEndpointDebugUtil.logMediatorPosition(skipPoint) + " for Inbound Endpoint key " + skipPoint.getKey() + " sequence " + skipPoint.getSynapseSequenceType().toString()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already skip enabled at mediator position").toString());
                    }
                } else if (((AbstractMediator)current_mediator).isSkipEnabled()) {
                    ((AbstractMediator)current_mediator).unregisterMediationFlowPoint();
                    ((AbstractMediator)current_mediator).setSkipEnabled(false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unregistered skip at mediator position " + InboundEndpointDebugUtil.logMediatorPosition(skipPoint) + " for Inbound Endpoint key " + skipPoint.getKey() + " sequence " + skipPoint.getSynapseSequenceType().toString()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed unregister skip. Already skip disabled at mediator position " + InboundEndpointDebugUtil.logMediatorPosition(skipPoint) + " for Inbound Endpoint key " + skipPoint.getKey() + " sequence " + skipPoint.getSynapseSequenceType().toString()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already skip disabled at mediator position").toString());
                }
            } else if (registerMode) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed register skip. Non existing mediator position at " + InboundEndpointDebugUtil.logMediatorPosition(skipPoint) + " for Inbound Endpoint key " + skipPoint.getKey() + " sequence " + skipPoint.getSynapseSequenceType().toString()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed unregister skip. Non existing mediator position at " + InboundEndpointDebugUtil.logMediatorPosition(skipPoint) + " for Inbound Endpoint key " + skipPoint.getKey() + " sequence " + skipPoint.getSynapseSequenceType().toString()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            }
        } else if (registerMode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed register skip. Non existing sequence " + skipPoint.getSynapseSequenceType().toString() + " for Inbound Endpoint key " + skipPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing sequence").toString());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed unregister skip. Non existing sequence " + skipPoint.getSynapseSequenceType().toString() + " for Inbound Endpoint key " + skipPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing sequence").toString());
        }
    }

    protected static String logMediatorPosition(SynapseMediationFlowPoint flowPoint) {
        String position = "";
        for (int count = 0; count < flowPoint.getMediatorPosition().length; ++count) {
            if (count != 0) {
                position = position.concat("-->");
            }
            position = position.concat("(" + String.valueOf(flowPoint.getMediatorPosition()[count]) + ")");
        }
        return position;
    }
}

