/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.debug.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.debug.SynapseDebugManager;
import org.apache.synapse.debug.constructs.ConnectorMediationFlowPoint;
import org.apache.synapse.debug.constructs.SynapseMediationComponent;
import org.apache.synapse.debug.constructs.SynapseMediationFlowPoint;
import org.apache.synapse.debug.utils.MediatorTreeTraverseUtil;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.template.TemplateMediator;

public class ConnectorDebugUtil {
    private static SynapseDebugManager debugManager = SynapseDebugManager.getInstance();
    private static final Log log = LogFactory.getLog(ConnectorDebugUtil.class);

    public static void registerConnectorMediationFlowBreakPoint(SynapseConfiguration synCfg, String connectorKey, String connectorMethod, int[] position, boolean registerMode) {
        ConnectorMediationFlowPoint breakPoint = new ConnectorMediationFlowPoint();
        breakPoint.setSynapseMediationComponent(SynapseMediationComponent.CONNECTOR);
        breakPoint.setKey(connectorKey);
        breakPoint.setConnectorMediationComponentMethod(connectorMethod);
        breakPoint.setMediatorPosition(position);
        TemplateMediator templateMediator = null;
        String template_key = "org.wso2.carbon.connector." + connectorKey + "." + connectorMethod;
        templateMediator = synCfg.getSequenceTemplate(template_key);
        if (templateMediator != null) {
            Mediator current_mediator = null;
            current_mediator = MediatorTreeTraverseUtil.getMediatorReference(synCfg, templateMediator, position);
            if (current_mediator != null) {
                breakPoint.setMediatorReference(current_mediator);
                if (registerMode) {
                    if (!((AbstractMediator)current_mediator).isBreakPoint()) {
                        ((AbstractMediator)current_mediator).setBreakPoint(true);
                        ((AbstractMediator)current_mediator).registerMediationFlowPoint(breakPoint);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Registered breakpoint at mediator position " + ConnectorDebugUtil.logMediatorPosition(breakPoint) + " for Connector key " + breakPoint.getKey() + " method " + breakPoint.getConnectorMediationComponentMethod()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Failed register breakpoint. Already breakpoint enabled at mediator position " + ConnectorDebugUtil.logMediatorPosition(breakPoint) + " for Connector key " + breakPoint.getKey() + " method " + breakPoint.getConnectorMediationComponentMethod()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already breakpoint enabled at mediator position").toString());
                    }
                } else if (((AbstractMediator)current_mediator).isBreakPoint()) {
                    ((AbstractMediator)current_mediator).unregisterMediationFlowPoint();
                    ((AbstractMediator)current_mediator).setBreakPoint(false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unregistered breakpoint at mediator position " + ConnectorDebugUtil.logMediatorPosition(breakPoint) + " for Connector key " + breakPoint.getKey() + " method " + breakPoint.getConnectorMediationComponentMethod()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed unregister breakpoint. Already breakpoint disabled at mediator position " + ConnectorDebugUtil.logMediatorPosition(breakPoint) + " for Connector key " + breakPoint.getKey() + " method " + breakPoint.getConnectorMediationComponentMethod()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already breakpoint disabled at mediator position").toString());
                }
            } else if (registerMode) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed register breakpoint. Non existing mediator position at " + ConnectorDebugUtil.logMediatorPosition(breakPoint) + " for Connector key " + breakPoint.getKey() + " method " + breakPoint.getConnectorMediationComponentMethod()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed unregister breakpoint. Non existing mediator position at " + ConnectorDebugUtil.logMediatorPosition(breakPoint) + " for Connector key " + breakPoint.getKey() + " method " + breakPoint.getConnectorMediationComponentMethod()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            }
        } else if (registerMode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed register breakpoint. Non existing template for Connector key " + breakPoint.getKey() + " method " + breakPoint.getConnectorMediationComponentMethod()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing template").toString());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed unregister breakpoint. Non existing template for Connector key " + breakPoint.getKey() + " method " + breakPoint.getConnectorMediationComponentMethod()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing template").toString());
        }
    }

    public static void registerConnectorMediationFlowSkip(SynapseConfiguration synCfg, String connectorKey, String connectorMethod, int[] position, boolean registerMode) {
        ConnectorMediationFlowPoint skipPoint = new ConnectorMediationFlowPoint();
        skipPoint.setSynapseMediationComponent(SynapseMediationComponent.CONNECTOR);
        skipPoint.setKey(connectorKey);
        skipPoint.setConnectorMediationComponentMethod(connectorMethod);
        skipPoint.setMediatorPosition(position);
        TemplateMediator templateMediator = null;
        String template_key = "org.wso2.carbon.connector." + connectorKey + "." + connectorMethod;
        templateMediator = synCfg.getSequenceTemplate(template_key);
        if (templateMediator != null) {
            Mediator current_mediator = null;
            current_mediator = MediatorTreeTraverseUtil.getMediatorReference(synCfg, templateMediator, position);
            if (current_mediator != null) {
                skipPoint.setMediatorReference(current_mediator);
                if (registerMode) {
                    if (!((AbstractMediator)current_mediator).isSkipEnabled()) {
                        ((AbstractMediator)current_mediator).setSkipEnabled(true);
                        ((AbstractMediator)current_mediator).registerMediationFlowPoint(skipPoint);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Registered skip at mediator position " + ConnectorDebugUtil.logMediatorPosition(skipPoint) + " for Connector key " + skipPoint.getKey() + " method " + skipPoint.getConnectorMediationComponentMethod()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Failed register skip. Already skip enabled at mediator position " + ConnectorDebugUtil.logMediatorPosition(skipPoint) + " for Connector key " + skipPoint.getKey() + " method " + skipPoint.getConnectorMediationComponentMethod()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already skip enabled at mediator position").toString());
                    }
                } else if (((AbstractMediator)current_mediator).isSkipEnabled()) {
                    ((AbstractMediator)current_mediator).unregisterMediationFlowPoint();
                    ((AbstractMediator)current_mediator).setSkipEnabled(false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unregistered skip at mediator position " + ConnectorDebugUtil.logMediatorPosition(skipPoint) + " for Connector key " + skipPoint.getKey() + " method " + skipPoint.getConnectorMediationComponentMethod()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed unregister skip. Already skip disabled at mediator position " + ConnectorDebugUtil.logMediatorPosition(skipPoint) + " for Connector key " + skipPoint.getKey() + " method " + skipPoint.getConnectorMediationComponentMethod()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already skip disabled at mediator position").toString());
                }
            } else if (registerMode) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed register skip. Non existing mediator position " + ConnectorDebugUtil.logMediatorPosition(skipPoint) + " for Connector key " + skipPoint.getKey() + " method " + skipPoint.getConnectorMediationComponentMethod()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed unregister skip. Non existing mediator position at " + ConnectorDebugUtil.logMediatorPosition(skipPoint) + " for Connector key " + skipPoint.getKey() + " method " + skipPoint.getConnectorMediationComponentMethod()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            }
        } else if (registerMode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed register skip. Non existing template for Connector key " + skipPoint.getKey() + " method " + skipPoint.getConnectorMediationComponentMethod()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing template").toString());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed unregister skip. Non existing template for Connector key " + skipPoint.getKey() + " method " + skipPoint.getConnectorMediationComponentMethod()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing template").toString());
        }
    }

    protected static String logMediatorPosition(SynapseMediationFlowPoint flowPoint) {
        String position = "";
        for (int count = 0; count < flowPoint.getMediatorPosition().length; ++count) {
            if (count != 0) {
                position = position.concat("-->");
            }
            position = position.concat("(" + String.valueOf(flowPoint.getMediatorPosition()[count]) + ")");
        }
        return position;
    }
}

