/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.debug.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.api.API;
import org.apache.synapse.api.Resource;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.debug.SynapseDebugManager;
import org.apache.synapse.debug.constructs.APIMediationFlowPoint;
import org.apache.synapse.debug.constructs.SynapseMediationComponent;
import org.apache.synapse.debug.constructs.SynapseMediationFlowPoint;
import org.apache.synapse.debug.constructs.SynapseSequenceType;
import org.apache.synapse.debug.utils.MediatorTreeTraverseUtil;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;

public class APIDebugUtil {
    private static SynapseDebugManager debugManager = SynapseDebugManager.getInstance();
    private static final Log log = LogFactory.getLog(APIDebugUtil.class);

    public static void registerAPISequenceMediationFlowBreakPoint(SynapseConfiguration synCfg, String mapping, String method, String sequenceType, String apiKey, int[] position, boolean registerMode) {
        SynapseSequenceType synapseSequenceType = SynapseSequenceType.valueOf(sequenceType.toUpperCase());
        APIMediationFlowPoint breakPoint = new APIMediationFlowPoint();
        breakPoint.setSynapseMediationComponent(SynapseMediationComponent.SEQUENCE);
        breakPoint.setKey(apiKey);
        breakPoint.setMediatorPosition(position);
        breakPoint.setSynapseSequenceType(synapseSequenceType);
        breakPoint.setSequenceBaseType("api");
        breakPoint.setResourceMapping(mapping);
        breakPoint.setResourceHTTPMethod(method);
        SequenceMediator seqMediator = null;
        Resource api_resource = null;
        API api = synCfg.getAPI(apiKey);
        if (api == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Non existing API for the key " + breakPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "api not found").toString());
            return;
        }
        Resource[] resource_array = api.getResources();
        for (int counter = 0; counter < resource_array.length; ++counter) {
            if (resource_array[counter].getDispatcherHelper() != null && mapping != null) {
                if (!mapping.equals(resource_array[counter].getDispatcherHelper().getString())) continue;
                for (String m1 : resource_array[counter].getMethods()) {
                    if (!m1.equals(method)) continue;
                    api_resource = resource_array[counter];
                    break;
                }
                if (api_resource == null) continue;
                break;
            }
            if (resource_array[counter].getDispatcherHelper() != null || mapping != null) continue;
            for (String m1 : resource_array[counter].getMethods()) {
                if (!m1.equals(method)) continue;
                api_resource = resource_array[counter];
                break;
            }
            if (api_resource != null) break;
        }
        if (api_resource != null) {
            if (synapseSequenceType.equals((Object)SynapseSequenceType.API_INSEQ)) {
                seqMediator = api_resource.getInSequence();
            } else if (synapseSequenceType.equals((Object)SynapseSequenceType.API_OUTSEQ)) {
                seqMediator = api_resource.getOutSequence();
            } else if (synapseSequenceType.equals((Object)SynapseSequenceType.API_FAULTSEQ)) {
                seqMediator = api_resource.getFaultSequence();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource not found for the API key " + breakPoint.getKey() + " resource mapping " + breakPoint.getResourceMapping() + " resource HTTP method " + breakPoint.getResourceHTTPMethod()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "api resource not found").toString());
            return;
        }
        if (seqMediator != null) {
            Mediator current_mediator = null;
            current_mediator = MediatorTreeTraverseUtil.getMediatorReference(synCfg, seqMediator, position);
            if (current_mediator != null) {
                breakPoint.setMediatorReference(current_mediator);
                if (registerMode) {
                    if (!((AbstractMediator)current_mediator).isBreakPoint()) {
                        ((AbstractMediator)current_mediator).setBreakPoint(true);
                        ((AbstractMediator)current_mediator).registerMediationFlowPoint(breakPoint);
                        if (log.isDebugEnabled()) {
                            log.info((Object)("Registered breakpoint at mediator position " + APIDebugUtil.logMediatorPosition(breakPoint) + " for API key " + breakPoint.getKey() + " resource mapping " + breakPoint.getResourceMapping() + " resource HTTP method " + breakPoint.getResourceHTTPMethod() + " sequence type " + breakPoint.getSynapseSequenceType().toString()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Failed register breakpoint. Already breakpoint enabled at mediator position " + APIDebugUtil.logMediatorPosition(breakPoint) + " for API key " + breakPoint.getKey() + " resource mapping " + breakPoint.getResourceMapping() + " resource HTTP method " + breakPoint.getResourceHTTPMethod() + " sequence type " + breakPoint.getSynapseSequenceType().toString()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already breakpoint enabled at mediator position").toString());
                    }
                } else if (((AbstractMediator)current_mediator).isBreakPoint()) {
                    ((AbstractMediator)current_mediator).unregisterMediationFlowPoint();
                    ((AbstractMediator)current_mediator).setBreakPoint(false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unregistered breakpoint at mediator position " + APIDebugUtil.logMediatorPosition(breakPoint) + " for API key " + breakPoint.getKey() + " resource mapping " + breakPoint.getResourceMapping() + " resource HTTP method " + breakPoint.getResourceHTTPMethod() + " sequence type " + breakPoint.getSynapseSequenceType().toString()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed unregister breakpoint. Already breakpoint disabled at mediator position " + APIDebugUtil.logMediatorPosition(breakPoint) + " for API key " + breakPoint.getKey() + " resource mapping " + breakPoint.getResourceMapping() + " resource HTTP method " + breakPoint.getResourceHTTPMethod() + " sequence type " + breakPoint.getSynapseSequenceType().toString()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already breakpoint disabled at mediator position").toString());
                }
            } else if (registerMode) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed register breakpoint. Non existing mediator position at " + APIDebugUtil.logMediatorPosition(breakPoint) + " for API key " + breakPoint.getKey() + " resource mapping " + breakPoint.getResourceMapping() + " resource HTTP method " + breakPoint.getResourceHTTPMethod() + " sequence type " + breakPoint.getSynapseSequenceType().toString()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed unregister breakpoint. Non existing mediator position at " + APIDebugUtil.logMediatorPosition(breakPoint) + " for API key " + breakPoint.getKey() + " resource mapping " + breakPoint.getResourceMapping() + " resource HTTP method " + breakPoint.getResourceHTTPMethod() + " sequence type " + breakPoint.getSynapseSequenceType().toString()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            }
        } else if (registerMode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed register breakpoint. Non existing sequence " + breakPoint.getSynapseSequenceType().toString() + " for API key " + breakPoint.getKey() + " resource mapping " + breakPoint.getResourceMapping() + " resource HTTP method " + breakPoint.getResourceHTTPMethod()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing sequence").toString());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed unregister breakpoint. Non existing sequence " + breakPoint.getSynapseSequenceType().toString() + " for API key " + breakPoint.getKey() + " resource mapping " + breakPoint.getResourceMapping() + " resource HTTP method " + breakPoint.getResourceHTTPMethod()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing sequence").toString());
        }
    }

    public static void registerAPISequenceMediationFlowSkip(SynapseConfiguration synCfg, String mapping, String method, String seqType, String apiKey, int[] position, boolean registerMode) {
        SynapseSequenceType synapseSequenceType = SynapseSequenceType.valueOf(seqType.toUpperCase());
        APIMediationFlowPoint skipPoint = new APIMediationFlowPoint();
        skipPoint.setSynapseMediationComponent(SynapseMediationComponent.SEQUENCE);
        skipPoint.setKey(apiKey);
        skipPoint.setMediatorPosition(position);
        skipPoint.setSynapseSequenceType(synapseSequenceType);
        skipPoint.setSequenceBaseType("api");
        skipPoint.setResourceMapping(mapping);
        skipPoint.setResourceHTTPMethod(method);
        SequenceMediator seqMediator = null;
        Resource api_resource = null;
        API api = synCfg.getAPI(apiKey);
        if (api == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Non existing API for the key " + skipPoint.getKey()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "api not found").toString());
            return;
        }
        Resource[] resource_array = api.getResources();
        for (int counter = 0; counter < resource_array.length; ++counter) {
            if (resource_array[counter].getDispatcherHelper() != null && mapping != null) {
                if (!mapping.equals(resource_array[counter].getDispatcherHelper().getString())) continue;
                for (String m1 : resource_array[counter].getMethods()) {
                    if (!m1.equals(method)) continue;
                    api_resource = resource_array[counter];
                    break;
                }
                if (api_resource == null) continue;
                break;
            }
            if (resource_array[counter].getDispatcherHelper() != null || mapping != null) continue;
            for (String m1 : resource_array[counter].getMethods()) {
                if (!m1.equals(method)) continue;
                api_resource = resource_array[counter];
                break;
            }
            if (api_resource != null) break;
        }
        if (api_resource != null) {
            if (synapseSequenceType.equals((Object)SynapseSequenceType.API_INSEQ)) {
                seqMediator = api_resource.getInSequence();
            } else if (synapseSequenceType.equals((Object)SynapseSequenceType.API_OUTSEQ)) {
                seqMediator = api_resource.getOutSequence();
            } else if (synapseSequenceType.equals((Object)SynapseSequenceType.API_FAULTSEQ)) {
                seqMediator = api_resource.getFaultSequence();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource not found for the API key " + skipPoint.getKey() + " resource mapping " + skipPoint.getResourceMapping() + " resource HTTP method " + skipPoint.getResourceHTTPMethod()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "api resource not found").toString());
            return;
        }
        if (seqMediator != null) {
            Mediator current_mediator = null;
            current_mediator = MediatorTreeTraverseUtil.getMediatorReference(synCfg, seqMediator, position);
            if (current_mediator != null) {
                skipPoint.setMediatorReference(current_mediator);
                if (registerMode) {
                    if (!((AbstractMediator)current_mediator).isSkipEnabled()) {
                        ((AbstractMediator)current_mediator).setSkipEnabled(true);
                        ((AbstractMediator)current_mediator).registerMediationFlowPoint(skipPoint);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Registered skip at mediator position " + APIDebugUtil.logMediatorPosition(skipPoint) + " for API key " + skipPoint.getKey() + " resource mapping " + skipPoint.getResourceMapping() + " resource HTTP method " + skipPoint.getResourceHTTPMethod() + " sequence type " + skipPoint.getSynapseSequenceType().toString()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Failed register skip. Already skip enabled at mediator position " + APIDebugUtil.logMediatorPosition(skipPoint) + " for API key " + skipPoint.getKey() + " resource mapping " + skipPoint.getResourceMapping() + " resource HTTP method " + skipPoint.getResourceHTTPMethod() + " sequence type " + skipPoint.getSynapseSequenceType().toString()));
                        }
                        debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already skip enabled at mediator position").toString());
                    }
                } else if (((AbstractMediator)current_mediator).isSkipEnabled()) {
                    ((AbstractMediator)current_mediator).unregisterMediationFlowPoint();
                    ((AbstractMediator)current_mediator).setSkipEnabled(false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unregistered skip at mediator position " + APIDebugUtil.logMediatorPosition(skipPoint) + " for API key " + skipPoint.getKey() + " resource mapping " + skipPoint.getResourceMapping() + " resource HTTP method " + skipPoint.getResourceHTTPMethod() + " sequence type " + skipPoint.getSynapseSequenceType().toString()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(true, null).toString());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed unregister skip. Already skip disabled at mediator position " + APIDebugUtil.logMediatorPosition(skipPoint) + " for API key " + skipPoint.getKey() + " resource mapping " + skipPoint.getResourceMapping() + " resource HTTP method " + skipPoint.getResourceHTTPMethod() + " sequence type " + skipPoint.getSynapseSequenceType().toString()));
                    }
                    debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "already skip disabled at mediator position").toString());
                }
            } else if (registerMode) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed register skip. Non existing mediator position at " + APIDebugUtil.logMediatorPosition(skipPoint) + " for API key " + skipPoint.getKey() + " resource mapping " + skipPoint.getResourceMapping() + " resource HTTP method " + skipPoint.getResourceHTTPMethod() + " sequence type " + skipPoint.getSynapseSequenceType().toString()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed unregister skip. Non existing mediator position at " + APIDebugUtil.logMediatorPosition(skipPoint) + " for API key " + skipPoint.getKey() + " resource mapping " + skipPoint.getResourceMapping() + " resource HTTP method " + skipPoint.getResourceHTTPMethod() + " sequence type " + skipPoint.getSynapseSequenceType().toString()));
                }
                debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing mediator position").toString());
            }
        } else if (registerMode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed register skip. Non existing sequence " + skipPoint.getSynapseSequenceType().toString() + " for API key " + skipPoint.getKey() + " resource mapping " + skipPoint.getResourceMapping() + " resource HTTP method " + skipPoint.getResourceHTTPMethod()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing sequence").toString());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed unregister skip. Non existing sequence " + skipPoint.getSynapseSequenceType().toString() + " for API key " + skipPoint.getKey() + " resource mapping " + skipPoint.getResourceMapping() + " resource HTTP method " + skipPoint.getResourceHTTPMethod()));
            }
            debugManager.advertiseCommandResponse(debugManager.createDebugCommandResponse(false, "non existing sequence").toString());
        }
    }

    protected static String logMediatorPosition(SynapseMediationFlowPoint flowPoint) {
        String position = "";
        for (int count = 0; count < flowPoint.getMediatorPosition().length; ++count) {
            if (count != 0) {
                position = position.concat("-->");
            }
            position = position.concat("(" + String.valueOf(flowPoint.getMediatorPosition()[count]) + ")");
        }
        return position;
    }
}

