/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.debug;

import java.io.IOException;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.debug.SynapseDebugInterface;
import org.apache.synapse.debug.SynapseDebugManager;

public class SynapseDebugTCPListener
extends Thread {
    private SynapseDebugManager debugManager;
    private SynapseDebugInterface debugInterface;
    private boolean isDebugModeInProgress = false;
    private static final Log log = LogFactory.getLog(SynapseDebugTCPListener.class);

    public SynapseDebugTCPListener(SynapseDebugManager debugManager, SynapseDebugInterface debugInterface) {
        this.debugManager = debugManager;
        this.debugInterface = debugInterface;
    }

    public void setDebugModeInProgress(boolean isDebugModeInProgress) {
        this.isDebugModeInProgress = isDebugModeInProgress;
    }

    public boolean getDebugModeInProgress() {
        return this.isDebugModeInProgress;
    }

    @Override
    public void run() {
        String debug_line = null;
        while (this.isDebugModeInProgress) {
            try {
                debug_line = this.debugInterface.getPortListenReader().readLine();
                if (debug_line == null) continue;
                this.debugManager.processDebugCommand(debug_line);
                log.debug((Object)("debug command received from developer studio - " + debug_line));
                debug_line = null;
            }
            catch (SocketException ex) {
                this.isDebugModeInProgress = false;
                log.error((Object)("Error in Socket Connection " + ex.getMessage()), (Throwable)ex);
            }
            catch (IOException ex) {
                log.error((Object)"Unable to process debug commands", (Throwable)ex);
            }
        }
    }

    public void shutDownListener() {
        this.isDebugModeInProgress = false;
    }
}

