/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.debug;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.debug.SynapseDebugInterface;
import org.apache.synapse.debug.SynapseDebugTCPListener;
import org.apache.synapse.debug.constructs.APIMediationFlowPoint;
import org.apache.synapse.debug.constructs.ConnectorMediationFlowPoint;
import org.apache.synapse.debug.constructs.MediationFlowState;
import org.apache.synapse.debug.constructs.SequenceMediationFlowPoint;
import org.apache.synapse.debug.constructs.SynapseMediationComponent;
import org.apache.synapse.debug.constructs.SynapseMediationFlowPoint;
import org.apache.synapse.debug.utils.APIDebugUtil;
import org.apache.synapse.debug.utils.ConnectorDebugUtil;
import org.apache.synapse.debug.utils.InboundEndpointDebugUtil;
import org.apache.synapse.debug.utils.ProxyDebugUtil;
import org.apache.synapse.debug.utils.SequenceDebugUtil;
import org.apache.synapse.debug.utils.TemplateDebugUtil;
import org.apache.synapse.transport.http.conn.SynapseBackEndWireLogs;
import org.apache.synapse.transport.http.conn.SynapseDebugInfoHolder;
import org.apache.synapse.transport.http.conn.SynapseWireLogHolder;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SynapseDebugManager
implements Observer {
    private static final String METHOD_ARRAY_SEPERATOR = ",";
    private static final String EMPTY_STRING = "";
    private static volatile ReentrantLock mediationFlowLock;
    public static volatile Semaphore mediationFlowSem;
    private MessageContext synCtx;
    private SynapseDebugInterface debugInterface = null;
    private static SynapseDebugManager debugManagerInstance;
    private static SynapseDebugTCPListener debugTCPListener;
    private SynapseConfiguration synCfg;
    private SynapseEnvironment synEnv;
    private MediationFlowState medFlowState = MediationFlowState.IDLE;
    private boolean initialised = false;
    private static final Log log;
    private Map addedPropertyValuesMap;

    protected SynapseDebugManager() {
        mediationFlowLock = new ReentrantLock();
        mediationFlowSem = new Semaphore(0);
        this.addedPropertyValuesMap = new HashMap();
    }

    public static SynapseDebugManager getInstance() {
        if (debugManagerInstance == null) {
            debugManagerInstance = new SynapseDebugManager();
        }
        return debugManagerInstance;
    }

    public void setMessageContext(MessageContext synCtx) {
        this.synCtx = synCtx;
    }

    public void init(SynapseConfiguration synCfg, SynapseDebugInterface debugInterface, SynapseEnvironment synEnv, boolean startListenAsynchronously) {
        if (synEnv.isDebuggerEnabled()) {
            this.synCfg = synCfg;
            this.debugInterface = debugInterface;
            this.synEnv = synEnv;
            SynapseDebugInfoHolder.getInstance().setDebuggerEnabled(true);
            SynapseDebugInfoHolder.getInstance().addObserver((Observer)this);
            if (!this.initialised) {
                this.initialised = true;
                debugTCPListener = new SynapseDebugTCPListener(this, this.debugInterface);
                debugTCPListener.setDebugModeInProgress(true);
                if (startListenAsynchronously) {
                    debugTCPListener.start();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Initialized with Synapse Configuration...");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Updated Synapse Configuration...");
                }
                this.advertiseDebugEvent(this.createDebugEvent("configuration updated").toString());
            }
        }
    }

    public void acquireMediationFlowLock() {
        mediationFlowLock.lock();
    }

    public void releaseMediationFlowLock() {
        mediationFlowLock.unlock();
    }

    public void shutdownDebugManager() {
        if (this.synEnv.isDebuggerEnabled()) {
            this.debugInterface.closeConnection();
            debugTCPListener.shutDownListener();
        }
    }

    public void transitMediationFlowStateToSuspended() {
        if (this.synEnv.isDebuggerEnabled() && (this.medFlowState == MediationFlowState.IDLE || this.medFlowState == MediationFlowState.ACTIVE)) {
            this.medFlowState = MediationFlowState.SUSPENDED;
            try {
                mediationFlowSem.acquire();
            }
            catch (InterruptedException ex) {
                log.error((Object)"Unable to suspend the mediation flow thread", (Throwable)ex);
            }
        }
    }

    public void transitMediationFlowStateToActive() {
        if (this.synEnv.isDebuggerEnabled() && this.medFlowState == MediationFlowState.SUSPENDED) {
            this.medFlowState = MediationFlowState.ACTIVE;
            mediationFlowSem.release();
        }
    }

    public void advertiseMediationFlowStartPoint(MessageContext synCtx) {
        if (this.synEnv.isDebuggerEnabled()) {
            this.setMessageContext(synCtx);
            this.advertiseDebugEvent(this.createDebugEvent("started").toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mediation flow started for id " + synCtx.getMessageID()));
            }
        }
    }

    public void advertiseMediationFlowTerminatePoint(MessageContext synCtx) {
        if (this.synEnv.isDebuggerEnabled()) {
            String axis2ContextKey;
            this.advertiseDebugEvent(this.createDebugEvent("terminated").toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mediation flow terminated for id " + synCtx.getMessageID()));
            }
            if (this.addedPropertyValuesMap.containsKey(axis2ContextKey = this.getAxis2MessagePropertiesKey(((Axis2MessageContext)synCtx).getAxis2MessageContext()))) {
                this.addedPropertyValuesMap.remove(axis2ContextKey);
            }
        }
    }

    public void advertiseMediationFlowSkip(MessageContext synCtx, SynapseMediationFlowPoint skipPoint) {
        if (this.synEnv.isDebuggerEnabled() && this.debugInterface != null) {
            this.setMessageContext(synCtx);
            this.advertiseDebugEvent(this.createDebugMediationFlowPointHitEvent(false, skipPoint).toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mediation Flow skipped at " + this.logMediatorPosition(skipPoint)));
            }
        }
    }

    public void advertiseMediationFlowBreakPoint(MessageContext synCtx, SynapseMediationFlowPoint breakPoint) {
        if (this.synEnv.isDebuggerEnabled()) {
            this.setMessageContext(synCtx);
            this.advertiseDebugEvent(this.createDebugMediationFlowPointHitEvent(true, breakPoint).toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mediation flow suspended at " + this.logMediatorPosition(breakPoint)));
            }
            this.transitMediationFlowStateToSuspended();
            this.advertiseDebugEvent(this.createDebugEvent("resumed client").toString());
            if (log.isDebugEnabled()) {
                log.info((Object)("Mediation flow resumed from suspension at " + this.logMediatorPosition(breakPoint)));
            }
        }
    }

    protected String logMediatorPosition(SynapseMediationFlowPoint flowPoint) {
        String log = EMPTY_STRING;
        String position = EMPTY_STRING;
        for (int count = 0; count < flowPoint.getMediatorPosition().length; ++count) {
            if (count != 0) {
                position = position.concat("-->");
            }
            position = position.concat("(" + String.valueOf(flowPoint.getMediatorPosition()[count]) + ")");
        }
        log = log.concat("mediator position " + position);
        if (flowPoint instanceof SequenceMediationFlowPoint) {
            log = log.concat(" " + ((SequenceMediationFlowPoint)flowPoint).getSequenceBaseType().toString() + " " + flowPoint.getKey());
            log = log.concat(" sequence " + ((SequenceMediationFlowPoint)flowPoint).getSynapseSequenceType().toString().toLowerCase());
        } else {
            log = log.concat(" " + flowPoint.getSynapseMediationComponent().toString().toLowerCase() + " " + flowPoint.getKey());
        }
        return log;
    }

    public void processDebugCommand(String debug_line) throws IOException {
        try {
            JSONObject parsed_debug_line = new JSONObject(debug_line);
            String command = EMPTY_STRING;
            if (!parsed_debug_line.has("command")) {
                return;
            }
            command = parsed_debug_line.getString("command");
            if (command.equals("clear")) {
                String skipOrBreakPointOrProperty = parsed_debug_line.getString("command-argument");
                if (skipOrBreakPointOrProperty.equals("property")) {
                    String propertyContext = parsed_debug_line.getString("context");
                    JSONObject property_arguments = parsed_debug_line.getJSONObject("property");
                    this.addMediationFlowPointProperty(propertyContext, property_arguments, false);
                } else {
                    String mediation_component = parsed_debug_line.getString("mediation-component");
                    JSONObject med_component_arguments = parsed_debug_line.getJSONObject(mediation_component);
                    if (skipOrBreakPointOrProperty.equals("breakpoint")) {
                        this.registerMediationFlowPoint(mediation_component, med_component_arguments, true, false);
                    } else if (skipOrBreakPointOrProperty.equals("skip")) {
                        this.registerMediationFlowPoint(mediation_component, med_component_arguments, false, false);
                    }
                }
            } else if (command.equals("get")) {
                String propertyOrProperties = parsed_debug_line.getString("command-argument");
                String propertyContext = parsed_debug_line.getString("context");
                JSONObject property_arguments = null;
                if (propertyOrProperties.equals("property")) {
                    property_arguments = parsed_debug_line.getJSONObject("property");
                }
                this.acquireMediationFlowPointProperties(propertyOrProperties, propertyContext, property_arguments);
            } else if (command.equals("resume")) {
                this.debugResume();
            } else if (command.equals("set")) {
                String skipOrBreakPointOrProperty = parsed_debug_line.getString("command-argument");
                if (skipOrBreakPointOrProperty.equals("property")) {
                    String propertyContext = parsed_debug_line.getString("context");
                    JSONObject property_arguments = parsed_debug_line.getJSONObject("property");
                    this.addMediationFlowPointProperty(propertyContext, property_arguments, true);
                } else {
                    String mediation_component = parsed_debug_line.getString("mediation-component");
                    JSONObject med_component_arguments = parsed_debug_line.getJSONObject(mediation_component);
                    if (skipOrBreakPointOrProperty.equals("breakpoint")) {
                        this.registerMediationFlowPoint(mediation_component, med_component_arguments, true, true);
                    } else if (skipOrBreakPointOrProperty.equals("skip")) {
                        this.registerMediationFlowPoint(mediation_component, med_component_arguments, false, true);
                    }
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Debug command not found");
                }
                this.advertiseCommandResponse(this.createDebugCommandResponse(false, "command not found").toString());
            }
        }
        catch (JSONException ex) {
            log.error((Object)"Unable to process debug command", (Throwable)ex);
        }
    }

    public void registerMediationFlowPoint(String mediation_component, JSONObject med_component_arguments, boolean isBreakpoint, boolean registerMode) {
        try {
            if (mediation_component.equals("connector")) {
                String connector_key = med_component_arguments.getString("connector-key");
                String connector_method_name = med_component_arguments.getString("method-name");
                String component_mediator_position = med_component_arguments.getString("mediator-position");
                String[] mediator_position_array = component_mediator_position.split("\\s+");
                int[] med_pos = new int[mediator_position_array.length];
                for (int counter = 0; counter < mediator_position_array.length; ++counter) {
                    med_pos[counter] = Integer.valueOf(mediator_position_array[counter]);
                }
                if (isBreakpoint) {
                    ConnectorDebugUtil.registerConnectorMediationFlowBreakPoint(this.synCfg, connector_key, connector_method_name, med_pos, registerMode);
                } else {
                    ConnectorDebugUtil.registerConnectorMediationFlowSkip(this.synCfg, connector_key, connector_method_name, med_pos, registerMode);
                }
            } else if (mediation_component.equals("sequence")) {
                if (!(med_component_arguments.has("proxy") || med_component_arguments.has("api") || med_component_arguments.has("inbound"))) {
                    String sequence_key = med_component_arguments.getString("sequence-key");
                    String sequence_type = med_component_arguments.getString("sequence-type");
                    String component_mediator_position = med_component_arguments.getString("mediator-position");
                    String[] mediator_position_array = component_mediator_position.split("\\s+");
                    int[] med_pos = new int[mediator_position_array.length];
                    for (int counter = 0; counter < mediator_position_array.length; ++counter) {
                        med_pos[counter] = Integer.valueOf(mediator_position_array[counter]);
                    }
                    if (isBreakpoint) {
                        SequenceDebugUtil.registerSequenceMediationFlowBreakPoint(this.synCfg, sequence_type, sequence_key, med_pos, registerMode);
                    } else {
                        SequenceDebugUtil.registerSequenceMediationFlowSkip(this.synCfg, sequence_type, sequence_key, med_pos, registerMode);
                    }
                } else if (med_component_arguments.has("proxy")) {
                    JSONObject proxy_arguments = med_component_arguments.getJSONObject("proxy");
                    String proxy_key = proxy_arguments.getString("proxy-key");
                    String sequence_type = proxy_arguments.getString("sequence-type");
                    String component_mediator_position = proxy_arguments.getString("mediator-position");
                    String[] mediator_position_array = component_mediator_position.split("\\s+");
                    int[] med_pos = new int[mediator_position_array.length];
                    for (int counter = 0; counter < mediator_position_array.length; ++counter) {
                        med_pos[counter] = Integer.valueOf(mediator_position_array[counter]);
                    }
                    if (isBreakpoint) {
                        ProxyDebugUtil.registerProxySequenceMediationFlowBreakPoint(this.synCfg, sequence_type, proxy_key, med_pos, registerMode);
                    } else {
                        ProxyDebugUtil.registerProxySequenceMediationFlowSkip(this.synCfg, sequence_type, proxy_key, med_pos, registerMode);
                    }
                } else if (med_component_arguments.has("inbound")) {
                    JSONObject inbound_arguments = med_component_arguments.getJSONObject("inbound");
                    String inbound_key = inbound_arguments.getString("inbound-key");
                    String sequence_type = inbound_arguments.getString("sequence-type");
                    String component_mediator_position = inbound_arguments.getString("mediator-position");
                    String[] mediator_position_array = component_mediator_position.split("\\s+");
                    int[] med_pos = new int[mediator_position_array.length];
                    for (int counter = 0; counter < mediator_position_array.length; ++counter) {
                        med_pos[counter] = Integer.valueOf(mediator_position_array[counter]);
                    }
                    if (isBreakpoint) {
                        InboundEndpointDebugUtil.registerInboundSequenceMediationFlowBreakPoint(this.synCfg, sequence_type, inbound_key, med_pos, registerMode);
                    } else {
                        InboundEndpointDebugUtil.registerInboundSequenceMediationFlowSkip(this.synCfg, sequence_type, inbound_key, med_pos, registerMode);
                    }
                } else if (med_component_arguments.has("api")) {
                    JSONObject api_arguments = med_component_arguments.getJSONObject("api");
                    JSONObject resource_arguments = api_arguments.getJSONObject("resource");
                    String mapping = null;
                    if (resource_arguments.has("uri-template")) {
                        mapping = resource_arguments.getString("uri-template");
                    } else if (resource_arguments.has("url-mapping")) {
                        mapping = resource_arguments.getString("url-mapping");
                    }
                    String method = resource_arguments.getString("method");
                    String[] methodArray = method.split(METHOD_ARRAY_SEPERATOR);
                    String api_key = api_arguments.getString("api-key");
                    String sequence_type = api_arguments.getString("sequence-type");
                    String component_mediator_position = api_arguments.getString("mediator-position");
                    String[] mediator_position_array = component_mediator_position.split("\\s+");
                    int[] med_pos = new int[mediator_position_array.length];
                    for (int counter = 0; counter < mediator_position_array.length; ++counter) {
                        med_pos[counter] = Integer.valueOf(mediator_position_array[counter]);
                    }
                    for (String resourceMethod : methodArray) {
                        if (isBreakpoint) {
                            APIDebugUtil.registerAPISequenceMediationFlowBreakPoint(this.synCfg, mapping, resourceMethod, sequence_type, api_key, med_pos, registerMode);
                            continue;
                        }
                        APIDebugUtil.registerAPISequenceMediationFlowSkip(this.synCfg, mapping, resourceMethod, sequence_type, api_key, med_pos, registerMode);
                    }
                }
            } else if (mediation_component.equals("template")) {
                String template_key = med_component_arguments.getString("template-key");
                String component_mediator_position = med_component_arguments.getString("mediator-position");
                String[] mediator_position_array = component_mediator_position.split("\\s+");
                int[] med_pos = new int[mediator_position_array.length];
                for (int counter = 0; counter < mediator_position_array.length; ++counter) {
                    med_pos[counter] = Integer.valueOf(mediator_position_array[counter]);
                }
                if (isBreakpoint) {
                    TemplateDebugUtil.registerTemplateMediationFlowBreakPoint(this.synCfg, template_key, med_pos, registerMode);
                } else {
                    TemplateDebugUtil.registerTemplateMediationFlowSkip(this.synCfg, template_key, med_pos, registerMode);
                }
            }
        }
        catch (JSONException ex) {
            log.error((Object)"Unable to register mediation flow point", (Throwable)ex);
            this.advertiseCommandResponse(this.createDebugCommandResponse(false, "unable to register mediation flow point").toString());
        }
    }

    public void advertiseCommandResponse(String commandResponse) {
        if (this.synEnv.isDebuggerEnabled()) {
            this.debugInterface.getPortListenWriter().println(commandResponse);
            this.debugInterface.getPortListenWriter().flush();
        }
    }

    public void advertiseDebugEvent(String event) {
        if (this.synEnv.isDebuggerEnabled()) {
            this.debugInterface.getPortSendWriter().println(event);
            this.debugInterface.getPortSendWriter().flush();
        }
    }

    public void debugResume() {
        this.transitMediationFlowStateToActive();
        this.advertiseCommandResponse(this.createDebugCommandResponse(true, null).toString());
    }

    public JSONObject createDebugCommandResponse(boolean isPositive, String failedReason) {
        JSONObject response = null;
        response = new JSONObject();
        try {
            if (isPositive) {
                response.put("command-response", (Object)"successful");
            } else {
                response.put("command-response", (Object)"failed");
                response.put("failed-reason", (Object)failedReason);
            }
        }
        catch (JSONException e) {
            log.error((Object)"Unable to advertise command response", (Throwable)e);
        }
        return response;
    }

    public JSONObject createDebugMediationFlowPointHitEvent(boolean isBreakpoint, SynapseMediationFlowPoint point) {
        JSONObject event = null;
        try {
            event = new JSONObject();
            if (isBreakpoint) {
                event.put("event", (Object)"breakpoint");
            } else {
                event.put("event", (Object)"skip");
            }
            JSONObject parameters = new JSONObject();
            if (point.getSynapseMediationComponent().equals((Object)SynapseMediationComponent.SEQUENCE)) {
                event.put("mediation-component", (Object)"sequence");
                if (((SequenceMediationFlowPoint)point).getSequenceBaseType().equals("sequence")) {
                    parameters.put("sequence-key", (Object)point.getKey());
                    parameters.put("sequence-type", (Object)((SequenceMediationFlowPoint)point).getSynapseSequenceType().toString().toLowerCase());
                    parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                    event.put("sequence", (Object)parameters);
                } else if (((SequenceMediationFlowPoint)point).getSequenceBaseType().equals("proxy")) {
                    JSONObject proxy_parameters = new JSONObject();
                    proxy_parameters.put("proxy-key", (Object)point.getKey());
                    proxy_parameters.put("sequence-type", (Object)((SequenceMediationFlowPoint)point).getSynapseSequenceType().toString().toLowerCase());
                    proxy_parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                    parameters.put("proxy", (Object)proxy_parameters);
                    event.put("sequence", (Object)parameters);
                } else if (((SequenceMediationFlowPoint)point).getSequenceBaseType().equals("inbound")) {
                    JSONObject inbound_parameters = new JSONObject();
                    inbound_parameters.put("inbound-key", (Object)point.getKey());
                    inbound_parameters.put("sequence-type", (Object)((SequenceMediationFlowPoint)point).getSynapseSequenceType().toString().toLowerCase());
                    inbound_parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                    parameters.put("inbound", (Object)inbound_parameters);
                    event.put("sequence", (Object)parameters);
                } else if (((SequenceMediationFlowPoint)point).getSequenceBaseType().equals("api")) {
                    JSONObject api_parameters = new JSONObject();
                    api_parameters.put("api-key", (Object)point.getKey());
                    JSONObject resource = new JSONObject();
                    resource.put("mapping", (Object)((APIMediationFlowPoint)point).getResourceMapping());
                    resource.put("method", (Object)((APIMediationFlowPoint)point).getResourceHTTPMethod());
                    api_parameters.put("resource", (Object)resource);
                    api_parameters.put("sequence-type", (Object)((SequenceMediationFlowPoint)point).getSynapseSequenceType().toString().toLowerCase());
                    api_parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                    parameters.put("api", (Object)api_parameters);
                    event.put("sequence", (Object)parameters);
                }
            } else if (point.getSynapseMediationComponent().equals((Object)SynapseMediationComponent.TEMPLATE)) {
                event.put("mediation-component", (Object)"template");
                parameters.put("template-key", (Object)point.getKey());
                parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                event.put("template", (Object)parameters);
            } else if (point.getSynapseMediationComponent().equals((Object)SynapseMediationComponent.CONNECTOR)) {
                event.put("mediation-component", (Object)"connector");
                parameters.put("connector-key", (Object)point.getKey());
                parameters.put("method-name", (Object)((ConnectorMediationFlowPoint)point).getConnectorMediationComponentMethod());
                parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                event.put("connector", (Object)parameters);
            }
        }
        catch (JSONException ex) {
            log.error((Object)"Failed to create debug event in JSON format", (Throwable)ex);
        }
        return event;
    }

    public JSONObject createDebugMediationFlowPointJSONForWireLogs(SynapseMediationFlowPoint point) {
        JSONObject flowPointJson = null;
        try {
            flowPointJson = new JSONObject();
            JSONObject parameters = new JSONObject();
            if (point.getSynapseMediationComponent().equals((Object)SynapseMediationComponent.SEQUENCE)) {
                flowPointJson.put("mediation-component", (Object)"sequence");
                if (((SequenceMediationFlowPoint)point).getSequenceBaseType().equals("sequence")) {
                    parameters.put("sequence-key", (Object)point.getKey());
                    parameters.put("sequence-type", (Object)((SequenceMediationFlowPoint)point).getSynapseSequenceType().toString().toLowerCase());
                    parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                    flowPointJson.put("sequence", (Object)parameters);
                } else if (((SequenceMediationFlowPoint)point).getSequenceBaseType().equals("proxy")) {
                    JSONObject proxy_parameters = new JSONObject();
                    proxy_parameters.put("proxy-key", (Object)point.getKey());
                    proxy_parameters.put("sequence-type", (Object)((SequenceMediationFlowPoint)point).getSynapseSequenceType().toString().toLowerCase());
                    proxy_parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                    parameters.put("proxy", (Object)proxy_parameters);
                    flowPointJson.put("sequence", (Object)parameters);
                } else if (((SequenceMediationFlowPoint)point).getSequenceBaseType().equals("inbound")) {
                    JSONObject inbound_parameters = new JSONObject();
                    inbound_parameters.put("inbound-key", (Object)point.getKey());
                    inbound_parameters.put("sequence-type", (Object)((SequenceMediationFlowPoint)point).getSynapseSequenceType().toString().toLowerCase());
                    inbound_parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                    parameters.put("inbound", (Object)inbound_parameters);
                    flowPointJson.put("sequence", (Object)parameters);
                } else if (((SequenceMediationFlowPoint)point).getSequenceBaseType().equals("api")) {
                    JSONObject api_parameters = new JSONObject();
                    api_parameters.put("api-key", (Object)point.getKey());
                    JSONObject resource = new JSONObject();
                    resource.put("mapping", (Object)((APIMediationFlowPoint)point).getResourceMapping());
                    resource.put("method", (Object)((APIMediationFlowPoint)point).getResourceHTTPMethod());
                    api_parameters.put("resource", (Object)resource);
                    api_parameters.put("sequence-type", (Object)((SequenceMediationFlowPoint)point).getSynapseSequenceType().toString().toLowerCase());
                    api_parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                    parameters.put("api", (Object)api_parameters);
                    flowPointJson.put("sequence", (Object)parameters);
                }
            } else if (point.getSynapseMediationComponent().equals((Object)SynapseMediationComponent.TEMPLATE)) {
                flowPointJson.put("mediation-component", (Object)"template");
                parameters.put("template-key", (Object)point.getKey());
                parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                flowPointJson.put("template", (Object)parameters);
            } else if (point.getSynapseMediationComponent().equals((Object)SynapseMediationComponent.CONNECTOR)) {
                flowPointJson.put("mediation-component", (Object)"connector");
                parameters.put("connector-key", (Object)point.getKey());
                parameters.put("method-name", (Object)((ConnectorMediationFlowPoint)point).getConnectorMediationComponentMethod());
                parameters.put("mediator-position", (Object)this.toString(point.getMediatorPosition()));
                flowPointJson.put("connector", (Object)parameters);
            }
        }
        catch (JSONException ex) {
            log.error((Object)"Failed to create debug flowPointJson in JSON format", (Throwable)ex);
        }
        return flowPointJson;
    }

    public JSONObject createDebugEvent(String eventString) {
        JSONObject event = null;
        try {
            event = new JSONObject();
            event.put("event", (Object)eventString);
        }
        catch (JSONException ex) {
            log.error((Object)"Failed to create debug event in JSON format", (Throwable)ex);
        }
        return event;
    }

    protected String toString(int[] position) {
        String positionString = EMPTY_STRING;
        for (int counter = 0; counter < position.length; ++counter) {
            positionString = positionString.concat(String.valueOf(position[counter])).concat(" ");
        }
        return positionString.trim();
    }

    public void acquireMediationFlowPointProperties(String propertyOrProperties, String propertyContext, JSONObject property_arguments) throws IOException {
        if (this.medFlowState != MediationFlowState.SUSPENDED & (propertyContext != null & !propertyContext.equals("wire"))) {
            this.advertiseCommandResponse(this.createDebugCommandResponse(false, "unable to acquire message context properties").toString());
            return;
        }
        try {
            if (propertyOrProperties.equals("properties")) {
                if (propertyContext.equals("all")) {
                    JSONObject data_axis2 = this.getAxis2Properties();
                    JSONObject data_synapse = new JSONObject(((Axis2MessageContext)this.synCtx).getProperties());
                    JSONObject data_axis2_prop = new JSONObject();
                    JSONObject data_synapse_prop = new JSONObject();
                    data_axis2_prop.put("axis2-properties", (Object)data_axis2);
                    data_synapse_prop.put("synapse-properties", (Object)data_synapse);
                    JSONArray data_array = new JSONArray();
                    data_array.put((Object)data_axis2_prop);
                    data_array.put((Object)data_synapse_prop);
                    this.debugInterface.getPortListenWriter().println(data_array.toString());
                    this.debugInterface.getPortListenWriter().flush();
                } else if (propertyContext.equals("axis2")) {
                    JSONObject data_axis2 = this.getAxis2Properties();
                    JSONObject data_axis2_prop = new JSONObject();
                    data_axis2_prop.put("axis2-properties", (Object)data_axis2);
                    this.debugInterface.getPortListenWriter().println(data_axis2_prop.toString());
                    this.debugInterface.getPortListenWriter().flush();
                } else if (propertyContext.equals("synapse") || propertyContext.equals("default")) {
                    JSONObject data_synapse = new JSONObject(((Axis2MessageContext)this.synCtx).getProperties());
                    JSONObject data_synapse_prop = new JSONObject();
                    data_synapse_prop.put("synapse-properties", (Object)data_synapse);
                    this.debugInterface.getPortListenWriter().println(data_synapse_prop.toString());
                    this.debugInterface.getPortListenWriter().flush();
                } else if (propertyContext.equals("axis2-client")) {
                    JSONObject data_axis2 = new JSONObject(((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getOptions().getProperties());
                    JSONObject data_axis2_prop = new JSONObject();
                    data_axis2_prop.put("axis2Client-properties", (Object)data_axis2);
                    this.debugInterface.getPortListenWriter().println(data_axis2_prop.toString());
                    this.debugInterface.getPortListenWriter().flush();
                } else if (propertyContext.equals("transport")) {
                    JSONObject data_axis2 = new JSONObject((Map)((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS"));
                    JSONObject data_axis2_prop = new JSONObject();
                    data_axis2_prop.put("axis2Transport-properties", (Object)data_axis2);
                    this.debugInterface.getPortListenWriter().println(data_axis2_prop.toString());
                    this.debugInterface.getPortListenWriter().flush();
                } else if (propertyContext.equals("operation")) {
                    JSONObject data_axis2 = new JSONObject(((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getOperationContext().getProperties());
                    JSONObject data_axis2_prop = new JSONObject();
                    data_axis2_prop.put("axis2Operation-properties", (Object)data_axis2);
                    this.debugInterface.getPortListenWriter().println(data_axis2_prop.toString());
                    this.debugInterface.getPortListenWriter().flush();
                }
            } else if (propertyOrProperties.equals("property")) {
                if (propertyContext.equals("axis2")) {
                    JSONObject data_axis2 = this.getAxis2Properties();
                    Object result = null;
                    if (data_axis2.has(property_arguments.getString("property-name"))) {
                        result = data_axis2.get(property_arguments.getString("property-name"));
                    }
                    JSONObject json_result = new JSONObject();
                    json_result.put(property_arguments.getString("property-name"), result);
                    this.debugInterface.getPortListenWriter().println(json_result.toString());
                    this.debugInterface.getPortListenWriter().flush();
                } else if (propertyContext.equals("synapse") || propertyContext.equals("default")) {
                    JSONObject data_synapse = new JSONObject(((Axis2MessageContext)this.synCtx).getProperties());
                    JSONObject result = null;
                    if (data_synapse.has(property_arguments.getString("property-name"))) {
                        result = data_synapse.getJSONObject(property_arguments.getString("property-name"));
                    }
                    JSONObject json_result = new JSONObject();
                    json_result.put(property_arguments.getString("property-name"), (Object)result);
                    this.debugInterface.getPortListenWriter().println(json_result.toString());
                    this.debugInterface.getPortListenWriter().flush();
                } else if (propertyContext.equals("axis2-client")) {
                    JSONObject data_axis2 = new JSONObject(((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getOptions().getProperties());
                    Object result = null;
                    if (data_axis2.has(property_arguments.getString("property-name"))) {
                        result = data_axis2.get(property_arguments.getString("property-name"));
                    }
                    JSONObject json_result = new JSONObject();
                    json_result.put(property_arguments.getString("property-name"), result);
                    this.debugInterface.getPortListenWriter().println(json_result.toString());
                    this.debugInterface.getPortListenWriter().flush();
                } else if (propertyContext.equals("transport")) {
                    JSONObject data_axis2 = new JSONObject((Map)((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS"));
                    Object result = null;
                    if (data_axis2.has(property_arguments.getString("property-name"))) {
                        result = data_axis2.get(property_arguments.getString("property-name"));
                    }
                    JSONObject json_result = new JSONObject();
                    json_result.put(property_arguments.getString("property-name"), result);
                    this.debugInterface.getPortListenWriter().println(json_result.toString());
                    this.debugInterface.getPortListenWriter().flush();
                } else if (propertyContext.equals("operation")) {
                    JSONObject data_axis2 = new JSONObject(((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getOperationContext().getProperties());
                    Object result = null;
                    if (data_axis2.has(property_arguments.getString("property-name"))) {
                        result = data_axis2.get(property_arguments.getString("property-name"));
                    }
                    JSONObject json_result = new JSONObject();
                    json_result.put(property_arguments.getString("property-name"), result);
                    this.debugInterface.getPortListenWriter().println(json_result.toString());
                    this.debugInterface.getPortListenWriter().flush();
                } else if (propertyContext.equals("wire")) {
                    SynapseWireLogHolder synapseWireLogHolder = this.synCtx != null ? (SynapseWireLogHolder)((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getProperty("synapse.wire.log.holder") : null;
                    JSONObject wireLog = this.createWireLogResponse(synapseWireLogHolder);
                    this.debugInterface.getPortListenWriter().println(wireLog.toString());
                    this.debugInterface.getPortListenWriter().flush();
                    log.debug((Object)("wirelog sent to devstudio - " + wireLog.toString()));
                }
            }
        }
        catch (JSONException ex) {
            log.error((Object)("Failed to acquire property in the scope: " + propertyContext), (Throwable)ex);
        }
    }

    private JSONObject createWireLogResponse(SynapseWireLogHolder synapseWireLogHolder) throws JSONException {
        JSONObject wireLog = new JSONObject();
        JSONArray mediatorLogs = new JSONArray();
        HashMap<JSONObject, SynapseBackEndWireLogs> wireLogsMap = new HashMap<JSONObject, SynapseBackEndWireLogs>();
        if (synapseWireLogHolder != null) {
            this.constructWireLogMap(synapseWireLogHolder, wireLogsMap);
        }
        this.fillWireLogJsonArray(wireLogsMap, mediatorLogs);
        wireLog.put("wirelogs", (Object)mediatorLogs);
        return wireLog;
    }

    private void fillWireLogJsonArray(Map<JSONObject, SynapseBackEndWireLogs> wireLogsMap, JSONArray mediatorLogs) throws JSONException {
        for (SynapseBackEndWireLogs synapseBackEndWireLog : wireLogsMap.values()) {
            JSONObject mediatorId = new JSONObject(synapseBackEndWireLog.getMediatorID());
            JSONObject backEndWireLogEntry = new JSONObject();
            backEndWireLogEntry.put("mediatorId", (Object)mediatorId);
            JSONObject backEndWireLogs = new JSONObject();
            backEndWireLogs.put("requestWireLog", (Object)synapseBackEndWireLog.getRequestWireLog());
            backEndWireLogs.put("responseWireLog", (Object)synapseBackEndWireLog.getResponseWireLog());
            backEndWireLogEntry.put("wireLogEntry", (Object)backEndWireLogs);
            mediatorLogs.put((Object)backEndWireLogEntry);
        }
    }

    private void constructWireLogMap(SynapseWireLogHolder wireLogHolder, Map<JSONObject, SynapseBackEndWireLogs> wireLogsMap) throws JSONException {
        JSONObject reqResMedId = new JSONObject();
        reqResMedId.put("mediation-component", (Object)"requestResponse");
        if (wireLogHolder.getProxyName() != null && !wireLogHolder.getProxyName().isEmpty()) {
            reqResMedId.put("type", (Object)"proxy");
            reqResMedId.put("proxy-key", (Object)wireLogHolder.getProxyName());
        } else if (wireLogHolder.getApiName() != null && !wireLogHolder.getApiName().isEmpty()) {
            reqResMedId.put("type", (Object)"api");
            reqResMedId.put("api-key", (Object)wireLogHolder.getApiName());
            if (wireLogHolder.getResourceUrlString() != null && !wireLogHolder.getResourceUrlString().isEmpty()) {
                reqResMedId.put("restResourceUrlString", (Object)wireLogHolder.getResourceUrlString());
            }
        }
        SynapseBackEndWireLogs reqResWireLog = wireLogsMap.get(reqResMedId);
        if (reqResWireLog == null) {
            reqResWireLog = new SynapseBackEndWireLogs();
            reqResWireLog.setMediatorID(reqResMedId.toString());
        }
        if (reqResWireLog.getRequestWireLog() == null || reqResWireLog.getRequestWireLog().isEmpty()) {
            reqResWireLog.appendRequestWireLog(wireLogHolder.getRequestWireLog());
        }
        if (reqResWireLog.getResponseWireLog() == null || reqResWireLog.getResponseWireLog().isEmpty()) {
            reqResWireLog.appendResponseWireLog(wireLogHolder.getResponseWireLog());
        }
        wireLogsMap.put(reqResMedId, reqResWireLog);
        for (SynapseBackEndWireLogs synapseBackEndWireLog : wireLogHolder.getBackEndRequestResponse().values()) {
            JSONObject mediatorId = new JSONObject(synapseBackEndWireLog.getMediatorID());
            JSONObject dummyId = new JSONObject("{ \"dummyID\" : \"dummy\"}");
            if (mediatorId == null || mediatorId.toString().equalsIgnoreCase(dummyId.toString())) continue;
            SynapseBackEndWireLogs backEndWireLogEntry = wireLogsMap.get(mediatorId);
            if (backEndWireLogEntry == null) {
                backEndWireLogEntry = synapseBackEndWireLog;
            } else {
                if (backEndWireLogEntry.getRequestWireLog() == null || backEndWireLogEntry.getRequestWireLog().isEmpty()) {
                    backEndWireLogEntry.appendRequestWireLog(synapseBackEndWireLog.getRequestWireLog());
                }
                if (backEndWireLogEntry.getResponseWireLog() == null || backEndWireLogEntry.getResponseWireLog().isEmpty()) {
                    backEndWireLogEntry.appendResponseWireLog(synapseBackEndWireLog.getResponseWireLog());
                }
            }
            wireLogsMap.put(mediatorId, backEndWireLogEntry);
        }
    }

    protected JSONObject getAxis2Properties() throws JSONException, IOException {
        SOAPHeader header;
        Map scopePropertyMap;
        JSONObject result = new JSONObject();
        result.put("To", (Object)(this.synCtx.getTo() != null ? this.synCtx.getTo().getAddress() : EMPTY_STRING));
        result.put("From", (Object)(this.synCtx.getFrom() != null ? this.synCtx.getFrom().getAddress() : EMPTY_STRING));
        result.put("WSAction", (Object)(this.synCtx.getWSAAction() != null ? this.synCtx.getWSAAction() : EMPTY_STRING));
        result.put("SOAPAction", (Object)(this.synCtx.getSoapAction() != null ? this.synCtx.getSoapAction() : EMPTY_STRING));
        result.put("ReplyTo", (Object)(this.synCtx.getReplyTo() != null ? this.synCtx.getReplyTo().getAddress() : EMPTY_STRING));
        result.put("MessageID", (Object)(this.synCtx.getMessageID() != null ? this.synCtx.getMessageID() : EMPTY_STRING));
        result.put("Direction", (Object)(this.synCtx.isResponse() ? "response" : "request"));
        Object messageTypeProperty = ((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getProperty("messageType");
        if (messageTypeProperty != null && ((String)messageTypeProperty).contains("json")) {
            InputStream jsonPayloadStream = JsonUtil.getJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)this.synCtx).getAxis2MessageContext());
            if (jsonPayloadStream != null) {
                StringWriter writer = new StringWriter();
                String encoding = null;
                IOUtils.copy((InputStream)jsonPayloadStream, (Writer)writer, encoding);
                String jsonPayload = writer.toString();
                result.put("Envelope", jsonPayload != null ? jsonPayload : this.synCtx.getEnvelope().toString());
            } else {
                result.put("Envelope", (Object)(this.synCtx.getEnvelope() != null ? this.synCtx.getEnvelope().toString() : EMPTY_STRING));
            }
        } else {
            result.put("Envelope", (Object)(this.synCtx.getEnvelope() != null ? this.synCtx.getEnvelope().toString() : EMPTY_STRING));
        }
        String axis2MessageContextKey = this.getAxis2MessagePropertiesKey(((Axis2MessageContext)this.synCtx).getAxis2MessageContext());
        if (this.addedPropertyValuesMap.containsKey(axis2MessageContextKey) && (scopePropertyMap = (Map)this.addedPropertyValuesMap.get(axis2MessageContextKey)).containsKey("axis2")) {
            Set propertyKeySet = (Set)scopePropertyMap.get("axis2");
            for (String key : propertyKeySet) {
                result.put(key, ((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getProperty(key));
            }
        }
        JSONObject soapHeader = new JSONObject();
        if (this.synCtx.getEnvelope() != null && (header = this.synCtx.getEnvelope().getHeader()) != null) {
            Iterator iter = header.examineAllHeaderBlocks();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof SOAPHeaderBlock) {
                    SOAPHeaderBlock headerBlk = (SOAPHeaderBlock)o;
                    soapHeader.put(headerBlk.getLocalName(), (Object)headerBlk.getText());
                    continue;
                }
                if (!(o instanceof OMElement)) continue;
                OMElement headerElem = (OMElement)o;
                soapHeader.put(headerElem.getLocalName(), (Object)headerElem.getText());
            }
        }
        result.put("SoapHeader", (Object)soapHeader);
        result.put("ExcessTransportHeaders", ((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getProperty("EXCESS_TRANSPORT_HEADERS"));
        result.put("MessageType", ((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getProperty("messageType"));
        result.put("ContentType", ((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getProperty("ContentType"));
        return result;
    }

    public void addMediationFlowPointProperty(String propertyContext, JSONObject property_arguments, boolean isActionSet) {
        try {
            String propertyKey = property_arguments.getString("property-name");
            if (isActionSet) {
                String propertyValue = property_arguments.getString("property-value");
                if (propertyContext.equals("default") || propertyContext.equals("synapse")) {
                    this.synCtx.setProperty(propertyKey, propertyValue);
                } else if (propertyContext.equals("axis2") && this.synCtx instanceof Axis2MessageContext) {
                    Axis2MessageContext axis2smc = (Axis2MessageContext)this.synCtx;
                    org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                    this.setAxis2Property(propertyKey, propertyValue, axis2MessageCtx);
                    if ("messageType".equalsIgnoreCase(propertyKey)) {
                        this.setAxis2Property("ContentType", propertyValue, axis2MessageCtx);
                        Object o = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
                        Map headers = (Map)o;
                        if (headers != null) {
                            headers.remove("Content-Type");
                            headers.put("Content-Type", propertyValue);
                        }
                    }
                } else if (propertyContext.equals("axis2-client") && this.synCtx instanceof Axis2MessageContext) {
                    Axis2MessageContext axis2smc = (Axis2MessageContext)this.synCtx;
                    org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                    axis2MessageCtx.getOptions().setProperty(propertyKey, (Object)propertyValue);
                } else if (propertyContext.equals("transport") && this.synCtx instanceof Axis2MessageContext) {
                    HashMap<String, String> headersMap;
                    Axis2MessageContext axis2smc = (Axis2MessageContext)this.synCtx;
                    org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                    Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
                    if (headers != null && headers instanceof Map) {
                        headersMap = (HashMap<String, String>)headers;
                        headersMap.put(propertyKey, propertyValue);
                    }
                    if (headers == null) {
                        headersMap = new HashMap<String, String>();
                        headersMap.put(propertyKey, propertyValue);
                        axis2MessageCtx.setProperty("TRANSPORT_HEADERS", headersMap);
                    }
                } else if (propertyContext.equals("operation") && this.synCtx instanceof Axis2MessageContext) {
                    Axis2MessageContext axis2smc = (Axis2MessageContext)this.synCtx;
                    axis2smc.getAxis2MessageContext().getOperationContext().setProperty(propertyKey, (Object)propertyValue);
                }
            } else if (propertyContext == null || "default".equals(propertyContext) || "synapse".equals(propertyContext)) {
                Set pros = this.synCtx.getPropertyKeySet();
                if (pros != null) {
                    pros.remove(propertyKey);
                }
            } else if (propertyContext.equals("axis2") && this.synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)this.synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.removeProperty(propertyKey);
            } else if (propertyContext.equals("axis2-client") && this.synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)this.synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.getOptions().setProperty(propertyKey, (Object)EMPTY_STRING);
            } else if (propertyContext.equals("transport") && this.synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)this.synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
                if (headers != null && headers instanceof Map) {
                    Map headersMap = (Map)headers;
                    headersMap.remove(propertyKey);
                }
            } else if (propertyContext.equals("operation") && this.synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)this.synCtx;
                axis2smc.getAxis2MessageContext().getOperationContext().removeProperty(propertyKey);
            } else {
                log.error((Object)("Failed to set or remove property in the scope " + propertyContext));
                this.advertiseCommandResponse(this.createDebugCommandResponse(false, "unable to alter message context property").toString());
            }
        }
        catch (JSONException e) {
            log.error((Object)("Failed to set or remove property in the scope " + propertyContext), (Throwable)e);
            this.advertiseCommandResponse(this.createDebugCommandResponse(false, "unable to alter message context property").toString());
        }
        this.advertiseCommandResponse(this.createDebugCommandResponse(true, null).toString());
    }

    private void setAxis2Property(String propertyKey, String propertyValue, org.apache.axis2.context.MessageContext axis2MessageCtx) {
        switch (propertyKey) {
            case "To": {
                axis2MessageCtx.setTo(new EndpointReference(propertyValue));
                break;
            }
            case "From": {
                axis2MessageCtx.setFrom(new EndpointReference(propertyValue));
                break;
            }
            case "WSAction": {
                axis2MessageCtx.setWSAAction(propertyValue);
                break;
            }
            case "SOAPAction": {
                axis2MessageCtx.setSoapAction(propertyValue);
                break;
            }
            case "ReplyTo": {
                axis2MessageCtx.setReplyTo(new EndpointReference(propertyValue));
                break;
            }
            case "MessageID": {
                axis2MessageCtx.setMessageID(propertyValue);
                break;
            }
            case "MessageType": {
                axis2MessageCtx.setProperty("messageType", (Object)propertyValue);
                break;
            }
            case "Direction": {
                if ("response".equalsIgnoreCase(propertyValue)) {
                    this.synCtx.setResponse(true);
                    break;
                }
                if ("request".equalsIgnoreCase(propertyValue)) {
                    this.synCtx.setResponse(false);
                    break;
                }
                log.warn((Object)("unknown axis2 direction : " + propertyValue));
                break;
            }
            default: {
                Set<String> axis2PropertyKeySet;
                Map scopePropertiesMap;
                axis2MessageCtx.setProperty(propertyKey, (Object)propertyValue);
                String axis2MessageCtxKey = this.getAxis2MessagePropertiesKey(axis2MessageCtx);
                if (this.addedPropertyValuesMap.containsKey(axis2MessageCtxKey)) {
                    scopePropertiesMap = (Map)this.addedPropertyValuesMap.get(axis2MessageCtxKey);
                    axis2PropertyKeySet = scopePropertiesMap.containsKey("axis2") ? (Set)scopePropertiesMap.get("axis2") : new HashSet();
                    axis2PropertyKeySet.add(propertyKey);
                } else {
                    scopePropertiesMap = new HashMap();
                    axis2PropertyKeySet = new HashSet<String>();
                    axis2PropertyKeySet.add(propertyKey);
                }
                scopePropertiesMap.put("axis2", axis2PropertyKeySet);
                this.addedPropertyValuesMap.put(axis2MessageCtxKey, scopePropertiesMap);
            }
        }
    }

    private String getAxis2MessagePropertiesKey(org.apache.axis2.context.MessageContext axis2MessageCtx) {
        String axis2MessageCtxKey = axis2MessageCtx.toString();
        return axis2MessageCtxKey;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.synEnv.isDebuggerEnabled()) {
            try {
                SynapseWireLogHolder synapseWireLogHolder = (SynapseWireLogHolder)arg;
                JSONObject wireLog = this.createWireLogResponse(synapseWireLogHolder);
                this.debugInterface.getPortSendWriter().println(wireLog);
                this.debugInterface.getPortSendWriter().flush();
                log.debug((Object)"wire log event got triggered and sent the event to developer studio");
            }
            catch (JSONException ex) {
                log.error((Object)"Failed to create debug event in JSON format", (Throwable)ex);
            }
        }
    }

    static {
        debugManagerInstance = null;
        debugTCPListener = null;
        log = LogFactory.getLog(SynapseDebugManager.class);
    }
}

