/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SynapseDebugInterface {
    private int listernPortNumber;
    private int sendPortNumber;
    private ServerSocket listenSocket;
    private ServerSocket sendSocket;
    private PrintWriter sendSocketWriter;
    private BufferedReader listenSocketReader;
    private PrintWriter listenSocketWriter;
    private static final Log log = LogFactory.getLog(SynapseDebugInterface.class);
    private static SynapseDebugInterface debugInterfaceInstance = null;
    private Semaphore runtimeSuspensionSem;
    private static final int SOCKET_TIMEOUT_INTERVAL = 60000;
    private volatile Exception uncaughtException;

    public void init(int listenPortParam, int sendPortParam) throws InterruptedException, IOException {
        log.info((Object)("Listen on ports : Command " + listenPortParam + " - Event " + sendPortParam));
        this.runtimeSuspensionSem = new Semaphore(0);
        Thread channelCreator = new Thread(new AsynchronousChannelCreator(listenPortParam, sendPortParam, this.runtimeSuspensionSem));
        channelCreator.start();
        this.runtimeSuspensionSem.acquire();
        if (this.uncaughtException != null) {
            throw (IOException)this.uncaughtException;
        }
    }

    public void createDebugChannels(int listenPortParam, int sendPortParam) throws IOException {
        this.listernPortNumber = listenPortParam;
        this.sendPortNumber = sendPortParam;
        this.listenSocket = new ServerSocket(this.listernPortNumber);
        this.sendSocket = new ServerSocket(this.sendPortNumber);
        this.listenSocket.setSoTimeout(60000);
        this.sendSocket.setSoTimeout(60000);
        Socket listenClientSocket = this.listenSocket.accept();
        Socket sendClientSocket = this.sendSocket.accept();
        log.info((Object)"Debug connection created");
        this.sendSocketWriter = new PrintWriter(sendClientSocket.getOutputStream());
        this.listenSocketReader = new BufferedReader(new InputStreamReader(listenClientSocket.getInputStream()));
        this.listenSocketWriter = new PrintWriter(listenClientSocket.getOutputStream());
    }

    public static SynapseDebugInterface getInstance() {
        if (debugInterfaceInstance == null) {
            debugInterfaceInstance = new SynapseDebugInterface();
        }
        return debugInterfaceInstance;
    }

    public void closeConnection() {
        try {
            if (this.getOpenedPortListen() != null && !this.getOpenedPortListen().isClosed()) {
                this.getOpenedPortListen().close();
            }
            if (this.getOpenedPortSend() != null && !this.getOpenedPortListen().isClosed()) {
                this.getOpenedPortSend().close();
            }
            log.info((Object)"Debug connection closed");
        }
        catch (IOException e) {
            log.error((Object)"Failed close communication channels to the external debugger", (Throwable)e);
        }
    }

    public ServerSocket getOpenedPortListen() {
        return this.listenSocket;
    }

    public ServerSocket getOpenedPortSend() {
        return this.sendSocket;
    }

    public PrintWriter getPortSendWriter() {
        return this.sendSocketWriter;
    }

    public BufferedReader getPortListenReader() {
        return this.listenSocketReader;
    }

    public PrintWriter getPortListenWriter() {
        return this.listenSocketWriter;
    }

    public void setUncaughtException(Exception ex) {
        this.uncaughtException = ex;
    }

    class AsynchronousChannelCreator
    implements Runnable {
        private int listenPortParam;
        private int sendPortParam;
        private Semaphore runtimeSuspendSem;

        public AsynchronousChannelCreator(int listenPortParam, int sendPortParam, Semaphore runtimeSuspendSem) {
            this.listenPortParam = listenPortParam;
            this.sendPortParam = sendPortParam;
            this.runtimeSuspendSem = runtimeSuspendSem;
        }

        @Override
        public void run() {
            try {
                SynapseDebugInterface.this.createDebugChannels(this.listenPortParam, this.sendPortParam);
            }
            catch (IOException ex) {
                SynapseDebugInterface.this.setUncaughtException(ex);
                log.error((Object)"Failed create communication channels to the external debugger", (Throwable)ex);
            }
            finally {
                this.runtimeSuspendSem.release();
            }
        }
    }
}

