/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import java.util.TimerTask;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.aspects.flow.statistics.collectors.CallbackStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.commons.logger.ContextAwareLogger;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.core.axis2.AsyncCallback;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.util.ConcurrencyThrottlingUtils;

public class TimeoutHandler
extends TimerTask {
    private static final Log log = LogFactory.getLog(TimeoutHandler.class);
    private final Map callbackStore;
    private final Object lock = new Object();
    private boolean alreadyExecuting = false;
    private long globalTimeout = 86400000L;
    private static final String SEND_TIMEOUT_MESSAGE = "Send timeout";
    private ServerContextInformation contextInfo = null;

    public TimeoutHandler(Map callbacks, ServerContextInformation contextInfo) {
        this.callbackStore = callbacks;
        this.contextInfo = contextInfo;
        this.globalTimeout = SynapseConfigUtils.getGlobalTimeoutInterval();
        log.info((Object)("This engine will expire all callbacks after " + SynapseConstants.ENDPOINT_TIMEOUT_TYPE.GLOBAL_TIMEOUT.toString() + ": " + this.globalTimeout / 1000L + " seconds, irrespective of the timeout action, after the specified or optional timeout"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.alreadyExecuting) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.alreadyExecuting = true;
            try {
                this.processCallbacks();
            }
            catch (Exception ex) {
                log.warn((Object)"Exception occurred while processing callbacks", (Throwable)ex);
            }
            catch (Error ex) {
                log.warn((Object)"Error occurred while processing callbacks", (Throwable)ex);
            }
            finally {
                this.alreadyExecuting = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCallbacks() {
        SALSessions.getInstance().clearSessions();
        Map map = this.callbackStore;
        synchronized (map) {
            if (this.callbackStore.size() > 0) {
                AsyncCallback callback;
                long currentTime = this.currentTime();
                ArrayList toRemove = new ArrayList();
                for (Object key : this.callbackStore.keySet()) {
                    FaultHandler faultHandler;
                    SOAPEnvelope soapEnvelope;
                    callback = (AsyncCallback)this.callbackStore.get(key);
                    if (callback == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("There is no callback for key :" + key));
                        continue;
                    }
                    if (callback.getTimeOutOn() > currentTime) continue;
                    AsyncCallback asyncCallback = callback;
                    synchronized (asyncCallback) {
                        if (callback.isMarkedForRemoval()) {
                            continue;
                        }
                        callback.setMarkedForRemoval();
                        toRemove.add(key);
                    }
                    if (!"true".equals(callback.getSynapseOutMsgCtx().getProperty("OUT_ONLY"))) {
                        org.apache.axis2.context.MessageContext axis2MessageContext = callback.getAxis2OutMsgCtx();
                        ContextAwareLogger.getLogger((org.apache.axis2.context.MessageContext)axis2MessageContext, (Log)log, (boolean)true).warn((Object)("Expiring message ID : " + key + "; dropping message after " + callback.getTimeoutType().toString() + " of : " + callback.getTimeoutDuration() / 1000L + " seconds for " + this.getEndpointLogMessage(callback.getSynapseOutMsgCtx(), callback.getAxis2OutMsgCtx()) + ", " + this.getServiceLogMessage(callback.getSynapseOutMsgCtx()) + "Correlation ID : " + callback.getAxis2OutMsgCtx().getProperty("correlation_id")));
                    }
                    if (callback.getTimeOutAction() == 100) continue;
                    MessageContext msgContext = callback.getSynapseOutMsgCtx();
                    org.apache.axis2.context.MessageContext axis2MessageContext = callback.getAxis2OutMsgCtx();
                    ((Axis2MessageContext)msgContext).getAxis2MessageContext().removeProperty("pass-through.pipe");
                    msgContext.setProperty("ERROR_CODE", 101504);
                    msgContext.setProperty("ERROR_MESSAGE", SEND_TIMEOUT_MESSAGE);
                    if (msgContext.isSOAP11()) {
                        soapEnvelope = OMAbstractFactory.getSOAP11Factory().createSOAPEnvelope();
                        soapEnvelope.addChild((OMNode)OMAbstractFactory.getSOAP11Factory().createSOAPBody());
                    } else {
                        soapEnvelope = OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope();
                        soapEnvelope.addChild((OMNode)OMAbstractFactory.getSOAP12Factory().createSOAPBody());
                    }
                    try {
                        msgContext.setEnvelope(soapEnvelope);
                    }
                    catch (Throwable ex) {
                        ContextAwareLogger.getLogger((org.apache.axis2.context.MessageContext)axis2MessageContext, (Log)log, (boolean)true).error((Object)"Exception or Error occurred resetting SOAP Envelope", ex);
                        continue;
                    }
                    Stack<FaultHandler> faultStack = msgContext.getFaultStack();
                    if (faultStack.isEmpty() || (faultHandler = faultStack.pop()) == null) continue;
                    try {
                        faultHandler.handleFault(msgContext);
                    }
                    catch (Throwable ex) {
                        ContextAwareLogger.getLogger((org.apache.axis2.context.MessageContext)axis2MessageContext, (Log)log, (boolean)true).warn((Object)"Exception or Error occurred while executing the fault handler", ex);
                    }
                }
                for (Object key : toRemove) {
                    callback = (AsyncCallback)this.callbackStore.get(key);
                    if (callback == null) continue;
                    MessageContext synapseOutMsgCtx = callback.getSynapseOutMsgCtx();
                    ConcurrencyThrottlingUtils.decrementConcurrencyThrottleAccessController(synapseOutMsgCtx);
                    this.callbackStore.remove(key);
                    if (!RuntimeStatisticCollector.isStatisticsEnabled()) continue;
                    CallbackStatisticCollector.callbackCompletionEvent(callback.getSynapseOutMsgCtx(), (String)key);
                }
            }
        }
    }

    private long currentTime() {
        return System.currentTimeMillis();
    }

    private String getEndpointLogMessage(MessageContext synCtx, org.apache.axis2.context.MessageContext axisCtx) {
        return synCtx.getProperty("last_endpoint") + ", URI : " + axisCtx.getTo().getAddress();
    }

    private String getServiceLogMessage(MessageContext synCtx) {
        Object proxyName = synCtx.getProperty("proxy.name");
        if (proxyName != null) {
            return "Received through Proxy service : " + proxyName;
        }
        Object apiName = synCtx.getProperty("SYNAPSE_REST_API");
        if (apiName != null) {
            return "Received through API : " + apiName;
        }
        Object inboundEndpointName = synCtx.getProperty("inbound.endpoint.name");
        if (inboundEndpointName != null) {
            return "Received through Inbound Endpoint : " + inboundEndpointName;
        }
        return "Received through an entry point other than a proxy, an api or an inbound endpoint ";
    }
}

