/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.carbonext.TenantInfoConfigurator;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.core.axis2.ResponseState;
import org.apache.synapse.util.logging.LoggingUtils;

public class SynapseMessageReceiver
implements MessageReceiver {
    private static final Log log = LogFactory.getLog(SynapseMessageReceiver.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(org.apache.axis2.context.MessageContext mc) throws AxisFault {
        boolean traceOrDebugOn;
        MessageContext synCtx = MessageContextCreatorForAxis2.getSynapseMessageContext(mc);
        boolean traceOn = synCtx.getMainSequence().getTraceState() == 1;
        boolean bl = traceOrDebugOn = traceOn || log.isDebugEnabled();
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Synapse received a new message for message mediation...");
            this.traceOrDebug(traceOn, "Received To: " + (mc.getTo() != null ? mc.getTo().getAddress() : "null"));
            this.traceOrDebug(traceOn, "SOAPAction: " + (mc.getSoapAction() != null ? mc.getSoapAction() : "null"));
            this.traceOrDebug(traceOn, "WSA-Action: " + (mc.getWSAAction() != null ? mc.getWSAAction() : "null"));
            if (traceOn && trace.isTraceEnabled()) {
                String[] cids = null;
                try {
                    cids = mc.getAttachmentMap().getAllContentIDs();
                }
                catch (Exception ex) {
                    mc.setAttachmentMap(null);
                    log.error((Object)"Synapse encountered an exception when reading attachments from bytes stream. Hence Attachments map is dropped from the message context.", (Throwable)ex);
                }
                if (cids != null && cids.length > 0) {
                    for (String cid : cids) {
                        trace.trace((Object)("Attachment : " + cid));
                    }
                }
                trace.trace((Object)("Envelope : " + mc.getEnvelope()));
            }
        }
        Log serviceLog = LogFactory.getLog((String)"SERVICE_LOGGER.__SynapseService");
        ((Axis2MessageContext)synCtx).setServiceLog(serviceLog);
        synCtx.setProperty("IsClientDoingREST", mc.isDoingREST());
        synCtx.setProperty("IsClientDoingSOAP11", mc.isSOAP11());
        synCtx.setProperty("correlation_id", mc.getProperty("correlation_id"));
        TenantInfoConfigurator configurator = synCtx.getEnvironment().getTenantInfoConfigurator();
        if (configurator != null) {
            configurator.extractTenantInfo(synCtx);
        }
        try {
            synCtx.setProperty("__SYNAPSE_RESPONSE_STATE__", new ResponseState());
            synCtx.getEnvironment().injectMessage(synCtx);
        }
        catch (SynapseException syne) {
            if (!synCtx.getFaultStack().isEmpty()) {
                this.warn(traceOn, "Executing fault handler due to exception encountered", synCtx);
                synCtx.getFaultStack().pop().handleFault(synCtx, syne);
            } else {
                this.warn(traceOn, "Exception encountered but no fault handler found - message dropped", synCtx);
            }
        }
        finally {
            SynapseMessageReceiver.doPostInjectUpdates(synCtx);
        }
    }

    private void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }

    private void warn(boolean traceOn, String msg, MessageContext msgContext) {
        String formattedMsg = LoggingUtils.getFormattedLog(msgContext, msg);
        if (traceOn) {
            trace.warn((Object)formattedMsg);
        }
        if (log.isDebugEnabled()) {
            log.warn((Object)formattedMsg);
        }
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().warn((Object)msg);
        }
    }

    public static void doPostInjectUpdates(MessageContext messageContext) {
        org.apache.axis2.context.MessageContext axis2Ctx = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        if (axis2Ctx.isPropertyTrue("FORCE_SC_ACCEPTED") && Axis2Sender.preventMultipleResponses(messageContext)) {
            throw new SynapseException("Trying to send a 202 Accepted response to an already responded client request");
        }
    }
}

