/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.synapse.SynapseConstants;

public class SynapseDispatcher
extends AbstractDispatcher {
    public static final String NAME = "SynapseDispatcher";

    public void initDispatcher() {
        QName qn = new QName("http://synapse.apache.org", NAME);
        HandlerDescription hd = new HandlerDescription(qn.getLocalPart());
        super.init(hd);
    }

    public AxisService findService(MessageContext mc) throws AxisFault {
        AxisConfiguration ac = mc.getConfigurationContext().getAxisConfiguration();
        return ac.getService("__SynapseService");
    }

    public AxisOperation findOperation(AxisService svc, MessageContext mc) throws AxisFault {
        AxisOperation operation = svc.getOperation(SynapseConstants.SYNAPSE_OPERATION_NAME);
        if (operation == null && mc.getAxisService() != null) {
            operation = this.processOperationValidation(svc);
        }
        return operation;
    }

    private AxisOperation processOperationValidation(AxisService svc) {
        Object operationObj = svc.getParameterValue("_default_mediate_operation_");
        if (operationObj != null) {
            return (AxisOperation)operationObj;
        }
        return null;
    }
}

