/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.Iterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.SynapseHandler;
import org.apache.synapse.aspects.flow.statistics.collectors.CallbackStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.carbonext.TenantInfoConfigurator;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessController;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessReplicator;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.AsyncCallback;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.core.axis2.TimeoutHandler;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.FailoverEndpoint;
import org.apache.synapse.endpoints.OAuthConfiguredHTTPEndpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.oauth.MessageCache;
import org.apache.synapse.endpoints.oauth.OAuthUtils;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.config.BaseConfiguration;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.util.ConcurrencyThrottlingUtils;
import org.apache.synapse.util.ResponseAcceptEncodingProcessor;

public class SynapseCallbackReceiver
extends CallbackReceiver {
    private static final Log log = LogFactory.getLog(SynapseCallbackReceiver.class);

    public SynapseCallbackReceiver(SynapseConfiguration synCfg, ServerContextInformation contextInformation) {
        TimeoutHandler timeoutHandler = new TimeoutHandler(this.callbackStore, contextInformation);
        Timer timeOutTimer = synCfg.getSynapseTimer();
        long timeoutHandlerInterval = SynapseConfigUtils.getTimeoutHandlerInterval();
        timeOutTimer.schedule((TimerTask)timeoutHandler, 0L, timeoutHandlerInterval);
    }

    public int getCallbackCount() {
        return this.callbackStore.size();
    }

    public void addCallback(String MsgID, AxisCallback callback) {
        this.callbackStore.put(MsgID, callback);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Callback added. Total callbacks waiting for : " + this.callbackStore.size()));
        }
        MessageContext synCtx = ((AsyncCallback)callback).getSynapseOutMsgCtx();
        if (RuntimeStatisticCollector.isStatisticsEnabled()) {
            CallbackStatisticCollector.addCallback(synCtx, MsgID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(org.apache.axis2.context.MessageContext messageCtx) throws AxisFault {
        String messageID = null;
        if (messageCtx.getProperty("HTTP_202_RECEIVED") != null && "true".equals(messageCtx.getProperty("HTTP_202_RECEIVED"))) {
            if (this.callbackStore.containsKey(messageCtx.getMessageID())) {
                AsyncCallback callback = (AsyncCallback)this.callbackStore.remove(messageCtx.getMessageID());
                if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                    CallbackStatisticCollector.callbackCompletionEvent(callback.getSynapseOutMsgCtx(), messageCtx.getMessageID());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallBack registered with Message id : " + messageCtx.getMessageID() + " removed from the callback store since we got an accepted Notification"));
                }
            }
            return;
        }
        if (messageCtx.getOptions() != null && messageCtx.getOptions().getRelatesTo() != null) {
            RelatesTo relatesTo;
            Options options = messageCtx.getOptions();
            if (options != null && (relatesTo = options.getRelatesTo()) != null) {
                messageID = relatesTo.getValue();
            }
        } else if (messageCtx.getProperty("Sandesha2SequenceKey") == null) {
            messageID = (String)messageCtx.getProperty("synapse.RelatesToForPox");
        }
        if (messageID != null) {
            RelatesTo[] relates;
            AsyncCallback callback = (AsyncCallback)this.callbackStore.remove(messageID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Callback removed for request message id : " + messageID + ". Pending callbacks count : " + this.callbackStore.size()));
            }
            if ((relates = messageCtx.getRelationships()) != null && relates.length > 1) {
                this.removeDuplicateRelatesTo(messageCtx, relates);
            }
            if (callback != null) {
                messageCtx.removeProperty("_INTERNAL_EXCEPTION_ORIGIN");
                MessageContext SynapseOutMsgCtx = callback.getSynapseOutMsgCtx();
                ConcurrencyThrottlingUtils.decrementConcurrencyThrottleAccessController(SynapseOutMsgCtx);
                boolean isMarkedForRemoval = false;
                AsyncCallback asyncCallback = callback;
                synchronized (asyncCallback) {
                    if (callback.isMarkedForRemoval()) {
                        isMarkedForRemoval = true;
                    } else {
                        callback.setMarkedForRemoval();
                    }
                }
                if (isMarkedForRemoval) {
                    this.handleNoCallback(messageID, messageCtx);
                    return;
                }
                if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                    CallbackStatisticCollector.updateParentsForCallback(SynapseOutMsgCtx, messageID);
                    this.handleMessage(messageID, messageCtx, SynapseOutMsgCtx, callback);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Finished handling the callback.");
                    }
                    CallbackStatisticCollector.reportCallbackHandlingCompletion(SynapseOutMsgCtx, messageID);
                } else {
                    this.handleMessage(messageID, messageCtx, SynapseOutMsgCtx, callback);
                }
            } else {
                this.handleNoCallback(messageID, messageCtx);
                messageCtx.removeProperty("_INTERNAL_EXCEPTION_ORIGIN");
            }
        } else if (!messageCtx.isPropertyTrue("SC_ACCEPTED")) {
            log.warn((Object)"Synapse received a response message without a message Id");
        }
    }

    private void handleMessage(String messageID, org.apache.axis2.context.MessageContext response, MessageContext synapseOutMsgCtx, AsyncCallback callback) throws AxisFault {
        Boolean isConcurrencyThrottleEnabled;
        TenantInfoConfigurator configurator = synapseOutMsgCtx.getEnvironment().getTenantInfoConfigurator();
        if (configurator != null) {
            configurator.applyTenantInfo(synapseOutMsgCtx);
        }
        if ((isConcurrencyThrottleEnabled = (Boolean)synapseOutMsgCtx.getProperty("synapse.concurrency.throttle")) != null && isConcurrencyThrottleEnabled.booleanValue()) {
            ConcurrentAccessController concurrentAccessController = (ConcurrentAccessController)synapseOutMsgCtx.getProperty("synapse.concurrent.access.controller");
            int available = concurrentAccessController.incrementAndGet();
            int concurrentLimit = concurrentAccessController.getLimit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Concurrency Throttle : Connection returned :: " + available + " of available of " + concurrentLimit + " connections"));
            }
            ConcurrentAccessReplicator concurrentAccessReplicator = (ConcurrentAccessReplicator)synapseOutMsgCtx.getProperty("synapse.concurrent.access.replicator");
            String throttleKey = (String)synapseOutMsgCtx.getProperty("synapse.concurrency.throttle.key");
            if (concurrentAccessReplicator != null) {
                concurrentAccessReplicator.replicate(throttleKey, Boolean.valueOf(true));
            }
        }
        MessageContext originalMC = MessageCache.getInstance().removeMessageContext(synapseOutMsgCtx.getMessageID());
        Object o = response.getProperty("SENDING_FAULT");
        if (o != null && Boolean.TRUE.equals(o)) {
            Stack<FaultHandler> faultStack;
            Pipe pipe = (Pipe)((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext().getProperty("pass-through.pipe");
            SourceConfiguration sourceConfiguration = (SourceConfiguration)((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext().getProperty("PASS_THROUGH_SOURCE_CONFIGURATION");
            if (pipe != null && pipe.isSerializationComplete() && sourceConfiguration != null) {
                NHttpServerConnection conn = (NHttpServerConnection)((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext().getProperty("pass-through.Source-Connection");
                Pipe newPipe = new Pipe((IOControl)conn, sourceConfiguration.getBufferFactory().getBuffer(), "source", (BaseConfiguration)sourceConfiguration);
                newPipe.setDiscardable(true);
                ((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext().setProperty("pass-through.pipe", (Object)newPipe);
            }
            if ((faultStack = synapseOutMsgCtx.getFaultStack()) != null && !faultStack.isEmpty()) {
                Integer errorCode;
                try {
                    synapseOutMsgCtx.getEnvelope().build();
                }
                catch (Exception x) {
                    synapseOutMsgCtx.setEnvelope(response.getEnvelope());
                }
                Exception e = (Exception)response.getProperty("ERROR_EXCEPTION");
                synapseOutMsgCtx.setProperty("SENDING_FAULT", Boolean.TRUE);
                synapseOutMsgCtx.setProperty("ERROR_CODE", response.getProperty("ERROR_CODE"));
                synapseOutMsgCtx.setProperty("ERROR_MESSAGE", response.getProperty("ERROR_MESSAGE"));
                synapseOutMsgCtx.setProperty("ERROR_DETAIL", response.getProperty("ERROR_DETAIL"));
                synapseOutMsgCtx.setProperty("ERROR_EXCEPTION", e);
                if (synapseOutMsgCtx.getEnvironment().isContinuationEnabled()) {
                    synapseOutMsgCtx.setContinuationEnabled(true);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[Failed Request Message ID : " + messageID + "] [New to be Retried Request Message ID : " + synapseOutMsgCtx.getMessageID() + "]"));
                }
                if ((errorCode = (Integer)response.getProperty("ERROR_CODE")) != null && errorCode == 101504 && callback.getTimeOutAction() == 101) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Synapse timed out for the request with Message ID : " + messageID + ". Ignoring fault handlers since the timeout action is DISCARD"));
                    }
                    faultStack.removeAllElements();
                } else {
                    faultStack.pop().handleFault(synapseOutMsgCtx, null);
                }
            }
        } else {
            Dispatcher dispatcher;
            Boolean isContinuationCall;
            Stack<FaultHandler> faultStack = synapseOutMsgCtx.getFaultStack();
            Endpoint successfulEndpoint = null;
            if (faultStack != null && !faultStack.isEmpty() && faultStack.peek() instanceof Endpoint) {
                successfulEndpoint = (Endpoint)((Object)faultStack.pop());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Synapse received an asynchronous response message");
                log.debug((Object)("Received To: " + (response.getTo() != null ? response.getTo().getAddress() : "null")));
                log.debug((Object)("SOAPAction: " + (response.getSoapAction() != null ? response.getSoapAction() : "null")));
                log.debug((Object)("WSA-Action: " + (response.getWSAAction() != null ? response.getWSAAction() : "null")));
                String[] cids = null;
                try {
                    cids = response.getAttachmentMap().getAllContentIDs();
                }
                catch (Exception ex) {
                    response.setAttachmentMap(null);
                    log.error((Object)"Synapse encountered an exception when reading attachments from bytes stream. Hence Attachments map is dropped from the message context.", (Throwable)ex);
                }
                if (cids != null && cids.length > 0) {
                    for (String cid : cids) {
                        log.debug((Object)("Attachment : " + cid));
                    }
                }
                log.debug((Object)("Body : \n" + response.getEnvelope()));
            }
            org.apache.axis2.context.MessageContext axisOutMsgCtx = ((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext();
            ResponseAcceptEncodingProcessor.process(response, axisOutMsgCtx);
            response.setServiceContext(null);
            response.setOperationContext(axisOutMsgCtx.getOperationContext());
            response.setAxisMessage(axisOutMsgCtx.getAxisOperation().getMessage("Out"));
            response.setServerSide(true);
            response.setProperty("correlation_id", axisOutMsgCtx.getProperty("correlation_id"));
            response.setProperty("synapse.isresponse", (Object)Boolean.TRUE);
            response.setProperty("TRANSPORT_OUT", axisOutMsgCtx.getProperty("TRANSPORT_OUT"));
            response.setProperty("OutTransportInfo", axisOutMsgCtx.getProperty("OutTransportInfo"));
            response.setTransportIn(axisOutMsgCtx.getTransportIn());
            response.setTransportOut(axisOutMsgCtx.getTransportOut());
            if (axisOutMsgCtx.isDoingMTOM() && (axisOutMsgCtx.getProperty("enableMTOM") == null || Boolean.getBoolean((String)axisOutMsgCtx.getProperty("enableMTOM")))) {
                response.setDoingMTOM(true);
                response.setProperty("enableMTOM", (Object)"true");
            }
            if (axisOutMsgCtx.isDoingSwA()) {
                response.setDoingSwA(true);
                response.setProperty("enableSwA", (Object)"true");
            }
            if (axisOutMsgCtx.getProperty("disableAddressingForOutMessages") != null) {
                response.setProperty("disableAddressingForOutMessages", axisOutMsgCtx.getProperty("disableAddressingForOutMessages"));
            } else {
                response.removeProperty("disableAddressingForOutMessages");
            }
            Object messageType = axisOutMsgCtx.getProperty("messageType");
            if (!"application/x-www-form-urlencoded".equals(messageType)) {
                response.setProperty("messageType", messageType);
            }
            if (axisOutMsgCtx.getMessageID() != null) {
                response.setRelationships(new RelatesTo[]{new RelatesTo(axisOutMsgCtx.getMessageID())});
            }
            response.setReplyTo(axisOutMsgCtx.getReplyTo());
            response.setFaultTo(axisOutMsgCtx.getFaultTo());
            if (axisOutMsgCtx.isPropertyTrue("IGNORE_SC_ACCEPTED")) {
                response.setProperty("FORCE_SC_ACCEPTED", (Object)"true");
            }
            this.removeUnwantedClientOptions(response);
            Axis2MessageContext synapseInMessageContext = new Axis2MessageContext(response, synapseOutMsgCtx.getConfiguration(), synapseOutMsgCtx.getEnvironment());
            synapseInMessageContext.setResponse(true);
            Object obj = synapseOutMsgCtx.getProperty("FORCE_ERROR_ON_SOAP_FAULT");
            String errorOnSOAPFault = (String)obj;
            boolean failOver = this.isChildOfFailOverEP(successfulEndpoint);
            if ("true".equals(errorOnSOAPFault) && successfulEndpoint != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"FORCE_ERROR_ON_SOAP_FAULT is true, checking for SOAPFault");
                }
                try {
                    RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)synapseInMessageContext.getAxis2MessageContext(), (boolean)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (synapseInMessageContext.getEnvelope() != null && synapseInMessageContext.getEnvelope().hasFault()) {
                    this.invokeHandlers(synapseInMessageContext);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("SOAPFault found in response message, forcing endpoint " + successfulEndpoint.getName() + " to fail"));
                    }
                    org.apache.axis2.context.MessageContext axis2OUTMC = ((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext();
                    NHttpServerConnection conn = (NHttpServerConnection)axis2OUTMC.getProperty("pass-through.Source-Connection");
                    SourceConfiguration sourceConfiguration = (SourceConfiguration)axis2OUTMC.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION");
                    if (conn != null && sourceConfiguration != null) {
                        Pipe pipe = new Pipe((IOControl)conn, sourceConfiguration.getBufferFactory().getBuffer(), "source", (BaseConfiguration)sourceConfiguration);
                        axis2OUTMC.setProperty("pass-through.pipe", (Object)pipe);
                    }
                    synapseOutMsgCtx.setProperty("SENDING_FAULT", Boolean.TRUE);
                    synapseOutMsgCtx.setProperty("ERROR_CODE", 500000);
                    for (Object key : synapseOutMsgCtx.getPropertyKeySet()) {
                        synapseInMessageContext.setProperty((String)key, synapseOutMsgCtx.getProperty((String)key));
                    }
                    if (failOver) {
                        ((FaultHandler)((Object)successfulEndpoint)).handleFault(synapseOutMsgCtx, null);
                    } else {
                        faultStack = synapseOutMsgCtx.getFaultStack();
                        if (faultStack != null) {
                            synapseInMessageContext.getFaultStack().addAll(faultStack);
                            ((FaultHandler)((Object)successfulEndpoint)).handleFault(synapseInMessageContext, null);
                        }
                    }
                    return;
                }
                successfulEndpoint.onSuccess();
                if (failOver) {
                    this.popFailOverEPFromFaultStack(synapseOutMsgCtx);
                }
            } else if (successfulEndpoint != null) {
                successfulEndpoint.onSuccess();
                if (failOver) {
                    this.popFailOverEPFromFaultStack(synapseOutMsgCtx);
                }
            }
            synapseInMessageContext.setTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
            synapseInMessageContext.setTracingState(synapseOutMsgCtx.getTracingState());
            synapseInMessageContext.setMessageFlowTracingState(synapseOutMsgCtx.getMessageFlowTracingState());
            for (Object key : synapseOutMsgCtx.getPropertyKeySet()) {
                synapseInMessageContext.setProperty((String)key, synapseOutMsgCtx.getProperty((String)key));
            }
            if (successfulEndpoint instanceof OAuthConfiguredHTTPEndpoint) {
                OAuthConfiguredHTTPEndpoint httpEndpoint = (OAuthConfiguredHTTPEndpoint)successfulEndpoint;
                if (originalMC != null && OAuthUtils.retryOnOAuthFailure(httpEndpoint, synapseInMessageContext, synapseOutMsgCtx)) {
                    httpEndpoint.retryCallWithNewToken(originalMC);
                    return;
                }
            }
            if ((isContinuationCall = (Boolean)synapseOutMsgCtx.getProperty("continuation.call")) != null && isContinuationCall.booleanValue()) {
                if (!synapseOutMsgCtx.isResponse()) {
                    synapseInMessageContext.setResponse(false);
                }
                Stack<ContinuationState> seqContinuationStates = synapseOutMsgCtx.getContinuationStateStack();
                for (int i = 0; i < seqContinuationStates.size(); ++i) {
                    synapseInMessageContext.pushContinuationState((ContinuationState)seqContinuationStates.get(i));
                }
                faultStack = synapseOutMsgCtx.getFaultStack();
                if (faultStack != null) {
                    synapseInMessageContext.getFaultStack().addAll(faultStack);
                }
            }
            if ((dispatcher = (Dispatcher)synapseOutMsgCtx.getProperty("synape.sal.endpoints.dispatcher")) != null && dispatcher.isServerInitiatedSession()) {
                dispatcher.updateSession(synapseInMessageContext);
            }
            try {
                synapseOutMsgCtx.getEnvironment().injectMessage(synapseInMessageContext);
            }
            catch (Exception syne) {
                Axis2MessageContext axis2smc = synapseInMessageContext;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.setProperty("HTTP_SC", (Object)500);
                axis2MessageCtx.setAttachmentMap(null);
                Stack<FaultHandler> stack = synapseInMessageContext.getFaultStack();
                if (stack != null && !stack.isEmpty()) {
                    stack.pop().handleFault(synapseInMessageContext, syne);
                }
                log.error((Object)("Synapse encountered an exception, No error handlers found - [Message Dropped]\n" + syne.getMessage()));
            }
        }
    }

    private void removeDuplicateRelatesTo(org.apache.axis2.context.MessageContext mc, RelatesTo[] relates) {
        int insertPos = 0;
        RelatesTo[] newRelates = new RelatesTo[relates.length];
        for (RelatesTo current : relates) {
            boolean found = false;
            for (int j = 0; j < newRelates.length && j < insertPos; ++j) {
                if (!newRelates[j].equals(current) && !newRelates[j].getValue().equals(current.getValue())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newRelates[insertPos++] = current;
        }
        RelatesTo[] trimmedRelates = new RelatesTo[insertPos];
        System.arraycopy(newRelates, 0, trimmedRelates, 0, insertPos);
        mc.setRelationships(trimmedRelates);
    }

    private void removeUnwantedClientOptions(org.apache.axis2.context.MessageContext msgCtx) {
        if (msgCtx.getOptions() != null && msgCtx.getOptions().getParent() != null && msgCtx.getOptions().getParent().getParent() != null) {
            Options clientOptions = msgCtx.getOptions().getParent().getParent();
            clientOptions.setProperty("rampartOutPolicy", null);
            clientOptions.setProperty("rampartInPolicy", null);
        }
    }

    private void registerFaultHandler(MessageContext synCtx) {
        ProxyService proxyService;
        String proxyName = (String)synCtx.getProperty("proxy.name");
        if (proxyName == null || "".equals(proxyName)) {
            synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
        }
        if ((proxyService = synCtx.getConfiguration().getProxyService(proxyName)) != null) {
            proxyService.registerFaultHandler(synCtx);
        }
    }

    private boolean invokeHandlers(MessageContext synCtx) {
        block4: {
            Iterator<SynapseHandler> iterator = synCtx.getEnvironment().getSynapseHandlers().iterator();
            if (!iterator.hasNext()) break block4;
            Boolean isContinuationCall = (Boolean)synCtx.getProperty("continuation.call");
            if (synCtx.isResponse() || isContinuationCall != null && isContinuationCall.booleanValue()) {
                while (iterator.hasNext()) {
                    SynapseHandler handler = iterator.next();
                    if (handler.handleResponseInFlow(synCtx)) continue;
                    return false;
                }
            } else {
                while (iterator.hasNext()) {
                    SynapseHandler handler = iterator.next();
                    if (handler.handleRequestInFlow(synCtx)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isChildOfFailOverEP(Endpoint endpoint) {
        Endpoint parentEndpoint;
        boolean failOver = false;
        if (endpoint instanceof AbstractEndpoint && (parentEndpoint = ((AbstractEndpoint)endpoint).getParentEndpoint()) != null && parentEndpoint instanceof FailoverEndpoint) {
            failOver = true;
        }
        return failOver;
    }

    private void popFailOverEPFromFaultStack(MessageContext synCtx) {
        FaultHandler o;
        Stack<FaultHandler> faultStack = synCtx.getFaultStack();
        if (faultStack != null && !faultStack.isEmpty() && (o = faultStack.peek()) instanceof FailoverEndpoint) {
            faultStack.pop();
        }
    }

    private void handleNoCallback(String messageID, org.apache.axis2.context.MessageContext messageCtx) {
        log.warn((Object)("Synapse received a response for the request with message Id : " + messageID + " and correlation_id : " + messageCtx.getProperty("correlation_id") + " But a callback is not registered (anymore) to process this response"));
    }
}

