/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.MessageHelper;

public class SOAPUtils {
    private static final Log log = LogFactory.getLog(SOAPUtils.class);
    private static String SOAP_ATR_ACTOR = "actor";
    private static String SOAP_ATR_ROLE = "role";
    private static String SOAP_ATR_MUST_UNDERSTAND = "mustUnderstand";
    private static final QName S11_FAULTCODE_VERSIONMISMATCH = new QName("http://schemas.xmlsoap.org/soap/envelope/", "VersionMismatch", "soapenv");
    private static final QName S12_FAULTCODE_VERSIONMISMATCH = new QName("http://www.w3.org/2003/05/soap-envelope", "VersionMismatch", "soapenv");
    private static final QName S11_FAULTCODE_MUSTUNDERSTAND = new QName("http://schemas.xmlsoap.org/soap/envelope/", "MustUnderstand", "soapenv");
    private static final QName S12_FAULTCODE_MUSTUNDERSTAND = new QName("http://www.w3.org/2003/05/soap-envelope", "MustUnderstand", "soapenv");
    private static final QName S11_FAULTCODE_CLIENT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client", "soapenv");
    private static final QName S12_FAULTCODE_SENDER = new QName("http://www.w3.org/2003/05/soap-envelope", "Sender", "soapenv");
    private static final QName S11_FAULTCODE_SERVER = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server", "soapenv");
    private static final QName S12_FAULTCODE_RECEIVER = new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver", "soapenv");
    private static final QName S12_FAULTCODE_DATAENCODINGUNKNOWN = new QName("http://www.w3.org/2003/05/soap-envelope", "DataEncodingUnknown", "soapenv");

    public static void convertSoapVersion(MessageContext axisOutMsgCtx, String soapVersionURI) throws AxisFault {
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            SOAPUtils.convertSOAP11toSOAP12(axisOutMsgCtx);
        } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapVersionURI)) {
            SOAPUtils.convertSOAP12toSOAP11(axisOutMsgCtx);
        } else {
            throw new SynapseException("Invalid soapVersionURI:" + soapVersionURI);
        }
    }

    public static void convertSOAP11toSOAP12(MessageContext axisOutMsgCtx) throws AxisFault {
        OMNode omNode;
        if (log.isDebugEnabled()) {
            log.debug((Object)"convert SOAP11 to SOAP12");
        }
        SOAPEnvelope clonedOldEnv = MessageHelper.cloneSOAPEnvelope(axisOutMsgCtx.getEnvelope());
        SOAPFactory soap12Factory = OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope newEnvelope = soap12Factory.getDefaultEnvelope();
        if (clonedOldEnv.getHeader() != null) {
            Iterator itr = clonedOldEnv.getHeader().getChildren();
            while (itr.hasNext()) {
                omNode = (OMNode)itr.next();
                if (omNode instanceof SOAPHeaderBlock) {
                    SOAPHeaderBlock soapHeader = (SOAPHeaderBlock)omNode;
                    SOAPHeaderBlock newSOAPHeader = soap12Factory.createSOAPHeaderBlock(soapHeader.getLocalName(), soapHeader.getNamespace());
                    Iterator allAttributes = soapHeader.getAllAttributes();
                    boolean hasAttributes = false;
                    while (allAttributes.hasNext()) {
                        hasAttributes = true;
                        OMAttribute attr = (OMAttribute)allAttributes.next();
                        if (attr.getNamespace() != null && "http://schemas.xmlsoap.org/soap/envelope/".equals(attr.getNamespace().getNamespaceURI())) {
                            String attrName = attr.getLocalName();
                            if (SOAP_ATR_ACTOR.equals(attrName)) {
                                OMAttribute newAtr = omNode.getOMFactory().createOMAttribute(SOAP_ATR_ROLE, newEnvelope.getNamespace(), attr.getAttributeValue());
                                newSOAPHeader.addAttribute(newAtr);
                            } else if (SOAP_ATR_MUST_UNDERSTAND.equals(attrName)) {
                                boolean isMustUnderstand = soapHeader.getMustUnderstand();
                                newSOAPHeader.setMustUnderstand(isMustUnderstand);
                            } else {
                                log.warn((Object)("removed unsupported attribute from SOAP 1.1 namespace when converting to SOAP 1.2:" + attrName));
                            }
                        } else {
                            newSOAPHeader.addAttribute(attr);
                        }
                        Iterator itrChildren = soapHeader.getChildren();
                        while (itrChildren.hasNext()) {
                            OMNode node = (OMNode)itrChildren.next();
                            itrChildren.remove();
                            newSOAPHeader.addChild(node);
                        }
                        newEnvelope.getHeader().addChild((OMNode)newSOAPHeader);
                    }
                    if (hasAttributes) continue;
                    Iterator itrChildren = soapHeader.getChildren();
                    while (itrChildren.hasNext()) {
                        OMNode node = (OMNode)itrChildren.next();
                        itrChildren.remove();
                        newSOAPHeader.addChild(node);
                    }
                    newEnvelope.getHeader().addChild((OMNode)newSOAPHeader);
                    continue;
                }
                itr.remove();
                newEnvelope.getHeader().addChild(omNode);
            }
        }
        if (clonedOldEnv.getBody() != null) {
            Iterator itrBodyChildren = clonedOldEnv.getBody().getChildren();
            while (itrBodyChildren.hasNext()) {
                omNode = (OMNode)itrBodyChildren.next();
                if (omNode != null && omNode instanceof SOAPFault) {
                    SOAPFaultDetail detail;
                    SOAPFaultReason reason;
                    SOAPFault soapFault = (SOAPFault)omNode;
                    SOAPFault newSOAPFault = soap12Factory.createSOAPFault();
                    newEnvelope.getBody().addChild((OMNode)newSOAPFault);
                    SOAPFaultCode code = soapFault.getCode();
                    if (code != null) {
                        SOAPFaultCode newSOAPFaultCode = soap12Factory.createSOAPFaultCode();
                        newSOAPFault.setCode(newSOAPFaultCode);
                        QName s11Code = code.getTextAsQName();
                        if (s11Code != null) {
                            SOAPFaultValue newSOAPFaultValue = soap12Factory.createSOAPFaultValue(newSOAPFaultCode);
                            newSOAPFaultValue.setText(SOAPUtils.getMappingSOAP12Code(s11Code));
                        }
                    }
                    if ((reason = soapFault.getReason()) != null) {
                        SOAPFaultReason newSOAPFaultReason = soap12Factory.createSOAPFaultReason(newSOAPFault);
                        String reasonText = reason.getText();
                        if (reasonText != null) {
                            SOAPFaultText newSOAPFaultText = soap12Factory.createSOAPFaultText(newSOAPFaultReason);
                            newSOAPFaultText.setLang("en");
                            newSOAPFaultText.setText(reasonText);
                        }
                        newSOAPFault.setReason(newSOAPFaultReason);
                    }
                    if ((detail = soapFault.getDetail()) == null) continue;
                    SOAPFaultDetail newSOAPFaultDetail = soap12Factory.createSOAPFaultDetail(newSOAPFault);
                    Iterator iter = detail.getAllDetailEntries();
                    while (iter.hasNext()) {
                        OMElement detailEntry = (OMElement)iter.next();
                        iter.remove();
                        newSOAPFaultDetail.addDetailEntry(detailEntry);
                    }
                    newSOAPFault.setDetail(newSOAPFaultDetail);
                    continue;
                }
                itrBodyChildren.remove();
                newEnvelope.getBody().addChild(omNode);
            }
        }
        axisOutMsgCtx.setEnvelope(newEnvelope);
    }

    public static void convertSOAP12toSOAP11(MessageContext axisOutMsgCtx) throws AxisFault {
        OMNode omNode;
        Iterator itr;
        if (log.isDebugEnabled()) {
            log.debug((Object)"convert SOAP12 to SOAP11");
        }
        SOAPEnvelope clonedOldEnv = MessageHelper.cloneSOAPEnvelope(axisOutMsgCtx.getEnvelope());
        SOAPFactory soap11Factory = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope newEnvelope = soap11Factory.getDefaultEnvelope();
        if (clonedOldEnv.getHeader() != null) {
            itr = clonedOldEnv.getHeader().getChildren();
            while (itr.hasNext()) {
                omNode = (OMNode)itr.next();
                if (omNode instanceof SOAPHeaderBlock) {
                    SOAPHeaderBlock soapHeaderBlock = (SOAPHeaderBlock)omNode;
                    SOAPHeaderBlock newSOAPHeader = soap11Factory.createSOAPHeaderBlock(soapHeaderBlock.getLocalName(), soapHeaderBlock.getNamespace());
                    Iterator allAttributes = soapHeaderBlock.getAllAttributes();
                    boolean hasAttributes = false;
                    while (allAttributes.hasNext()) {
                        hasAttributes = true;
                        OMAttribute attr = (OMAttribute)allAttributes.next();
                        if (attr.getNamespace() != null && "http://www.w3.org/2003/05/soap-envelope".equals(attr.getNamespace().getNamespaceURI())) {
                            String attrName = attr.getLocalName();
                            if (SOAP_ATR_ROLE.equals(attrName)) {
                                OMAttribute newAtr = omNode.getOMFactory().createOMAttribute(SOAP_ATR_ACTOR, newEnvelope.getNamespace(), attr.getAttributeValue());
                                newSOAPHeader.addAttribute(newAtr);
                            } else if (SOAP_ATR_MUST_UNDERSTAND.equals(attrName)) {
                                boolean isMustUnderstand = soapHeaderBlock.getMustUnderstand();
                                newSOAPHeader.setMustUnderstand(isMustUnderstand);
                            } else {
                                log.warn((Object)("removed unsupported attribute from SOAP 1.2 namespace when converting to SOAP 1.1:" + attrName));
                            }
                        } else {
                            newSOAPHeader.addAttribute(attr);
                        }
                        Iterator itrChildren = soapHeaderBlock.getChildren();
                        while (itrChildren.hasNext()) {
                            OMNode node = (OMNode)itrChildren.next();
                            itrChildren.remove();
                            newSOAPHeader.addChild(node);
                        }
                        newEnvelope.getHeader().addChild((OMNode)newSOAPHeader);
                    }
                    if (!hasAttributes) {
                        Iterator itrChildren = soapHeaderBlock.getChildren();
                        while (itrChildren.hasNext()) {
                            OMNode node = (OMNode)itrChildren.next();
                            itrChildren.remove();
                            newSOAPHeader.addChild(node);
                        }
                    }
                    newEnvelope.getHeader().addChild((OMNode)newSOAPHeader);
                    continue;
                }
                itr.remove();
                newEnvelope.getHeader().addChild(omNode);
            }
        }
        if (clonedOldEnv.getBody() != null) {
            if (clonedOldEnv.hasFault()) {
                SOAPFaultDetail detail;
                SOAPFaultReason reason;
                SOAPFault soapFault = clonedOldEnv.getBody().getFault();
                SOAPFault newSOAPFault = soap11Factory.createSOAPFault();
                newEnvelope.getBody().addChild((OMNode)newSOAPFault);
                SOAPFaultCode code = soapFault.getCode();
                if (code != null) {
                    SOAPFaultCode newSOAPFaultCode = soap11Factory.createSOAPFaultCode(newSOAPFault);
                    SOAPFaultValue value = code.getValue();
                    if (value != null) {
                        soap11Factory.createSOAPFaultValue(newSOAPFaultCode);
                        if (value.getTextAsQName() != null) {
                            newSOAPFaultCode.setText(SOAPUtils.getMappingSOAP11Code(value.getTextAsQName()));
                        }
                    }
                }
                if ((reason = soapFault.getReason()) != null) {
                    SOAPFaultReason newSOAPFaultReason = soap11Factory.createSOAPFaultReason(newSOAPFault);
                    List allSoapTexts = reason.getAllSoapTexts();
                    Iterator iterAllSoapTexts = allSoapTexts.iterator();
                    if (iterAllSoapTexts.hasNext()) {
                        SOAPFaultText soapFaultText = (SOAPFaultText)iterAllSoapTexts.next();
                        iterAllSoapTexts.remove();
                        newSOAPFaultReason.setText(soapFaultText.getText());
                    }
                }
                if ((detail = soapFault.getDetail()) != null) {
                    SOAPFaultDetail newSOAPFaultDetail = soap11Factory.createSOAPFaultDetail(newSOAPFault);
                    Iterator iter = detail.getAllDetailEntries();
                    while (iter.hasNext()) {
                        OMElement detailEntry = (OMElement)iter.next();
                        iter.remove();
                        newSOAPFaultDetail.addDetailEntry(detailEntry);
                    }
                    newSOAPFault.setDetail(newSOAPFaultDetail);
                }
            } else {
                itr = clonedOldEnv.getBody().getChildren();
                while (itr.hasNext()) {
                    omNode = (OMNode)itr.next();
                    if (omNode == null) continue;
                    itr.remove();
                    newEnvelope.getBody().addChild(omNode);
                }
            }
        }
        axisOutMsgCtx.setEnvelope(newEnvelope);
    }

    private static QName getMappingSOAP12Code(QName soap11Code) {
        if (S11_FAULTCODE_VERSIONMISMATCH.equals(soap11Code)) {
            return S12_FAULTCODE_VERSIONMISMATCH;
        }
        if (S11_FAULTCODE_MUSTUNDERSTAND.equals(soap11Code)) {
            return S12_FAULTCODE_MUSTUNDERSTAND;
        }
        if (S11_FAULTCODE_CLIENT.equals(soap11Code)) {
            return S12_FAULTCODE_SENDER;
        }
        if (S11_FAULTCODE_SERVER.equals(soap11Code)) {
            return S12_FAULTCODE_RECEIVER;
        }
        log.warn((Object)"An unidentified SOAP11 FaultCode encountered, returning a blank QName");
        return new QName("", "");
    }

    private static QName getMappingSOAP11Code(QName soap12Code) {
        if (S12_FAULTCODE_VERSIONMISMATCH.equals(soap12Code)) {
            return S11_FAULTCODE_VERSIONMISMATCH;
        }
        if (S12_FAULTCODE_MUSTUNDERSTAND.equals(soap12Code)) {
            return S11_FAULTCODE_MUSTUNDERSTAND;
        }
        if (S12_FAULTCODE_SENDER.equals(soap12Code)) {
            return S11_FAULTCODE_SERVER;
        }
        if (S12_FAULTCODE_RECEIVER.equals(soap12Code)) {
            return S11_FAULTCODE_SERVER;
        }
        if (S12_FAULTCODE_DATAENCODINGUNKNOWN.equals(soap12Code)) {
            log.debug((Object)"There is no matching SOAP11 code value for SOAP12 fault code DataEncodingUnknown, returning a blank QName");
            return new QName("");
        }
        log.warn((Object)"An unidentified SOAP11 FaultCode encountered, returning a blank QName");
        return new QName("");
    }
}

