/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.TransportInDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseHandler;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.carbonext.TenantInfoConfigurator;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.core.axis2.ResponseState;
import org.apache.synapse.core.axis2.SynapseMessageReceiver;
import org.apache.synapse.debug.SynapseDebugManager;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.apache.synapse.transport.http.conn.SynapseWireLogHolder;
import org.apache.synapse.util.logging.LoggingUtils;

public class ProxyServiceMessageReceiver
extends SynapseMessageReceiver {
    private static final Log log = LogFactory.getLog(ProxyServiceMessageReceiver.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private String name = null;
    private ProxyService proxy = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(org.apache.axis2.context.MessageContext mc) throws AxisFault {
        TransportInDescription trpInDesc;
        boolean traceOn = this.proxy.getAspectConfiguration().isTracingEnabled();
        boolean traceOrDebugOn = traceOn || log.isDebugEnabled();
        CustomLogSetter.getInstance().setLogAppender(this.proxy.getArtifactContainerName());
        String remoteAddr = (String)mc.getProperty("REMOTE_ADDR");
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Proxy Service " + this.name + " received a new message" + (remoteAddr != null ? " from : " + remoteAddr : "..."));
            this.traceOrDebug(traceOn, "Message To: " + (mc.getTo() != null ? mc.getTo().getAddress() : "null"));
            this.traceOrDebug(traceOn, "SOAPAction: " + (mc.getSoapAction() != null ? mc.getSoapAction() : "null"));
            this.traceOrDebug(traceOn, "WSA-Action: " + (mc.getWSAAction() != null ? mc.getWSAAction() : "null"));
            if (traceOn && trace.isTraceEnabled()) {
                String[] cids = null;
                try {
                    cids = mc.getAttachmentMap().getAllContentIDs();
                }
                catch (Exception ex) {
                    mc.setAttachmentMap(null);
                    log.error((Object)"Synapse encountered an exception when reading attachments from bytes stream. Hence Attachments map is dropped from the message context.", (Throwable)ex);
                }
                if (cids != null && cids.length > 0) {
                    for (String cid : cids) {
                        trace.trace((Object)("With attachment content ID : " + cid));
                    }
                }
                trace.trace((Object)("Envelope : " + mc.getEnvelope()));
            }
        }
        MessageContext synCtx = MessageContextCreatorForAxis2.getSynapseMessageContext(mc);
        Integer statisticReportingIndex = null;
        boolean isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        if (isStatisticsEnabled) {
            statisticReportingIndex = OpenEventCollector.reportEntryEvent(synCtx, this.name, this.proxy.getAspectConfiguration(), ComponentType.PROXYSERVICE);
        }
        Object inboundServiceParam = this.proxy.getParameterMap().get("inbound.only");
        Object inboundMsgCtxParam = mc.getProperty("isInbound");
        if ((inboundMsgCtxParam == null || !((Boolean)inboundMsgCtxParam).booleanValue()) && inboundServiceParam != null && Boolean.valueOf((String)inboundServiceParam).booleanValue()) {
            if (!synCtx.getFaultStack().isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Executing fault handler - message discarded due to the proxy is allowed only via InboundEP");
                }
                synCtx.getFaultStack().pop().handleFault(synCtx, new Exception("Proxy Service " + this.name + " message discarded due to the proxy is allowed only via InboundEP"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Proxy Service " + this.name + " message discarded due to the proxy is allowed only via InboundEP"));
            }
            return;
        }
        TenantInfoConfigurator configurator = synCtx.getEnvironment().getTenantInfoConfigurator();
        if (configurator != null) {
            configurator.extractTenantInfo(synCtx);
        }
        if ((trpInDesc = mc.getTransportIn()) != null) {
            synCtx.setProperty("TRANSPORT_IN_NAME", trpInDesc.getName());
        }
        Log serviceLog = LogFactory.getLog((String)("SERVICE_LOGGER." + this.name));
        ((Axis2MessageContext)synCtx).setServiceLog(serviceLog);
        synCtx.setProperty("proxy.name", this.name);
        synCtx.setProperty("ARTIFACT_NAME", "proxy" + this.name);
        synCtx.setProperty("IsClientDoingREST", mc.isDoingREST());
        synCtx.setProperty("IsClientDoingSOAP11", mc.isSOAP11());
        synCtx.setProperty("correlation_id", mc.getProperty("correlation_id"));
        try {
            if (synCtx.getEnvironment().isDebuggerEnabled()) {
                SynapseDebugManager debugManager = synCtx.getEnvironment().getSynapseDebugManager();
                debugManager.acquireMediationFlowLock();
                debugManager.advertiseMediationFlowStartPoint(synCtx);
                if (!synCtx.isResponse()) {
                    SynapseWireLogHolder wireLogHolder = (SynapseWireLogHolder)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("synapse.wire.log.holder");
                    if (wireLogHolder == null) {
                        wireLogHolder = new SynapseWireLogHolder();
                    }
                    if (synCtx.getProperty("proxy.name") != null && !synCtx.getProperty("proxy.name").toString().isEmpty()) {
                        wireLogHolder.setProxyName(synCtx.getProperty("proxy.name").toString());
                    }
                    ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("synapse.wire.log.holder", (Object)wireLogHolder);
                }
            }
            synCtx.setProperty("__SYNAPSE_RESPONSE_STATE__", new ResponseState());
            List<SynapseHandler> handlers = synCtx.getEnvironment().getSynapseHandlers();
            for (SynapseHandler handler : handlers) {
                if (handler.handleRequestInFlow(synCtx)) continue;
                return;
            }
            Mediator mandatorySeq = synCtx.getConfiguration().getMandatorySequence();
            if (mandatorySeq != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Start mediating the message in the pre-mediate state using the mandatory sequence");
                }
                if (!mandatorySeq.mediate(synCtx)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Request message for the proxy service " + this.name + " dropped in the pre-mediation state by the mandatory sequence : \n" + synCtx));
                    }
                    return;
                }
            }
            this.proxy.registerFaultHandler(synCtx);
            boolean inSequenceResult = true;
            if (this.proxy.getTargetInSequence() != null) {
                Mediator inSequence = synCtx.getSequence(this.proxy.getTargetInSequence());
                if (inSequence != null) {
                    this.traceOrDebug(traceOn, "Using sequence named : " + this.proxy.getTargetInSequence() + " for incoming message mediation");
                    inSequenceResult = inSequence.mediate(synCtx);
                } else {
                    this.handleException("Unable to find in-sequence : " + this.proxy.getTargetInSequence(), synCtx);
                }
            } else if (this.proxy.getTargetInLineInSequence() != null) {
                this.traceOrDebug(traceOn, "Using the anonymous in-sequence of the proxy service for mediation");
                inSequenceResult = this.proxy.getTargetInLineInSequence().mediate(synCtx);
            }
            if (inSequenceResult) {
                if (this.proxy.getTargetEndpoint() != null) {
                    Endpoint endpoint = synCtx.getEndpoint(this.proxy.getTargetEndpoint());
                    if (endpoint != null) {
                        this.traceOrDebug(traceOn, "Forwarding message to the endpoint : " + this.proxy.getTargetEndpoint());
                        endpoint.send(synCtx);
                    } else {
                        this.handleException("Unable to find the endpoint specified : " + this.proxy.getTargetEndpoint(), synCtx);
                    }
                } else if (this.proxy.getTargetInLineEndpoint() != null) {
                    this.traceOrDebug(traceOn, "Forwarding the message to the anonymous endpoint of the proxy service");
                    this.proxy.getTargetInLineEndpoint().send(synCtx);
                }
            }
        }
        catch (SynapseException syne) {
            if (!synCtx.getFaultStack().isEmpty()) {
                this.warn(traceOn, "Executing fault handler due to exception encountered", synCtx);
                synCtx.getFaultStack().pop().handleFault(synCtx, syne);
            } else {
                this.warn(traceOn, "Exception encountered but no fault handler found - message dropped", synCtx);
            }
        }
        finally {
            if (isStatisticsEnabled) {
                CloseEventCollector.tryEndFlow(synCtx, this.name, ComponentType.PROXYSERVICE, statisticReportingIndex, true);
            }
            if (synCtx.getEnvironment().isDebuggerEnabled()) {
                SynapseDebugManager debugManager = synCtx.getEnvironment().getSynapseDebugManager();
                debugManager.advertiseMediationFlowTerminatePoint(synCtx);
                debugManager.releaseMediationFlowLock();
            }
            ProxyServiceMessageReceiver.doPostInjectUpdates(synCtx);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProxy(ProxyService proxy) {
        this.proxy = proxy;
    }

    private void traceOrDebug(boolean traceOn, String msg) {
        String formattedLog = LoggingUtils.getFormattedLog("proxy", this.name, msg);
        if (traceOn) {
            trace.info((Object)formattedLog);
        }
        log.debug((Object)formattedLog);
    }

    private void warn(boolean traceOn, String msg, MessageContext msgContext) {
        String formattedLog = LoggingUtils.getFormattedLog("proxy", this.name, msg);
        if (traceOn) {
            trace.warn((Object)formattedLog);
        }
        if (log.isDebugEnabled()) {
            log.warn((Object)formattedLog);
        }
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().warn((Object)msg);
        }
    }

    private void handleException(String msg, MessageContext msgContext) {
        String formattedLog = LoggingUtils.getFormattedLog("proxy", this.name, msg);
        log.error((Object)formattedLog);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().error((Object)msg);
        }
        if (this.proxy.getAspectConfiguration().isTracingEnabled()) {
            trace.error((Object)formattedLog);
        }
        throw new SynapseException(msg);
    }
}

