/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDL20ToAxisServiceBuilder;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseArtifact;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfigurable;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.ProxyServiceMessageReceiver;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.apache.synapse.util.PolicyInfo;
import org.apache.synapse.util.logging.LoggingUtils;
import org.apache.synapse.util.resolver.CustomWSDLLocator;
import org.apache.synapse.util.resolver.CustomXmlSchemaURIResolver;
import org.apache.synapse.util.resolver.ResourceMap;
import org.apache.synapse.util.resolver.SecureVaultResolver;
import org.apache.synapse.util.resolver.UserDefinedWSDLLocator;
import org.apache.synapse.util.resolver.UserDefinedXmlSchemaURIResolver;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

public class ProxyService
implements AspectConfigurable,
SynapseArtifact {
    private static final Log log = LogFactory.getLog(ProxyService.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private final Log serviceLog;
    public static final String ABSOLUTE_SCHEMA_URL_PARAM = "showAbsoluteSchemaURL";
    public static final String ABSOLUTE_PROXY_SCHEMA_URL_PARAM = "showProxySchemaURL";
    public static final String ENGAGED_MODULES = "engagedModules";
    private static final String NO_SECURITY_POLICY = "NoSecurity";
    private static final String SEC_POLICY_ELEMENT = "Policy";
    private static final String PORT_ELEMENT = "portType";
    private static final String PORT_SECURITY_ATTRIBUTE = "PolicyURIs";
    private String name;
    private String description;
    private ArrayList transports;
    private List pinnedServers = new ArrayList();
    private String targetEndpoint = null;
    private String targetInSequence = null;
    private String targetOutSequence = null;
    private String targetFaultSequence = null;
    private Endpoint targetInLineEndpoint = null;
    private SequenceMediator targetInLineInSequence = null;
    private SequenceMediator targetInLineOutSequence = null;
    private SequenceMediator targetInLineFaultSequence = null;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private String wsdlKey;
    private String preservePolicy;
    private URI wsdlURI;
    private Object inLineWSDL;
    private String publishWSDLEndpoint;
    private ResourceMap resourceMap;
    private List<PolicyInfo> policies = new ArrayList<PolicyInfo>();
    private final List<String> serviceLevelPolicies = new ArrayList<String>();
    private List<String> inMessagePolicies = new ArrayList<String>();
    private List<String> outMessagePolicies = new ArrayList<String>();
    private boolean wsAddrEnabled = false;
    @Deprecated
    private boolean wsRMEnabled = false;
    private boolean wsSecEnabled = false;
    private boolean startOnLoad = true;
    private boolean running = false;
    public static final String ALL_TRANSPORTS = "all";
    private AspectConfiguration aspectConfiguration;
    private String fileName;
    private URL filePath;
    private String serviceGroup;
    private boolean moduleEngaged;
    private boolean wsdlPublished;
    private String artifactContainerName;
    private boolean isEdited;
    private SynapseEnvironment synapseEnvironment;
    private AxisService axisService;
    private List<String> commentsList = new ArrayList<String>();

    public String getPreservePolicy() {
        return this.preservePolicy;
    }

    public void setPreservePolicy(String preservePolicy) {
        this.preservePolicy = preservePolicy;
    }

    public ProxyService(String name) {
        this.name = name;
        this.serviceLog = LogFactory.getLog((String)("SERVICE_LOGGER." + name));
        this.aspectConfiguration = new AspectConfiguration(name);
    }

    private void removePolicyOfWSDL(OMElement wsdlElement) {
        Iterator iterator = wsdlElement.getChildElements();
        while (iterator.hasNext()) {
            QName policyURIs;
            OMElement child = (OMElement)iterator.next();
            if (child.getQName().getLocalPart().equals(SEC_POLICY_ELEMENT)) {
                child.detach();
            }
            if (!child.getQName().getLocalPart().equals(PORT_ELEMENT) || child.getAttribute(policyURIs = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", PORT_SECURITY_ATTRIBUTE)) == null) continue;
            OMAttribute attr = child.getAttribute(policyURIs);
            child.removeAttribute(attr);
        }
    }

    public AxisService buildAxisService(SynapseConfiguration synCfg, AxisConfiguration axisCfg) {
        String[] moduleNames;
        Object wsdlNamespace22;
        boolean wsdlFound;
        block120: {
            Map<String, Object> proxyParameters;
            URL url;
            String synapseHome;
            Parameter param;
            Parameter synapseEnv = axisCfg.getParameter("synapse.env");
            if (synapseEnv != null) {
                this.synapseEnvironment = (SynapseEnvironment)synapseEnv.getValue();
            }
            this.auditInfo("Building Axis service for Proxy service : " + this.name);
            if (this.pinnedServers != null && !this.pinnedServers.isEmpty() && (param = axisCfg.getParameter("synapse.env")) != null && param.getValue() instanceof SynapseEnvironment) {
                String serverName;
                SynapseEnvironment synEnv = (SynapseEnvironment)param.getValue();
                String string = serverName = synEnv != null ? synEnv.getServerContextInformation().getServerConfigurationInformation().getServerName() : "localhost";
                if (!this.pinnedServers.contains(serverName)) {
                    log.info((Object)("Server name " + serverName + " not in pinned servers list. Not deploying Proxy service : " + this.name));
                    return null;
                }
            }
            if (this.trace()) {
                trace.info((Object)("Loading the WSDL : " + (this.publishWSDLEndpoint != null ? " endpoint = " + this.publishWSDLEndpoint : (this.wsdlKey != null ? " key = " + this.wsdlKey : (this.wsdlURI != null ? " URI = " + this.wsdlURI : " <Inlined>")))));
            }
            ByteArrayInputStream wsdlInputStream = null;
            OMElement wsdlElement = null;
            wsdlFound = false;
            String publishWSDL = null;
            SynapseEnvironment synEnv = SynapseConfigUtils.getSynapseEnvironment(axisCfg);
            String string = synapseHome = synEnv != null ? synEnv.getServerContextInformation().getServerConfigurationInformation().getSynapseHome() : "";
            if (this.wsdlKey != null) {
                synCfg.getEntryDefinition(this.wsdlKey);
                Object keyObject = synCfg.getEntry(this.wsdlKey);
                if (keyObject == null) {
                    synCfg.removeEntry(this.wsdlKey);
                }
                if (keyObject instanceof OMElement) {
                    wsdlElement = (OMElement)keyObject;
                }
                wsdlFound = true;
            } else if (this.inLineWSDL != null) {
                wsdlElement = (OMElement)this.inLineWSDL;
                wsdlFound = true;
            } else if (this.wsdlURI != null) {
                try {
                    url = this.wsdlURI.toURL();
                    publishWSDL = url.toString();
                    OMNode oMNode = SynapseConfigUtils.getOMElementFromURL(publishWSDL, synapseHome);
                    if (oMNode instanceof OMElement) {
                        wsdlElement = (OMElement)oMNode;
                    }
                    wsdlFound = true;
                }
                catch (MalformedURLException e) {
                    this.handleException("Malformed URI for wsdl", e);
                }
                catch (IOException e) {
                    boolean bl;
                    boolean bl2 = false;
                    proxyParameters = this.getParameterMap();
                    if (!proxyParameters.isEmpty()) {
                        if (proxyParameters.containsKey("enablePublishWSDLSafeMode")) {
                            bl = Boolean.parseBoolean(proxyParameters.get("enablePublishWSDLSafeMode").toString().toLowerCase());
                        } else {
                            if (this.trace()) {
                                trace.info((Object)("WSDL was unable to load for: " + publishWSDL));
                                trace.info((Object)"Please add <syn:parameter name=\"enableURISafeMode\">true</syn:parameter> to proxy service.");
                            }
                            this.handleException("Error reading from wsdl URI", e);
                        }
                    }
                    if (bl) {
                        if (this.trace()) {
                            trace.info((Object)("WSDL was unable to load for: " + publishWSDL));
                            trace.info((Object)"enableURISafeMode: true");
                        }
                        log.warn((Object)("Unable to load the WSDL for : " + this.name), (Throwable)e);
                        return null;
                    }
                    if (this.trace()) {
                        trace.info((Object)("WSDL was unable to load for: " + publishWSDL));
                        trace.info((Object)"enableURISafeMode: false");
                    }
                    this.handleException("Error reading from wsdl URI", e);
                }
            } else if (this.publishWSDLEndpoint != null) {
                try {
                    url = null;
                    Endpoint endpoint = synCfg.getEndpoint(this.publishWSDLEndpoint);
                    if (endpoint == null) {
                        this.handleException("Unable to resolve WSDL url. " + this.publishWSDLEndpoint + " is null");
                    }
                    if (endpoint instanceof AddressEndpoint) {
                        url = new URL(((AddressEndpoint)endpoint).getDefinition().getAddress() + "?wsdl");
                    } else if (endpoint instanceof WSDLEndpoint) {
                        url = new URL(((WSDLEndpoint)endpoint).getWsdlURI());
                    } else {
                        this.handleException("Unable to resolve WSDL url. " + this.publishWSDLEndpoint + " is not a AddressEndpoint or WSDLEndpoint");
                    }
                    publishWSDL = url.toString();
                    OMNode node = SynapseConfigUtils.getOMElementFromURL(publishWSDL, synapseHome);
                    if (node instanceof OMElement) {
                        wsdlElement = (OMElement)node;
                    }
                    wsdlFound = true;
                }
                catch (MalformedURLException e) {
                    this.handleException("Malformed URI for wsdl", e);
                }
                catch (IOException e) {
                    boolean bl;
                    boolean bl3 = false;
                    proxyParameters = this.getParameterMap();
                    if (!proxyParameters.isEmpty()) {
                        if (proxyParameters.containsKey("enablePublishWSDLSafeMode")) {
                            bl = Boolean.parseBoolean(proxyParameters.get("enablePublishWSDLSafeMode").toString().toLowerCase());
                        } else {
                            if (this.trace()) {
                                trace.info((Object)("WSDL was unable to load for: " + publishWSDL));
                                trace.info((Object)"Please add <syn:parameter name=\"enableURISafeMode\">true</syn:parameter> to proxy service.");
                            }
                            this.handleException("Error reading from wsdl URI " + publishWSDL, e);
                        }
                    }
                    if (bl) {
                        if (this.trace()) {
                            trace.info((Object)("WSDL was unable to load for: " + publishWSDL));
                            trace.info((Object)"enableURISafeMode: true");
                        }
                        log.warn((Object)("Unable to load the WSDL for : " + this.name), (Throwable)e);
                        return null;
                    }
                    if (this.trace()) {
                        trace.info((Object)("WSDL was unable to load for: " + publishWSDL));
                        trace.info((Object)"enableURISafeMode: false");
                    }
                    this.handleException("Error reading from wsdl URI " + publishWSDL, e);
                }
            } else {
                if (this.trace()) {
                    trace.info((Object)"Did not find a WSDL. Assuming a POX or Legacy service");
                }
                this.axisService = new AxisService();
                InOutAxisOperation mediateOperation = new InOutAxisOperation(SynapseConstants.SYNAPSE_OPERATION_NAME);
                mediateOperation.getMessage("In").setName("in");
                mediateOperation.getMessage("Out").setName("out");
                this.axisService.addOperation((AxisOperation)mediateOperation);
            }
            if (wsdlElement != null) {
                wsdlNamespace22 = wsdlElement.getNamespace();
                if (this.preservePolicy != null && this.preservePolicy.equals("false") && "http://schemas.xmlsoap.org/wsdl/".equals(wsdlNamespace22.getNamespaceURI())) {
                    this.removePolicyOfWSDL(wsdlElement);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    if (this.trace()) {
                        trace.info((Object)"Serializing wsdlElement found to build an Axis2 service");
                    }
                    wsdlElement.serialize((OutputStream)byteArrayOutputStream);
                    wsdlInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }
                catch (XMLStreamException e) {
                    this.handleException("Error converting to a StreamSource", e);
                }
                if (wsdlInputStream != null) {
                    try {
                        if (this.trace()) {
                            trace.info((Object)("WSDL Namespace is : " + wsdlNamespace22.getNamespaceURI()));
                        }
                        if (wsdlNamespace22 != null) {
                            WSDL20ToAxisServiceBuilder wsdlToAxisServiceBuilder = null;
                            if ("http://www.w3.org/ns/wsdl".equals(wsdlNamespace22.getNamespaceURI())) {
                                wsdlToAxisServiceBuilder = new WSDL20ToAxisServiceBuilder((InputStream)wsdlInputStream, null, null);
                            } else if ("http://schemas.xmlsoap.org/wsdl/".equals(wsdlNamespace22.getNamespaceURI())) {
                                wsdlToAxisServiceBuilder = new WSDL11ToAxisServiceBuilder((InputStream)wsdlInputStream);
                            } else {
                                this.handleException("Unknown WSDL format.. not WSDL 1.1 or WSDL 2.0");
                            }
                            if (wsdlToAxisServiceBuilder == null) {
                                throw new SynapseException("Could not get the WSDL to Axis Service Builder");
                            }
                            wsdlToAxisServiceBuilder.setBaseUri(this.wsdlURI != null ? this.wsdlURI.toString() : synapseHome);
                            if (this.trace()) {
                                trace.info((Object)"Setting up custom resolvers");
                            }
                            if (synCfg.getProperty("synapse.wsdl.resolver") != null && synCfg.getProperty("synapse.schema.resolver") != null) {
                                this.setUserDefinedResourceResolvers(synCfg, wsdlInputStream, (WSDLToAxisServiceBuilder)wsdlToAxisServiceBuilder);
                            } else if (this.resourceMap != null) {
                                wsdlToAxisServiceBuilder.setCustomResolver((URIResolver)new CustomXmlSchemaURIResolver(this.resourceMap, synCfg));
                                if (wsdlToAxisServiceBuilder instanceof WSDL11ToAxisServiceBuilder) {
                                    ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setCustomWSDLResolver((WSDLLocator)new CustomWSDLLocator(new InputSource(wsdlInputStream), this.wsdlURI != null ? this.wsdlURI.toString() : "", this.resourceMap, synCfg));
                                }
                            } else {
                                wsdlToAxisServiceBuilder.setCustomResolver((URIResolver)new CustomXmlSchemaURIResolver());
                                if (wsdlToAxisServiceBuilder instanceof WSDL11ToAxisServiceBuilder) {
                                    ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setCustomWSDLResolver((WSDLLocator)new CustomWSDLLocator(new InputSource(wsdlInputStream), this.wsdlURI != null ? this.wsdlURI.toString() : ""));
                                }
                            }
                            if (this.trace()) {
                                trace.info((Object)"Populating Axis2 service using WSDL");
                                if (trace.isTraceEnabled()) {
                                    trace.trace((Object)("WSDL : " + wsdlElement.toString()));
                                }
                            }
                            this.axisService = wsdlToAxisServiceBuilder.populateService();
                            this.axisService.getEndpoints().clear();
                            break block120;
                        }
                        this.handleException("Unknown WSDL format.. not WSDL 1.1 or WSDL 2.0");
                    }
                    catch (AxisFault af) {
                        this.handleException("Error building service from WSDL", (Exception)((Object)af));
                    }
                    catch (IOException ioe) {
                        this.handleException("Error reading WSDL", ioe);
                    }
                }
            } else if (wsdlFound) {
                this.handleException("Couldn't build the proxy service : " + this.name + ". Unable to locate the specified WSDL to build the service");
            }
        }
        if (this.axisService == null) {
            throw new SynapseException("Could not create a proxy service");
        }
        this.axisService.setName(this.name);
        if (this.description != null) {
            this.axisService.setDocumentation(this.description);
        }
        if (this.filePath != null) {
            this.axisService.setFileName(this.filePath);
        }
        if (this.transports != null && this.transports.size() != 0) {
            if (this.trace()) {
                trace.info((Object)("Exposing transports : " + this.transports));
            }
            this.axisService.setExposedTransports((List)this.transports);
        }
        if (this.trace() && this.parameters.size() > 0) {
            trace.info((Object)("Setting service parameters : " + this.parameters));
        }
        for (Object e : this.parameters.keySet()) {
            String name = (String)e;
            Object value = this.parameters.get(name);
            Parameter p = new Parameter();
            p.setName(name);
            if (value instanceof String) {
                value = SecureVaultResolver.resolve(this.synapseEnvironment, (String)value);
            }
            p.setValue(value);
            try {
                this.axisService.addParameter(p);
            }
            catch (AxisFault af) {
                this.handleException("Error setting parameter : " + name + "to proxy service as a Parameter", (Exception)((Object)af));
            }
        }
        if (JavaUtils.isTrueExplicitly((Object)this.axisService.getParameterValue(ABSOLUTE_SCHEMA_URL_PARAM))) {
            this.axisService.setCustomSchemaNamePrefix("");
        }
        if (JavaUtils.isTrueExplicitly((Object)this.axisService.getParameterValue(ABSOLUTE_PROXY_SCHEMA_URL_PARAM))) {
            this.axisService.setCustomSchemaNamePrefix("fullschemaurl");
        }
        if (JavaUtils.isTrueExplicitly((Object)this.axisService.getParameterValue("disableOperationValidation"))) {
            try {
                wsdlNamespace22 = this.processOperationValidation(this.axisService);
            }
            catch (AxisFault wsdlNamespace22) {
                // empty catch block
            }
        }
        boolean isNoSecPolicy = false;
        if (!this.policies.isEmpty()) {
            for (PolicyInfo pi : this.policies) {
                AxisOperation op;
                String policyKey = pi.getPolicyKey();
                Policy policy = null;
                synCfg.getEntryDefinition(policyKey);
                Object policyEntry = synCfg.getEntry(policyKey);
                if (policyEntry == null) {
                    this.handleException("Security Policy Entry not found for key: " + policyKey + " in Proxy Service: " + this.name);
                } else {
                    policy = PolicyEngine.getPolicy((InputStream)SynapseConfigUtils.getStreamSource(policyEntry).getInputStream());
                }
                if (policy == null) {
                    this.handleException("Invalid Security Policy found for the key: " + policyKey + " in proxy service: " + this.name);
                }
                if (NO_SECURITY_POLICY.equals(policy.getId())) {
                    isNoSecPolicy = true;
                    log.info((Object)"NoSecurity Policy found, skipping policy attachment");
                    continue;
                }
                if (pi.isServicePolicy()) {
                    this.axisService.getPolicySubject().attachPolicy(policy);
                    continue;
                }
                if (pi.isOperationPolicy()) {
                    op = this.axisService.getOperation(pi.getOperation());
                    if (op != null) {
                        op.getPolicySubject().attachPolicy(policy);
                        continue;
                    }
                    this.handleException("Couldn't find the operation specified by the QName : " + pi.getOperation());
                    continue;
                }
                if (pi.isMessagePolicy()) {
                    if (pi.getOperation() != null) {
                        op = this.axisService.getOperation(pi.getOperation());
                        if (op != null) {
                            op.getMessage(pi.getMessageLable()).getPolicySubject().attachPolicy(policy);
                            continue;
                        }
                        this.handleException("Couldn't find the operation specified by the QName : " + pi.getOperation());
                        continue;
                    }
                    Iterator itr = this.axisService.getOperations();
                    while (itr.hasNext()) {
                        Object obj = itr.next();
                        if (!(obj instanceof AxisOperation) || obj instanceof OutOnlyAxisOperation && pi.getType() == 1 || obj instanceof InOnlyAxisOperation && pi.getType() == 2) continue;
                        AxisMessage message = ((AxisOperation)obj).getMessage(pi.getMessageLable());
                        message.getPolicySubject().attachPolicy(policy);
                    }
                    continue;
                }
                this.handleException("Undefined Policy type");
            }
        }
        ProxyServiceMessageReceiver proxyServiceMessageReceiver = new ProxyServiceMessageReceiver();
        proxyServiceMessageReceiver.setName(this.name);
        proxyServiceMessageReceiver.setProxy(this);
        Iterator iter = this.axisService.getOperations();
        while (iter.hasNext()) {
            AxisOperation op = (AxisOperation)iter.next();
            op.setMessageReceiver((MessageReceiver)proxyServiceMessageReceiver);
        }
        try {
            this.axisService.addParameter("serviceType", (Object)"proxy");
            if (this.serviceGroup == null) {
                this.auditInfo("Adding service " + this.name + " to the Axis2 configuration");
                axisCfg.addService(this.axisService);
            } else {
                this.auditInfo("Adding service " + this.name + " to the service group " + this.serviceGroup);
                if (axisCfg.getServiceGroup(this.serviceGroup) == null) {
                    AxisServiceGroup proxyServiceGroup = new AxisServiceGroup();
                    proxyServiceGroup.setServiceGroupName(this.serviceGroup);
                    proxyServiceGroup.setParent((AxisDescription)axisCfg);
                    proxyServiceGroup.addService(this.axisService);
                    axisCfg.addServiceGroup(proxyServiceGroup);
                } else {
                    this.axisService.setParent(axisCfg.getServiceGroup(this.serviceGroup));
                    axisCfg.addServiceToExistingServiceGroup(this.axisService, this.serviceGroup);
                }
            }
            this.setRunning(true);
        }
        catch (AxisFault axisFault) {
            try {
                if (axisCfg.getService(this.axisService.getName()) != null) {
                    if (this.trace()) {
                        trace.info((Object)("Removing service " + this.name + " due to error : " + axisFault.getMessage()));
                    }
                    axisCfg.removeService(this.axisService.getName());
                }
            }
            catch (AxisFault policy) {
                // empty catch block
            }
            this.handleException("Error adding Proxy service to the Axis2 engine", (Exception)((Object)axisFault));
        }
        if (this.wsAddrEnabled) {
            this.auditInfo("WS-Addressing is enabled for service : " + this.name);
            try {
                this.axisService.engageModule(axisCfg.getModule("addressing"), (AxisDescription)axisCfg);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error loading WS Addressing module on proxy service : " + this.name, (Exception)((Object)axisFault));
            }
        }
        boolean secModuleEngaged = false;
        if (this.wsSecEnabled && !isNoSecPolicy) {
            this.auditInfo("WS-Security is enabled for service : " + this.name);
            try {
                this.axisService.engageModule(axisCfg.getModule("rampart"), (AxisDescription)axisCfg);
                secModuleEngaged = true;
            }
            catch (AxisFault axisFault) {
                this.handleException("Error loading WS Sec module on proxy service : " + this.name, (Exception)((Object)axisFault));
            }
        } else if (isNoSecPolicy) {
            log.info((Object)"NoSecurity Policy found, skipping rampart engagement");
        }
        this.moduleEngaged = secModuleEngaged || this.wsAddrEnabled;
        this.wsdlPublished = wsdlFound;
        Object engaged_modules = this.parameters.get(ENGAGED_MODULES);
        if (engaged_modules != null && (moduleNames = this.getModuleNames((String)engaged_modules)) != null) {
            for (String moduleName : moduleNames) {
                try {
                    AxisModule axisModule = axisCfg.getModule(moduleName);
                    if (axisModule == null) continue;
                    this.axisService.engageModule(axisModule, (AxisDescription)axisCfg);
                    this.moduleEngaged = true;
                }
                catch (AxisFault axisFault) {
                    this.handleException("Error loading " + moduleName + " module on proxy service : " + this.name, (Exception)((Object)axisFault));
                }
            }
        }
        this.auditInfo("Successfully created the Axis2 service for Proxy service : " + this.name);
        return this.axisService;
    }

    public AxisService getAxisService() {
        return this.axisService;
    }

    private void setUserDefinedResourceResolvers(SynapseConfiguration synCfg, InputStream wsdlInputStream, WSDLToAxisServiceBuilder wsdlToAxisServiceBuilder) {
        Object schemaClazzObject;
        Object wsdlClzzObject;
        Class<?> schemaClazz;
        Class<?> wsdlClazz;
        String wsdlResolverName = synCfg.getProperty("synapse.wsdl.resolver");
        String schemaResolverName = synCfg.getProperty("synapse.schema.resolver");
        try {
            wsdlClazz = Class.forName(wsdlResolverName);
            schemaClazz = Class.forName(schemaResolverName);
        }
        catch (ClassNotFoundException e) {
            String msg = "System could not find the class defined for the specific properties \n WSDLResolverImplementation:" + wsdlResolverName + "\n SchemaResolverImplementation:" + schemaResolverName;
            this.handleException(msg, e);
            return;
        }
        try {
            wsdlClzzObject = wsdlClazz.newInstance();
            schemaClazzObject = schemaClazz.newInstance();
        }
        catch (Exception e) {
            String msg = "Could not create an instance from the class";
            this.handleException(msg, e);
            return;
        }
        UserDefinedXmlSchemaURIResolver userDefSchemaResolver = (UserDefinedXmlSchemaURIResolver)schemaClazzObject;
        userDefSchemaResolver.init(this.resourceMap, synCfg, this.wsdlKey);
        wsdlToAxisServiceBuilder.setCustomResolver((URIResolver)userDefSchemaResolver);
        if (wsdlToAxisServiceBuilder instanceof WSDL11ToAxisServiceBuilder) {
            UserDefinedWSDLLocator userDefWSDLLocator = (UserDefinedWSDLLocator)wsdlClzzObject;
            userDefWSDLLocator.init(new InputSource(wsdlInputStream), this.wsdlURI != null ? this.wsdlURI.toString() : "", this.resourceMap, synCfg, this.wsdlKey);
            ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setCustomWSDLResolver((WSDLLocator)userDefWSDLLocator);
        }
    }

    public void start(SynapseConfiguration synCfg) {
        AxisConfiguration axisConfig = synCfg.getAxisConfiguration();
        if (axisConfig != null) {
            Parameter param = axisConfig.getParameter("synapse.env");
            if (param != null && param.getValue() instanceof SynapseEnvironment) {
                SynapseEnvironment env = (SynapseEnvironment)param.getValue();
                if (this.targetInLineInSequence != null) {
                    this.targetInLineInSequence.init(env);
                }
                if (this.targetInLineOutSequence != null) {
                    this.targetInLineOutSequence.init(env);
                }
                if (this.targetInLineFaultSequence != null) {
                    this.targetInLineFaultSequence.init(env);
                }
            } else {
                this.auditWarn("Unable to find the SynapseEnvironment. Components of the proxy service may not be initialized");
            }
            AxisService as = axisConfig.getServiceForActivation(this.getName());
            as.setActive(true);
            axisConfig.notifyObservers(new AxisEvent(3, (AxisDescription)as), as);
            this.setRunning(true);
            this.auditInfo("Started the proxy service : " + this.name);
        } else {
            this.auditWarn("Unable to start proxy service : " + this.name + ". Couldn't access Axis configuration");
        }
    }

    public void stop(SynapseConfiguration synCfg) {
        AxisConfiguration axisConfig = synCfg.getAxisConfiguration();
        if (axisConfig != null) {
            AxisService as = axisConfig.getServiceForActivation(this.getName());
            if (as != null) {
                if (as.isActive()) {
                    as.setActive(false);
                }
                axisConfig.notifyObservers(new AxisEvent(2, (AxisDescription)as), as);
            }
            this.setRunning(false);
            this.auditInfo("Stopped the proxy service : " + this.name);
        } else {
            this.auditWarn("Unable to stop proxy service : " + this.name + ". Couldn't access Axis configuration");
        }
    }

    private void handleException(String msg) {
        String formattedMSg = this.getFormattedLog(msg);
        this.serviceLog.error((Object)msg);
        log.error((Object)formattedMSg);
        if (this.trace()) {
            trace.error((Object)formattedMSg);
        }
        throw new SynapseException(msg);
    }

    private void handleException(String msg, Exception e) {
        String formattedMSg = this.getFormattedLog(msg);
        this.serviceLog.error((Object)msg);
        log.error((Object)formattedMSg, (Throwable)e);
        if (this.trace()) {
            trace.error((Object)(formattedMSg + " :: " + e.getMessage()));
        }
        throw new SynapseException(msg, e);
    }

    private void auditInfo(String message) {
        String formattedMSg = this.getFormattedLog(message);
        log.info((Object)formattedMSg);
        this.serviceLog.info((Object)message);
        if (this.trace()) {
            trace.info((Object)formattedMSg);
        }
    }

    private String getFormattedLog(String msg) {
        return LoggingUtils.getFormattedLog("proxy", this.getName(), msg);
    }

    private void auditWarn(String message) {
        String formattedMsg = this.getFormattedLog(message);
        log.warn((Object)formattedMsg);
        this.serviceLog.warn((Object)message);
        if (this.trace()) {
            trace.warn((Object)formattedMsg);
        }
    }

    private boolean trace() {
        return this.aspectConfiguration.isTracingEnabled();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList getTransports() {
        return this.transports;
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public Map<String, Object> getParameterMap() {
        return this.parameters;
    }

    public void setTransports(ArrayList transports) {
        this.transports = transports;
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public void setTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
    }

    public String getTargetInSequence() {
        return this.targetInSequence;
    }

    public void setTargetInSequence(String targetInSequence) {
        this.targetInSequence = targetInSequence;
    }

    public String getTargetOutSequence() {
        return this.targetOutSequence;
    }

    public void setTargetOutSequence(String targetOutSequence) {
        this.targetOutSequence = targetOutSequence;
    }

    public String getWSDLKey() {
        return this.wsdlKey;
    }

    public void setWSDLKey(String wsdlKey) {
        this.wsdlKey = wsdlKey;
    }

    public List<String> getServiceLevelPolicies() {
        return this.serviceLevelPolicies;
    }

    public void addServiceLevelPolicy(String serviceLevelPolicy) {
        this.serviceLevelPolicies.add(serviceLevelPolicy);
    }

    public boolean isWsAddrEnabled() {
        return this.wsAddrEnabled;
    }

    public void setWsAddrEnabled(boolean wsAddrEnabled) {
        this.wsAddrEnabled = wsAddrEnabled;
    }

    @Deprecated
    public boolean isWsRMEnabled() {
        return this.wsRMEnabled;
    }

    @Deprecated
    public void setWsRMEnabled(boolean wsRMEnabled) {
        this.wsRMEnabled = wsRMEnabled;
    }

    public boolean isWsSecEnabled() {
        return this.wsSecEnabled;
    }

    public void setWsSecEnabled(boolean wsSecEnabled) {
        this.wsSecEnabled = wsSecEnabled;
    }

    public boolean isStartOnLoad() {
        return this.startOnLoad;
    }

    public void setStartOnLoad(boolean startOnLoad) {
        this.startOnLoad = startOnLoad;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public String getTargetFaultSequence() {
        return this.targetFaultSequence;
    }

    public void setTargetFaultSequence(String targetFaultSequence) {
        this.targetFaultSequence = targetFaultSequence;
    }

    public Object getInLineWSDL() {
        return this.inLineWSDL;
    }

    public void setInLineWSDL(Object inLineWSDL) {
        this.inLineWSDL = inLineWSDL;
    }

    public URI getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(URI wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public Endpoint getTargetInLineEndpoint() {
        return this.targetInLineEndpoint;
    }

    public void setTargetInLineEndpoint(Endpoint targetInLineEndpoint) {
        this.targetInLineEndpoint = targetInLineEndpoint;
    }

    public SequenceMediator getTargetInLineInSequence() {
        return this.targetInLineInSequence;
    }

    public void setTargetInLineInSequence(SequenceMediator targetInLineInSequence) {
        this.targetInLineInSequence = targetInLineInSequence;
    }

    public SequenceMediator getTargetInLineOutSequence() {
        return this.targetInLineOutSequence;
    }

    public void setTargetInLineOutSequence(SequenceMediator targetInLineOutSequence) {
        this.targetInLineOutSequence = targetInLineOutSequence;
    }

    public SequenceMediator getTargetInLineFaultSequence() {
        return this.targetInLineFaultSequence;
    }

    public void setTargetInLineFaultSequence(SequenceMediator targetInLineFaultSequence) {
        this.targetInLineFaultSequence = targetInLineFaultSequence;
    }

    public List getPinnedServers() {
        return this.pinnedServers;
    }

    public void setPinnedServers(List pinnedServers) {
        this.pinnedServers = pinnedServers;
    }

    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(ResourceMap resourceMap) {
        this.resourceMap = resourceMap;
    }

    public List<String> getInMessagePolicies() {
        return this.inMessagePolicies;
    }

    public void setInMessagePolicies(List<String> inMessagePolicies) {
        this.inMessagePolicies = inMessagePolicies;
    }

    public void addInMessagePolicy(String messagePolicy) {
        this.inMessagePolicies.add(messagePolicy);
    }

    public List<String> getOutMessagePolicies() {
        return this.outMessagePolicies;
    }

    public void setOutMessagePolicies(List<String> outMessagePolicies) {
        this.outMessagePolicies = outMessagePolicies;
    }

    public void addOutMessagePolicy(String messagePolicy) {
        this.outMessagePolicies.add(messagePolicy);
    }

    public List<PolicyInfo> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<PolicyInfo> policies) {
        this.policies = policies;
    }

    public void addPolicyInfo(PolicyInfo pi) {
        this.policies.add(pi);
    }

    @Override
    public void configure(AspectConfiguration aspectConfiguration) {
        this.aspectConfiguration = aspectConfiguration;
    }

    @Override
    public AspectConfiguration getAspectConfiguration() {
        return this.aspectConfiguration;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFilePath(URL filePath) {
        this.filePath = filePath;
    }

    public String getServiceGroup() {
        return this.serviceGroup;
    }

    public void setServiceGroup(String serviceGroup) {
        this.serviceGroup = serviceGroup;
    }

    public boolean isModuleEngaged() {
        return this.moduleEngaged;
    }

    public void setModuleEngaged(boolean moduleEngaged) {
        this.moduleEngaged = moduleEngaged;
    }

    public boolean isWsdlPublished() {
        return this.wsdlPublished;
    }

    private AxisOperation processOperationValidation(AxisService proxyService) throws AxisFault {
        InOutAxisOperation mediateOperation = new InOutAxisOperation(SynapseConstants.SYNAPSE_OPERATION_NAME);
        mediateOperation.getMessage("In").setName("in");
        mediateOperation.getMessage("Out").setName("out");
        ProxyServiceMessageReceiver msgRcvr = new ProxyServiceMessageReceiver();
        msgRcvr.setName(this.name);
        msgRcvr.setProxy(this);
        mediateOperation.setMessageReceiver((MessageReceiver)msgRcvr);
        mediateOperation.setParent((AxisDescription)proxyService);
        proxyService.addParameter("_default_mediate_operation_", (Object)mediateOperation);
        return mediateOperation;
    }

    public void registerFaultHandler(MessageContext synCtx) {
        boolean traceOrDebugOn;
        boolean traceOn = this.trace();
        boolean bl = traceOrDebugOn = traceOn || log.isDebugEnabled();
        if (this.targetFaultSequence != null) {
            Mediator faultSequence = synCtx.getSequence(this.targetFaultSequence);
            if (faultSequence != null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Setting the fault-sequence to : " + faultSequence);
                }
                synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getSequence(this.targetFaultSequence)));
            } else {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Unable to find fault-sequence : " + this.targetFaultSequence + "; using default fault sequence");
                }
                synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
            }
        } else if (this.targetInLineFaultSequence != null) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Setting specified anonymous fault-sequence for proxy");
            }
            synCtx.pushFaultHandler(new MediatorFaultHandler(this.targetInLineFaultSequence));
        } else {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Setting default fault-sequence for proxy");
            }
            synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
        }
    }

    private void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
        } else {
            log.debug((Object)msg);
        }
    }

    public void setArtifactContainerName(String name) {
        this.artifactContainerName = name;
    }

    public String getArtifactContainerName() {
        return this.artifactContainerName;
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    private String[] getModuleNames(String propertyValue) {
        if (propertyValue == null || propertyValue.trim().isEmpty()) {
            return null;
        }
        return propertyValue.split(",");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ Proxy Service [ Name : ").append(this.name).append(" ] ]");
        return sb.toString();
    }

    public String getPublishWSDLEndpoint() {
        return this.publishWSDLEndpoint;
    }

    public void setPublishWSDLEndpoint(String publishWSDLEndpoint) {
        this.publishWSDLEndpoint = publishWSDLEndpoint;
    }

    public void setLogSetterValue() {
        CustomLogSetter.getInstance().setLogAppender(this.artifactContainerName);
    }

    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.aspectConfiguration == null) {
            this.aspectConfiguration = new AspectConfiguration(this.name);
        }
        String proxyId = StatisticIdentityGenerator.getIdForComponent(this.name, ComponentType.PROXYSERVICE, holder);
        this.aspectConfiguration.setUniqueId(proxyId);
        String childId = null;
        if (this.targetInSequence != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent(this.targetInSequence, ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        }
        if (this.targetInLineInSequence != null) {
            this.targetInLineInSequence.setComponentStatisticsId(holder);
        }
        if (this.targetEndpoint != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent(this.targetEndpoint, ComponentType.ENDPOINT, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.ENDPOINT, holder);
        }
        if (this.targetInLineEndpoint != null) {
            this.targetInLineEndpoint.setComponentStatisticsId(holder);
        }
        if (this.targetOutSequence != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent(this.targetOutSequence, ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        }
        if (this.targetInLineOutSequence != null) {
            this.targetInLineOutSequence.setComponentStatisticsId(holder);
        }
        if (this.targetFaultSequence != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent(this.targetFaultSequence, ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        }
        if (this.targetInLineFaultSequence != null) {
            this.targetInLineFaultSequence.setComponentStatisticsId(holder);
        }
        StatisticIdentityGenerator.reportingEndEvent(proxyId, ComponentType.PROXYSERVICE, holder);
    }

    public List<String> getCommentsList() {
        return this.commentsList;
    }

    public void setCommentsList(List<String> commentsList) {
        this.commentsList = commentsList;
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroying proxy service with name: " + this.name));
        }
        if (this.targetInLineInSequence != null && this.targetInLineInSequence.isInitialized()) {
            this.targetInLineInSequence.destroy();
        }
        if (this.targetInLineOutSequence != null && this.targetInLineOutSequence.isInitialized()) {
            this.targetInLineOutSequence.destroy();
        }
        if (this.targetInLineFaultSequence != null && this.targetInLineFaultSequence.isInitialized()) {
            this.targetInLineFaultSequence.destroy();
        }
    }
}

