/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseHandler;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.store.MessageDataStore;
import org.apache.synapse.carbonext.TenantInfoConfigurator;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.commons.util.ext.TenantInfoInitiator;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapseHandlersLoader;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.continuation.SeqContinuationState;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.debug.SynapseDebugManager;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.MediatorWorker;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.elementary.Source;
import org.apache.synapse.mediators.elementary.Target;
import org.apache.synapse.rest.RESTRequestHandler;
import org.apache.synapse.task.SynapseTaskManager;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.unittest.UnitTestingExecutor;
import org.apache.synapse.util.CallMediatorEnrichUtil;
import org.apache.synapse.util.concurrent.InboundThreadPool;
import org.apache.synapse.util.concurrent.SynapseThreadPool;
import org.apache.synapse.util.logging.LoggingUtils;
import org.apache.synapse.util.xpath.ext.SynapseXpathFunctionContextProvider;
import org.apache.synapse.util.xpath.ext.SynapseXpathVariableResolver;

public class Axis2SynapseEnvironment
implements SynapseEnvironment {
    private static final Log log = LogFactory.getLog(Axis2SynapseEnvironment.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private SynapseConfiguration synapseConfig;
    private ConfigurationContext configContext;
    private ExecutorService executorService;
    private ExecutorService executorServiceInbound;
    private boolean initialized = false;
    private SynapseTaskManager taskManager;
    private RESTRequestHandler restHandler;
    private List<SynapseHandler> synapseHandlers;
    private long globalTimeout = 86400000L;
    private SynapseDebugManager synapseDebugManager;
    private MessageDataStore messageDataStore = new MessageDataStore();
    private ServerContextInformation contextInformation;
    Map<String, SynapseXpathFunctionContextProvider> xpathFunctionExtensions = new HashMap<String, SynapseXpathFunctionContextProvider>();
    Map<QName, SynapseXpathVariableResolver> xpathVariableExtensions = new HashMap<QName, SynapseXpathVariableResolver>();
    TenantInfoConfigurator tenantInfoConfigurator;
    TenantInfoInitiator tenantInfoInitiator;
    private int callMediatorCount = 0;
    private boolean continuation = false;
    private List<String> unavailableArtifacts = new ArrayList<String>();
    private boolean isDebugEnabled = false;
    private boolean isUnitTestEnabled = false;
    private static final String NO_FAULT_HANDLER_ERROR = "Exception encountered but no fault handler found - message dropped";
    private static final String EXECUTING_FAULT_HANDLER_ERROR = "Executing fault handler due to exception encountered";
    public static final String INTERMEDIATE_ORIGINAL_BODY = "_INTERMEDIATE_ORIGINAL_BODY";
    public static final String TARGET_FOR_INBOUND_PAYLOAD = "_TARGET_FOR_INBOUND_PAYLOAD";
    public static final String ORIGINAL_MESSAGE_TYPE = "_ORIGINAL_MESSAGE_TYPE";
    public static final String SOURCE_MESSAGE_TYPE = "_SOURCE_MESSAGE_TYPE";
    public static final String IS_SOURCE_AVAILABLE = "_IS_SOURCE_AVAILABLE";
    public static final String IS_TARGET_AVAILABLE = "IS_TARGET_AVAILABLE";
    public static final String ORIGINAL_TRANSPORT_HEADERS = "_ORIGINAL_TRANSPORT_HEADERS";
    public static final String ORIGINAL_CONTENT_TYPE = "_ORIGINAL_CONTENT_TYPE";
    public static final String JSON_TYPE = "application/json";

    public Axis2SynapseEnvironment(SynapseConfiguration synCfg) {
        int coreThreads = 20;
        int maxThreads = 100;
        long keepAlive = 5L;
        int qLength = -1;
        try {
            qLength = Integer.parseInt(synCfg.getProperty("synapse.threads.qlen"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            coreThreads = Integer.parseInt(synCfg.getProperty("synapse.threads.core"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            maxThreads = Integer.parseInt(synCfg.getProperty("synapse.threads.max"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            keepAlive = Long.parseLong(synCfg.getProperty("synapse.threads.keepalive"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executorService = new SynapseThreadPool(coreThreads, maxThreads, keepAlive, qLength, synCfg.getProperty("synapse.threads.group", "synapse-thread-group"), synCfg.getProperty("synapse.threads.idprefix", "SynapseWorker"));
        int ibCoreThreads = 20;
        int ibMaxThreads = 100;
        try {
            ibCoreThreads = Integer.parseInt(synCfg.getProperty("inbound.threads.core"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ibMaxThreads = Integer.parseInt(synCfg.getProperty("inbound.threads.max"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executorServiceInbound = new InboundThreadPool(ibCoreThreads, ibMaxThreads, 1L, 1, "inbound-thread-group", "InboundWorker");
        this.taskManager = new SynapseTaskManager();
        this.restHandler = new RESTRequestHandler();
        this.synapseHandlers = SynapseHandlersLoader.loadHandlers();
        this.globalTimeout = SynapseConfigUtils.getGlobalTimeoutInterval();
    }

    public Axis2SynapseEnvironment(ConfigurationContext cfgCtx, SynapseConfiguration synapseConfig) {
        this(synapseConfig);
        this.configContext = cfgCtx;
        this.synapseConfig = synapseConfig;
    }

    public Axis2SynapseEnvironment(ConfigurationContext cfgCtx, SynapseConfiguration synapseConfig, ServerContextInformation contextInformation) {
        this(cfgCtx, synapseConfig);
        this.contextInformation = contextInformation;
        this.setSeverDebugMode(contextInformation);
        this.setSeverUnitTestMode(contextInformation);
    }

    public void setSeverDebugMode(ServerContextInformation contextInformation) {
        if (contextInformation.isServerDebugModeEnabled()) {
            this.setDebugEnabled(true);
            this.synapseDebugManager = contextInformation.getSynapseDebugManager();
            contextInformation.getSynapseDebugManager().init(this.synapseConfig, contextInformation.getSynapseDebugInterface(), this, true);
        }
    }

    private void setSeverUnitTestMode(ServerContextInformation contextInformation) {
        if (Boolean.parseBoolean(System.getProperty("synapseTest"))) {
            this.setUnitTestEnabled(true);
            contextInformation.setServerUnitTestModeEnabled(true);
            log.info((Object)"Synapse unit testing server enabled");
            UnitTestingExecutor testExecutor = UnitTestingExecutor.getExecuteInstance();
            testExecutor.setSynapseConfiguration(this.synapseConfig);
            testExecutor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean injectMessage(MessageContext synCtx) {
        try {
            TransportInDescription trpInDesc;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Injecting MessageContext");
            }
            if (synCtx.getEnvironment().isDebuggerEnabled()) {
                SynapseDebugManager debugManager = synCtx.getEnvironment().getSynapseDebugManager();
                debugManager.acquireMediationFlowLock();
                debugManager.advertiseMediationFlowStartPoint(synCtx);
            }
            if ((trpInDesc = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getTransportIn()) != null) {
                synCtx.setProperty("TRANSPORT_IN_NAME", trpInDesc.getName());
            }
            synCtx.setEnvironment(this);
            if (!this.invokeHandlers(synCtx)) {
                boolean bl = false;
                return bl;
            }
            Mediator mandatorySeq = synCtx.getConfiguration().getMandatorySequence();
            if (mandatorySeq != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Start mediating the message in the pre-mediate state using the mandatory sequence");
                }
                if (!mandatorySeq.mediate(synCtx)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)((synCtx.isResponse() ? "Response" : "Request") + " message for the " + (synCtx.getProperty("proxy.name") != null ? "proxy service " + synCtx.getProperty("proxy.name") : "message mediation") + " dropped in the pre-mediation state by the mandatory sequence : \n" + synCtx));
                    }
                    boolean debugManager = false;
                    return debugManager;
                }
            }
            String receivingSequence = (String)synCtx.getProperty("RECEIVING_SEQUENCE");
            Boolean isContinuationCall = (Boolean)synCtx.getProperty("continuation.call");
            Set keySet = synCtx.getPropertyKeySet();
            if (keySet != null) {
                keySet.remove("RECEIVING_SEQUENCE");
                keySet.remove("continuation.call");
            }
            if (isContinuationCall != null && isContinuationCall.booleanValue() && !synCtx.getContinuationStateStack().isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Response received for the Continuation Call service invocation");
                }
                boolean bl = this.mediateFromContinuationStateStack(synCtx);
                return bl;
            }
            String proxyName = (String)synCtx.getProperty("proxy.name");
            if (proxyName == null || "".equals(proxyName)) {
                synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
                if (receivingSequence != null) {
                    Mediator seqMediator;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using Sequence with name: " + receivingSequence + " for injected message"));
                    }
                    if ((seqMediator = synCtx.getSequence(receivingSequence)) != null) {
                        boolean bl = seqMediator.mediate(synCtx);
                        return bl;
                    }
                    log.warn((Object)("Cannot find a Sequence with name: " + receivingSequence + " for injecting the response message"));
                    boolean bl = false;
                    return bl;
                }
                boolean processed = this.restHandler.process(synCtx);
                if (processed) {
                    boolean bl = true;
                    return bl;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Using Main Sequence for injected message");
                }
                boolean bl = synCtx.getMainSequence().mediate(synCtx);
                return bl;
            }
            ProxyService proxyService = synCtx.getConfiguration().getProxyService(proxyName);
            if (proxyService != null) {
                proxyService.registerFaultHandler(synCtx);
                Mediator outSequence = this.getProxyOutSequence(synCtx, proxyService);
                if (receivingSequence != null) {
                    Mediator seqMediator;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using Sequence with name: " + receivingSequence + " for injected message"));
                    }
                    if ((seqMediator = synCtx.getSequence(receivingSequence)) == null) {
                        log.warn((Object)("Cannot find a Sequence with name: " + receivingSequence + " for injecting the message"));
                        boolean bl = false;
                        return bl;
                    }
                    seqMediator.mediate(synCtx);
                } else if (outSequence != null) {
                    outSequence.mediate(synCtx);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(proxyService + " does not specifies an out-sequence - sending the response back"));
                    }
                    Axis2Sender.sendBack(synCtx);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (synCtx.getEnvironment().isDebuggerEnabled()) {
                SynapseDebugManager debugManager = synCtx.getEnvironment().getSynapseDebugManager();
                debugManager.advertiseMediationFlowTerminatePoint(synCtx);
                debugManager.releaseMediationFlowLock();
            }
        }
    }

    @Override
    public void injectAsync(MessageContext synCtx, SequenceMediator seq) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Injecting MessageContext for asynchronous mediation using the : " + (seq.getName() == null ? "Anonymous" : seq.getName()) + " Sequence"));
        }
        if (RuntimeStatisticCollector.isStatisticsEnabled()) {
            OpenEventCollector.reportFlowAsynchronousEvent(synCtx);
        }
        synCtx.setEnvironment(this);
        this.executorService.execute(new MediatorWorker(seq, synCtx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean injectInbound(MessageContext synCtx, SequenceMediator seq, boolean sequential) throws SynapseException {
        inboundName = null;
        isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        inboundAspectConfiguration = null;
        statisticReportingIndex = null;
        if (Axis2SynapseEnvironment.log.isDebugEnabled()) {
            Axis2SynapseEnvironment.log.debug((Object)("Injecting MessageContext for inbound mediation using the : " + (seq.getName() == null ? "Anonymous" : seq.getName()) + " Sequence"));
        }
        if (synCtx.getProperty("inbound.endpoint.name") != null && (inboundEndpoint = synCtx.getConfiguration().getInboundEndpoint((String)synCtx.getProperty("inbound.endpoint.name"))) != null) {
            CustomLogSetter.getInstance().setLogAppender(inboundEndpoint.getArtifactContainerName());
            if (inboundEndpoint.getAspectConfiguration() != null) {
                inboundAspectConfiguration = inboundEndpoint.getAspectConfiguration();
            }
            inboundName = (String)synCtx.getProperty("inbound.endpoint.name");
        }
        synCtx.setEnvironment(this);
        if (!this.invokeHandlers(synCtx)) {
            return false;
        }
        if (!sequential) {
            block29: {
                try {
                    if (isStatisticsEnabled) {
                        statisticReportingIndex = OpenEventCollector.reportEntryEvent(synCtx, inboundName, inboundAspectConfiguration, ComponentType.INBOUNDENDPOINT);
                    }
                    this.executorServiceInbound.execute(new MediatorWorker(seq, synCtx));
                    inboundEndpoint = true;
                    if (!isStatisticsEnabled) break block29;
                }
                catch (RejectedExecutionException re) {
                    try {
                        Axis2SynapseEnvironment.log.warn((Object)"Inbound worker pool has reached the maximum capacity and will be processing current message sequentially.");
                        ** if (!isStatisticsEnabled) goto lbl-1000
                    }
                    catch (Throwable var9_15) {
                        if (isStatisticsEnabled) {
                            CloseEventCollector.tryEndFlow(synCtx, inboundName, ComponentType.INBOUNDENDPOINT, statisticReportingIndex, false);
                        }
                        throw var9_15;
                    }
lbl-1000:
                    // 1 sources

                    {
                        CloseEventCollector.tryEndFlow(synCtx, inboundName, ComponentType.INBOUNDENDPOINT, statisticReportingIndex, false);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                CloseEventCollector.tryEndFlow(synCtx, inboundName, ComponentType.INBOUNDENDPOINT, statisticReportingIndex, false);
            }
            return inboundEndpoint;
        }
        if (isStatisticsEnabled) {
            statisticReportingIndex = OpenEventCollector.reportEntryEvent(synCtx, inboundName, inboundAspectConfiguration, ComponentType.INBOUNDENDPOINT);
        }
        try {
            if (synCtx.getEnvironment().isDebuggerEnabled()) {
                debugManager = synCtx.getEnvironment().getSynapseDebugManager();
                debugManager.acquireMediationFlowLock();
                debugManager.advertiseMediationFlowStartPoint(synCtx);
            }
            seq.mediate(synCtx);
            debugManager = true;
            return debugManager;
        }
        catch (SynapseException syne) {
            if (!synCtx.getFaultStack().isEmpty()) {
                Axis2SynapseEnvironment.log.warn((Object)LoggingUtils.getFormattedLog(synCtx, "Executing fault handler due to exception encountered"));
                synCtx.getFaultStack().pop().handleFault(synCtx, syne);
                debugManager = true;
                return debugManager;
            }
            Axis2SynapseEnvironment.log.warn((Object)LoggingUtils.getFormattedLog(synCtx, "Exception encountered but no fault handler found - message dropped"));
            throw syne;
        }
        catch (Exception e) {
            msg = "Unexpected error executing task/async inject";
            Axis2SynapseEnvironment.log.error((Object)LoggingUtils.getFormattedLog(synCtx, msg), (Throwable)e);
            if (synCtx.getServiceLog() != null) {
                synCtx.getServiceLog().error((Object)msg, (Throwable)e);
            }
            if (!synCtx.getFaultStack().isEmpty()) {
                Axis2SynapseEnvironment.log.warn((Object)LoggingUtils.getFormattedLog(synCtx, "Executing fault handler due to exception encountered"));
                synCtx.getFaultStack().pop().handleFault(synCtx, e);
                var10_21 = true;
                return var10_21;
            }
            Axis2SynapseEnvironment.log.warn((Object)LoggingUtils.getFormattedLog(synCtx, "Exception encountered but no fault handler found - message dropped"));
            throw new SynapseException("Exception encountered but no fault handler found - message dropped", e);
        }
        catch (Throwable e) {
            msg = "Unexpected error executing inbound/async inject, message dropped";
            Axis2SynapseEnvironment.log.error((Object)LoggingUtils.getFormattedLog(synCtx, msg), e);
            if (synCtx.getServiceLog() != null) {
                synCtx.getServiceLog().error((Object)msg, e);
            }
            throw new SynapseException(msg, e);
        }
        finally {
            if (isStatisticsEnabled) {
                CloseEventCollector.tryEndFlow(synCtx, inboundName, ComponentType.INBOUNDENDPOINT, statisticReportingIndex, false);
            }
            if (synCtx.getEnvironment().isDebuggerEnabled()) {
                debugManager = synCtx.getEnvironment().getSynapseDebugManager();
                debugManager.advertiseMediationFlowTerminatePoint(synCtx);
                debugManager.releaseMediationFlowLock();
            }
        }
    }

    @Override
    public void send(EndpointDefinition endpoint, MessageContext synCtx) {
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().removeProperty("rampart_engaged");
        if (synCtx.isResponse()) {
            if (endpoint != null) {
                if (this.isTransportSwitching(synCtx, endpoint)) {
                    this.buildMessage(synCtx);
                }
                Axis2Sender.sendOn(endpoint, synCtx);
            } else {
                Boolean isInboundJMS;
                String proxyName = (String)synCtx.getProperty("proxy.name");
                boolean serviceModuleEngaged = false;
                if (proxyName != null) {
                    ProxyService proxyService = this.synapseConfig.getProxyService(proxyName);
                    serviceModuleEngaged = proxyService.isModuleEngaged();
                }
                if (serviceModuleEngaged || this.isTransportSwitching(synCtx, null)) {
                    this.buildMessage(synCtx);
                }
                if ((isInboundJMS = (Boolean)synCtx.getProperty("INBOUND_JMS_PROTOCOL")) != null && isInboundJMS.booleanValue()) {
                    this.buildMessage(synCtx);
                }
                Axis2Sender.sendBack(synCtx);
            }
        } else {
            Dispatcher dispatcher = (Dispatcher)synCtx.getProperty("synape.sal.endpoints.dispatcher");
            if (dispatcher != null && !dispatcher.isServerInitiatedSession()) {
                dispatcher.updateSession(synCtx);
            }
            synCtx.setProperty("synapse.internal.request.sending", true);
            if (endpoint == null || this.isTransportSwitching(synCtx, endpoint)) {
                this.buildMessage(synCtx);
            }
            Axis2Sender.sendOn(endpoint, synCtx);
        }
    }

    @Override
    public MessageContext createMessageContext() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating Message Context");
        }
        org.apache.axis2.context.MessageContext axis2MC = new org.apache.axis2.context.MessageContext();
        axis2MC.setConfigurationContext(this.configContext);
        ServiceContext svcCtx = new ServiceContext();
        OperationContext opCtx = new OperationContext((AxisOperation)new InOutAxisOperation(), svcCtx);
        axis2MC.setServiceContext(svcCtx);
        axis2MC.setOperationContext(opCtx);
        Axis2MessageContext mc = new Axis2MessageContext(axis2MC, this.synapseConfig, this);
        mc.setMessageID(UIDGenerator.generateURNString());
        try {
            mc.setEnvelope(OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope());
            mc.getEnvelope().addChild((OMNode)OMAbstractFactory.getSOAP12Factory().createSOAPBody());
        }
        catch (Exception e) {
            this.handleException("Unable to attach the SOAP envelope to the created new message context", e);
        }
        return mc;
    }

    @Override
    public OverflowBlob createOverflowBlob() {
        String chkSize = this.synapseConfig.getProperty("synapse.temp_data.chunk.size");
        String chunkNumber = this.synapseConfig.getProperty("synapse.temp_data.chunk.threshold");
        int numberOfChunks = 8;
        int chunkSize = 1024;
        if (chkSize != null) {
            chunkSize = Integer.parseInt(chkSize);
        }
        if (chunkNumber != null) {
            numberOfChunks = Integer.parseInt(chunkNumber);
        }
        String tempPrefix = this.synapseConfig.getProperty("synapse.tempfile.prefix", "tmp_");
        String tempSuffix = this.synapseConfig.getProperty("synapse.tempfile.sufix", ".dat");
        return new OverflowBlob(numberOfChunks, chunkSize, tempPrefix, tempSuffix);
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean state) {
        this.initialized = state;
    }

    @Override
    public SynapseConfiguration getSynapseConfiguration() {
        return this.synapseConfig;
    }

    @Override
    public MessageDataStore getMessageDataStore() {
        return this.messageDataStore;
    }

    @Override
    public SynapseTaskManager getTaskManager() {
        return this.taskManager;
    }

    @Override
    public ServerContextInformation getServerContextInformation() {
        return this.contextInformation;
    }

    public ConfigurationContext getAxis2ConfigurationContext() {
        return this.configContext;
    }

    @Override
    public Map<String, SynapseXpathFunctionContextProvider> getXpathFunctionExtensions() {
        return this.xpathFunctionExtensions;
    }

    @Override
    public Map<QName, SynapseXpathVariableResolver> getXpathVariableExtensions() {
        return this.xpathVariableExtensions;
    }

    @Override
    public TenantInfoConfigurator getTenantInfoConfigurator() {
        return this.tenantInfoConfigurator;
    }

    public TenantInfoInitiator getTenantInfoInitiator() {
        return this.tenantInfoInitiator;
    }

    public void setXpathFunctionExtensions(SynapseXpathFunctionContextProvider functionExt) {
        if (functionExt != null) {
            this.xpathFunctionExtensions.put(functionExt.getResolvingQName(), functionExt);
        }
    }

    public void setXpathVariableExtensions(SynapseXpathVariableResolver variableExt) {
        if (variableExt != null) {
            this.xpathVariableExtensions.put(variableExt.getResolvingQName(), variableExt);
        }
    }

    public void setTenantInfoConfigurator(TenantInfoConfigurator configurator) {
        if (configurator != null) {
            this.tenantInfoConfigurator = configurator;
        }
    }

    public void setTenantInfoInitiator(TenantInfoInitiator initiator) {
        if (initiator != null) {
            this.tenantInfoInitiator = initiator;
        }
    }

    private boolean mediateFromContinuationStateStack(MessageContext synCtx) {
        SeqContinuationState seqContinuationState;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Mediating response using the ContinuationStateStack");
        }
        if (synCtx.getContinuationStateStack().isEmpty()) {
            log.warn((Object)"ContinuationStateStack empty. No ContinuationState to mediate the response ");
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start : Contents of Continuation Stack");
            for (ContinuationState state : synCtx.getContinuationStateStack()) {
                SeqContinuationState seqstate = (SeqContinuationState)state;
                log.debug((Object)("Sequence Type : " + (Object)((Object)seqstate.getSeqType()) + " Sequence Name : " + seqstate.getSeqName()));
            }
            log.debug((Object)"End : Contents of Continuation Stack");
        }
        if (RuntimeStatisticCollector.isStatisticsEnabled()) {
            OpenEventCollector.openContinuationEvents(synCtx);
        }
        if ((seqContinuationState = (SeqContinuationState)ContinuationStackManager.peakContinuationStateStack(synCtx)) == null) {
            return false;
        }
        this.callMediatorPostMediate(synCtx);
        boolean result = false;
        while ((seqContinuationState = (SeqContinuationState)ContinuationStackManager.peakContinuationStateStack(synCtx)) != null) {
            SequenceMediator sequenceMediator = ContinuationStackManager.retrieveSequence(synCtx, seqContinuationState);
            result = sequenceMediator.mediate(synCtx, seqContinuationState);
            if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                sequenceMediator.reportCloseStatistics(synCtx, null);
            }
            if (result && !synCtx.getContinuationStateStack().isEmpty()) continue;
        }
        return result;
    }

    private void callMediatorPostMediate(MessageContext response) {
        Target targetForInboundPayload = (Target)response.getProperty(TARGET_FOR_INBOUND_PAYLOAD);
        String sourceMessageType = (String)response.getProperty(SOURCE_MESSAGE_TYPE);
        String originalMessageType = (String)response.getProperty(ORIGINAL_MESSAGE_TYPE);
        boolean isSourceAvailable = (Boolean)response.getProperty(IS_SOURCE_AVAILABLE);
        boolean isTargetAvailable = (Boolean)response.getProperty(IS_TARGET_AVAILABLE);
        String originalContentType = (String)response.getProperty(ORIGINAL_CONTENT_TYPE);
        Map originalTransportHeaders = (Map)response.getProperty(ORIGINAL_TRANSPORT_HEADERS);
        if (isTargetAvailable) {
            CallMediatorEnrichUtil.buildMessage(response);
        }
        if (isTargetAvailable && isSourceAvailable) {
            Source sourceForResponsePayload = CallMediatorEnrichUtil.createSourceWithBody();
            Source sourceForOriginalPayload = CallMediatorEnrichUtil.createSourceWithProperty(INTERMEDIATE_ORIGINAL_BODY);
            Target targetForResponsePayload = CallMediatorEnrichUtil.createTargetWithBody();
            CallMediatorEnrichUtil.doEnrich(response, sourceForResponsePayload, targetForInboundPayload, sourceMessageType);
            CallMediatorEnrichUtil.doEnrich(response, sourceForOriginalPayload, targetForResponsePayload, originalMessageType);
            CallMediatorEnrichUtil.preservetransportHeaders(response, originalTransportHeaders);
            if (!sourceMessageType.equalsIgnoreCase(originalMessageType)) {
                CallMediatorEnrichUtil.setContentType(response, originalMessageType, originalContentType);
                if (sourceMessageType.equalsIgnoreCase(JSON_TYPE)) {
                    JsonUtil.removeJsonStream((org.apache.axis2.context.MessageContext)((Axis2MessageContext)response).getAxis2MessageContext());
                }
            }
        } else if (isTargetAvailable) {
            Source sourceForResponsePayload = CallMediatorEnrichUtil.createSourceWithBody();
            CallMediatorEnrichUtil.doEnrich(response, sourceForResponsePayload, targetForInboundPayload, sourceMessageType);
        }
        response.setProperty(IS_SOURCE_AVAILABLE, false);
        response.setProperty(IS_TARGET_AVAILABLE, false);
    }

    private boolean isTransportSwitching(MessageContext synCtx, EndpointDefinition endpoint) {
        if (endpoint != null) {
            if (endpoint.getAddress() != null) {
                return !endpoint.getDynamicAddress(synCtx).startsWith("http");
            }
            String address = synCtx.getTo().getAddress();
            if (address != null) {
                return !address.startsWith("http");
            }
        } else {
            String transportOutName;
            TransportOutDescription transportOut = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getTransportOut();
            if (transportOut != null && (transportOutName = transportOut.getName()) != null) {
                return !transportOutName.startsWith("http");
            }
        }
        return false;
    }

    private void buildMessage(MessageContext synCtx) {
        try {
            RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (boolean)false);
        }
        catch (Exception e) {
            this.handleException("Error while building message", e);
        }
    }

    private void handleException(String message, Throwable e) {
        log.error((Object)message, e);
        throw new SynapseException(message, e);
    }

    private Mediator getProxyOutSequence(MessageContext synCtx, ProxyService proxyService) {
        String sequenceName = proxyService.getTargetOutSequence();
        if (sequenceName != null && !"".equals(sequenceName)) {
            Mediator outSequence = synCtx.getSequence(sequenceName);
            if (outSequence != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using the sequence named " + sequenceName + " for the outgoing message mediation of the proxy service " + proxyService));
                }
                return outSequence;
            }
            log.error((Object)("Unable to find the out-sequence specified by the name " + sequenceName));
            throw new SynapseException("Unable to find the out-sequence specified by the name " + sequenceName);
        }
        SequenceMediator outSequence = proxyService.getTargetInLineOutSequence();
        if (outSequence != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using the anonymous out-sequence specified in the proxy service " + proxyService + " for outgoing message mediation"));
            }
            return outSequence;
        }
        return null;
    }

    @Override
    public synchronized void updateCallMediatorCount(boolean isIncrement) {
        if (isIncrement) {
            ++this.callMediatorCount;
            if (!this.continuation) {
                log.info((Object)"Continuation call is set to true");
            }
            this.continuation = true;
        } else {
            --this.callMediatorCount;
            if (this.callMediatorCount == 0) {
                this.continuation = false;
                log.info((Object)"Continuation call is set to false");
            }
        }
    }

    @Override
    public boolean isContinuationEnabled() {
        return this.continuation;
    }

    @Override
    public synchronized void addUnavailableArtifactRef(String key) {
        this.unavailableArtifacts.add(key);
        this.updateCallMediatorCount(true);
    }

    @Override
    public synchronized void removeUnavailableArtifactRef(String key) {
        if (this.unavailableArtifacts.contains(key)) {
            this.unavailableArtifacts.remove(key);
            this.updateCallMediatorCount(false);
        }
    }

    @Override
    public synchronized void clearUnavailabilityOfArtifact(String key) {
        if (!this.unavailableArtifacts.contains(key)) {
            return;
        }
        Iterator<String> itr = this.unavailableArtifacts.iterator();
        while (itr.hasNext()) {
            if (!key.equals(itr.next())) continue;
            itr.remove();
            this.updateCallMediatorCount(false);
        }
    }

    @Override
    public List<SynapseHandler> getSynapseHandlers() {
        return this.synapseHandlers;
    }

    @Override
    public void registerSynapseHandler(SynapseHandler handler) {
        this.synapseHandlers.add(handler);
    }

    @Override
    public long getGlobalTimeout() {
        return this.globalTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean injectMessage(MessageContext smc, SequenceMediator seq) {
        InboundEndpoint inboundEndpoint2;
        AspectConfiguration inboundAspectConfiguration = null;
        String inboundName = null;
        boolean isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        Integer statisticReportingIndex = null;
        if (smc.getProperty("inbound.endpoint.name") != null && (inboundEndpoint2 = smc.getConfiguration().getInboundEndpoint((String)smc.getProperty("inbound.endpoint.name"))) != null) {
            CustomLogSetter.getInstance().setLogAppender(inboundEndpoint2.getArtifactContainerName());
            inboundName = (String)smc.getProperty("inbound.endpoint.name");
            if (inboundEndpoint2.getAspectConfiguration() != null) {
                inboundAspectConfiguration = inboundEndpoint2.getAspectConfiguration();
            }
        }
        if (seq == null) {
            log.error((Object)"Please provide existing sequence");
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Injecting MessageContext for asynchronous mediation using the : " + (seq.getName() == null ? "Anonymous" : seq.getName()) + " Sequence"));
        }
        smc.setEnvironment(this);
        if (!this.invokeHandlers(smc)) {
            return false;
        }
        try {
            if (isStatisticsEnabled && inboundName != null) {
                statisticReportingIndex = OpenEventCollector.reportEntryEvent(smc, inboundName, inboundAspectConfiguration, ComponentType.INBOUNDENDPOINT);
            }
            seq.mediate(smc);
            boolean inboundEndpoint2 = true;
            return inboundEndpoint2;
        }
        catch (SynapseException syne) {
            if (!smc.getFaultStack().isEmpty()) {
                this.warn(false, EXECUTING_FAULT_HANDLER_ERROR, smc);
                smc.getFaultStack().pop().handleFault(smc, syne);
            } else {
                this.warn(false, NO_FAULT_HANDLER_ERROR, smc);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            String msg = "Unexpected error executing  injecting message to sequence ," + seq;
            log.error((Object)LoggingUtils.getFormattedLog(smc, msg), (Throwable)e);
            if (smc.getServiceLog() != null) {
                smc.getServiceLog().error((Object)msg, (Throwable)e);
            }
            if (!smc.getFaultStack().isEmpty()) {
                this.warn(false, EXECUTING_FAULT_HANDLER_ERROR, smc);
                smc.getFaultStack().pop().handleFault(smc, e);
            } else {
                this.warn(false, NO_FAULT_HANDLER_ERROR, smc);
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            String msg = "Unexpected error executing  injecting message to sequence ," + seq + " message dropped";
            log.error((Object)LoggingUtils.getFormattedLog(smc, msg), e);
            if (smc.getServiceLog() != null) {
                smc.getServiceLog().error((Object)msg, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (isStatisticsEnabled && inboundName != null) {
                CloseEventCollector.tryEndFlow(smc, inboundName, ComponentType.INBOUNDENDPOINT, statisticReportingIndex, false);
            }
        }
    }

    private void warn(boolean traceOn, String msg, MessageContext msgContext) {
        String formattedLog = LoggingUtils.getFormattedLog(msgContext, msg);
        if (traceOn) {
            trace.warn((Object)formattedLog);
        }
        log.warn((Object)formattedLog);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().warn((Object)msg);
        }
    }

    private boolean invokeHandlers(MessageContext synCtx) {
        block4: {
            Iterator<SynapseHandler> iterator = synCtx.getEnvironment().getSynapseHandlers().iterator();
            if (!iterator.hasNext()) break block4;
            Boolean isContinuationCall = (Boolean)synCtx.getProperty("continuation.call");
            if (synCtx.isResponse() || isContinuationCall != null && isContinuationCall.booleanValue()) {
                while (iterator.hasNext()) {
                    SynapseHandler handler = iterator.next();
                    if (handler.handleResponseInFlow(synCtx)) continue;
                    return false;
                }
            } else {
                while (iterator.hasNext()) {
                    SynapseHandler handler = iterator.next();
                    if (handler.handleRequestInFlow(synCtx)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public SynapseDebugManager getSynapseDebugManager() {
        return this.synapseDebugManager;
    }

    public void setSynapseDebugManager(SynapseDebugManager synapseDebugManager) {
        this.synapseDebugManager = synapseDebugManager;
    }

    @Override
    public boolean isDebuggerEnabled() {
        return this.isDebugEnabled;
    }

    public boolean isUnitTestEnabled() {
        return this.isUnitTestEnabled;
    }

    public void setDebugEnabled(boolean isDebugEnabled) {
        this.isDebugEnabled = isDebugEnabled;
    }

    public void setUnitTestEnabled(boolean isUnitTestEnabled) {
        this.isUnitTestEnabled = isUnitTestEnabled;
    }
}

