/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.engine.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseHandler;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessController;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessReplicator;
import org.apache.synapse.core.axis2.Axis2FlexibleMEPClient;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.ResponseState;
import org.apache.synapse.core.axis2.SOAPUtils;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.inbound.InboundResponseSender;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.util.MediatorPropertyUtils;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.POXUtils;
import org.apache.synapse.util.logging.LoggingUtils;

public class Axis2Sender {
    private static final Log log = LogFactory.getLog(Axis2Sender.class);
    private static final String CONTENT_TYPE_STRING = "Content-Type";

    public static void sendOn(EndpointDefinition endpoint, MessageContext synapseInMessageContext) {
        try {
            for (SynapseHandler handler : synapseInMessageContext.getEnvironment().getSynapseHandlers()) {
                if (handler.handleRequestOutFlow(synapseInMessageContext)) continue;
                return;
            }
            Axis2FlexibleMEPClient.send(endpoint, synapseInMessageContext);
        }
        catch (Exception e) {
            Axis2Sender.handleException("Unexpected error during sending message out", e, synapseInMessageContext);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sendBack(MessageContext smc) {
        if (Axis2Sender.preventMultipleResponses(smc)) {
            return;
        }
        org.apache.axis2.context.MessageContext messageContext = ((Axis2MessageContext)smc).getAxis2MessageContext();
        if (messageContext.isDoingREST() && messageContext.isFault() && Axis2Sender.isMessagePayloadHasASOAPFault(messageContext)) {
            POXUtils.convertSOAPFaultToPOX(messageContext);
        }
        try {
            String preserveAddressingProperty;
            messageContext.setProperty("synapse.isresponse", (Object)Boolean.TRUE);
            if (AddressingHelper.isReplyRedirected((org.apache.axis2.context.MessageContext)messageContext) && !messageContext.getReplyTo().hasNoneAddress()) {
                messageContext.setTo(messageContext.getReplyTo());
                messageContext.setReplyTo(null);
                messageContext.setWSAAction("");
                messageContext.setSoapAction("");
                messageContext.setProperty("IGNORE_SC_ACCEPTED", (Object)"true");
                messageContext.setProperty("disableAddressingForOutMessages", (Object)Boolean.FALSE);
            }
            if (messageContext.getEnvelope().hasFault() && AddressingHelper.isFaultRedirected((org.apache.axis2.context.MessageContext)messageContext) && (messageContext.getFaultTo() == null || !messageContext.getFaultTo().hasNoneAddress())) {
                messageContext.setTo(messageContext.getFaultTo());
                messageContext.setFaultTo(null);
                messageContext.setWSAAction("");
                messageContext.setSoapAction("");
                messageContext.setProperty("IGNORE_SC_ACCEPTED", (Object)"true");
                messageContext.setProperty("disableAddressingForOutMessages", (Object)Boolean.FALSE);
            }
            if ((preserveAddressingProperty = (String)smc.getProperty("PRESERVE_WS_ADDRESSING")) != null && Boolean.parseBoolean(preserveAddressingProperty)) {
                messageContext.setProperty("ReplaceAddressingHeaders", (Object)"true");
                messageContext.setMessageID(smc.getMessageID());
            } else {
                MessageHelper.removeAddressingHeaders(messageContext);
                messageContext.setMessageID(UIDGenerator.generateURNString());
            }
            String preserveHeaderProperty = (String)smc.getProperty("preserveProcessedHeaders");
            if (preserveHeaderProperty == null || !Boolean.parseBoolean(preserveHeaderProperty)) {
                MessageHelper.removeProcessedHeaders(messageContext, preserveAddressingProperty != null && Boolean.parseBoolean(preserveAddressingProperty));
            }
            if (messageContext.isEngaged("rampart") && messageContext.getEnvelope().getHeader() == null) {
                SOAPFactory fac = messageContext.isSOAP11() ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
                fac.createSOAPHeader(messageContext.getEnvelope());
            }
            Axis2FlexibleMEPClient.clearSecurtityProperties(messageContext.getOptions());
            for (SynapseHandler handler : smc.getEnvironment().getSynapseHandlers()) {
                if (handler.handleResponseOutFlow(smc)) continue;
                return;
            }
            Axis2Sender.doSOAPFormatConversion(smc);
            messageContext.setServerSide(true);
            Axis2Sender.handleConcurrentThrottleCount(smc);
            if (smc.getProperty("isInbound") != null && ((Boolean)smc.getProperty("isInbound")).booleanValue()) {
                if (smc.getProperty("inbound-response-worker") != null) {
                    InboundResponseSender inboundResponseSender = (InboundResponseSender)smc.getProperty("inbound-response-worker");
                    inboundResponseSender.sendBack(smc);
                    return;
                }
                String msg = "Inbound Response Sender not found - Inbound Endpoint may not support sending a response back";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            AxisEngine.send((org.apache.axis2.context.MessageContext)messageContext);
            return;
        }
        catch (AxisFault e) {
            Axis2Sender.handleException(Axis2Sender.getResponseMessage(messageContext), (Exception)((Object)e), smc);
        }
    }

    private static boolean isMessagePayloadHasASOAPFault(org.apache.axis2.context.MessageContext axis2Ctx) {
        String nsURI;
        OMNamespace ns;
        OMElement element;
        SOAPBody body = axis2Ctx.getEnvelope().getBody();
        return body != null && (element = body.getFirstElement()) != null && "Fault".equalsIgnoreCase(element.getLocalName()) && (ns = element.getNamespace()) != null && ("http://schemas.xmlsoap.org/soap/envelope".equals(nsURI = ns.getNamespaceURI()) || "http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI) || "http://www.w3.org/2003/05/soap-envelope".equals(nsURI) || "http://www.w3.org/2003/05/soap-envelope/".equals(nsURI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean preventMultipleResponses(MessageContext messageContext) {
        Object responseStateObj = messageContext.getProperty("__SYNAPSE_RESPONSE_STATE__");
        if (responseStateObj != null) {
            if (responseStateObj instanceof ResponseState) {
                ResponseState responseState;
                ResponseState responseState2 = responseState = (ResponseState)responseStateObj;
                synchronized (responseState2) {
                    if (responseState.isRespondDone()) {
                        log.warn((Object)("Trying to send a response to an already responded client request - " + Axis2Sender.getInputInfo(messageContext)));
                        return true;
                    }
                    responseState.setRespondDone();
                }
            } else {
                Axis2Sender.handleException("Response State must be of type : " + ResponseState.class + ". " + "__SYNAPSE_RESPONSE_STATE__" + " must not be used as an user property name", null, messageContext);
            }
        }
        return false;
    }

    private static void handleException(String msg, Exception e, MessageContext msgCtx) {
        String formattedLog = LoggingUtils.getFormattedLog(msgCtx, msg);
        log.error((Object)formattedLog, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static String getResponseMessage(org.apache.axis2.context.MessageContext msgContext) {
        StringBuilder sb = new StringBuilder();
        try {
            Map mHeader;
            String strEndpoint = (String)msgContext.getProperty("ENDPOINT_PREFIX");
            if (strEndpoint != null) {
                sb.append(strEndpoint + ", ");
            }
            if ((mHeader = (Map)msgContext.getProperty("TRANSPORT_HEADERS")) != null) {
                for (String strKey : mHeader.keySet()) {
                    sb.append(strKey + ":" + mHeader.get(strKey).toString() + ",");
                }
            }
            sb.append(" Unexpected error sending message back");
        }
        catch (Exception e) {
            sb.append(" Unexpected error sending message back");
        }
        return sb.toString();
    }

    private static String getInputInfo(MessageContext smc) {
        String inputInfo = null;
        if (smc.getProperty("proxy.name") != null) {
            inputInfo = "Proxy Name : " + smc.getProperty("proxy.name");
        } else if (smc.getProperty("REST_API_CONTEXT") != null) {
            inputInfo = "Rest API Context : " + smc.getProperty("REST_API_CONTEXT");
        } else if (smc.getProperty("inbound.endpoint.name") != null) {
            inputInfo = "Inbound endpoint : " + smc.getProperty("inbound.endpoint.name");
        }
        return inputInfo;
    }

    private static void doSOAPFormatConversion(MessageContext synCtx) throws AxisFault {
        Map headersMap;
        Object responseContentType;
        Object isClientDoingRest = synCtx.getProperty("IsClientDoingREST");
        if (isClientDoingRest == null) {
            return;
        }
        if (((Boolean)isClientDoingRest).booleanValue()) {
            return;
        }
        if ("true".equals(((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("enableMTOM"))) {
            return;
        }
        Object isClientDoingSOAP11Obj = synCtx.getProperty("IsClientDoingSOAP11");
        boolean isResponseSOAP11 = false;
        boolean isResponseSOAP12 = false;
        org.apache.axis2.context.MessageContext responseCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object headers = responseCtx.getProperty("TRANSPORT_HEADERS");
        if (headers != null && headers instanceof Map && (responseContentType = (headersMap = (Map)headers).get(CONTENT_TYPE_STRING)) != null && responseContentType instanceof String) {
            if (((String)responseContentType).trim().startsWith("text/xml") && !responseCtx.isDoingREST()) {
                isResponseSOAP11 = true;
            } else if (((String)responseContentType).trim().startsWith("application/soap+xml")) {
                isResponseSOAP12 = true;
            }
        }
        if (((Boolean)isClientDoingSOAP11Obj).booleanValue()) {
            if (!isResponseSOAP12 && !responseCtx.isDoingREST()) {
                return;
            }
            try {
                RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (boolean)false);
            }
            catch (Exception e) {
                Axis2Sender.handleException("Error while building message", e, synCtx);
            }
            try {
                MediatorPropertyUtils.serializeOMElement(synCtx);
            }
            catch (Exception e) {
                Axis2Sender.handleException("Error while serializing the  message", e, synCtx);
            }
            if (!responseCtx.isSOAP11()) {
                SOAPUtils.convertSOAP12toSOAP11(responseCtx);
            }
            responseCtx.setProperty("messageType", (Object)"text/xml");
            responseCtx.setProperty("ContentType", (Object)"text/xml");
        } else {
            if (!isResponseSOAP11 && !responseCtx.isDoingREST()) {
                return;
            }
            try {
                RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (boolean)false);
            }
            catch (Exception e) {
                Axis2Sender.handleException("Error while building message", e, synCtx);
            }
            if (responseCtx.isSOAP11()) {
                SOAPUtils.convertSOAP11toSOAP12(responseCtx);
            }
            responseCtx.setProperty("messageType", (Object)"application/soap+xml");
            responseCtx.setProperty("ContentType", (Object)"application/soap+xml");
        }
        responseCtx.setDoingREST(false);
    }

    private static void handleConcurrentThrottleCount(MessageContext smc) {
        Boolean isConcurrencyThrottleEnabled = (Boolean)smc.getProperty("synapse.concurrency.throttle");
        Boolean isAccessAllowed = (Boolean)smc.getProperty("synapse.is.concurrent.access.allowed");
        if (isAccessAllowed != null && isAccessAllowed.booleanValue() && isConcurrencyThrottleEnabled != null && isConcurrencyThrottleEnabled.booleanValue()) {
            ConcurrentAccessController concurrentAccessController = (ConcurrentAccessController)smc.getProperty("synapse.concurrent.access.controller");
            int available = concurrentAccessController.incrementAndGet();
            int concurrentLimit = concurrentAccessController.getLimit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Concurrency Throttle : Connection returned :: " + available + " of available of " + concurrentLimit + " connections"));
            }
            ConcurrentAccessReplicator concurrentAccessReplicator = (ConcurrentAccessReplicator)smc.getProperty("synapse.concurrent.access.replicator");
            String throttleKey = (String)smc.getProperty("synapse.concurrency.throttle.key");
            if (concurrentAccessReplicator != null) {
                concurrentAccessReplicator.replicate(throttleKey, Boolean.valueOf(true));
            }
        }
    }
}

